/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.flurry.android.FlurryAgentListener;
import com.flurry.android.ads.FlurryAdErrorType;
import com.flurry.android.ads.FlurryAdNative;
import com.flurry.android.ads.FlurryAdNativeAsset;
import com.flurry.android.ads.FlurryAdNativeListener;
import com.flurry.android.ads.FlurryAdTargeting;
import com.mopub.mobileads.FlurryAgentWrapper;
import com.mopub.nativeads.BaseNativeAd;
import com.mopub.nativeads.CustomEventNative;
import com.mopub.nativeads.FlurryBaseNativeAd;
import com.mopub.nativeads.NativeErrorCode;
import com.mopub.nativeads.NativeImageHelper;
import com.mopub.nativeads.StaticNativeAd;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class FlurryCustomEventNative
extends CustomEventNative {
    public static final String EXTRA_STAR_RATING_IMG = "flurry_starratingimage";
    public static final String EXTRA_APP_CATEGORY = "flurry_appcategorytext";
    public static final String EXTRA_SEC_BRANDING_LOGO = "flurry_brandingimage";
    public static final String EXTRA_SEC_ADVERTISER_NAME = "flurry_advertisername";
    public static final String LOCAL_EXTRA_TEST_MODE = "enableTestMode";
    private static final String LOG_TAG = FlurryCustomEventNative.class.getSimpleName();
    private static final String ASSET_SEC_HQ_IMAGE = "secHqImage";
    private static final String ASSET_SEC_IMAGE = "secImage";
    private static final String ASSET_SEC_HQ_RATING_IMG = "secHqRatingImg";
    private static final String ASSET_SEC_HQ_BRANDING_LOGO = "secHqBrandingLogo";
    private static final String ASSET_SEC_RATING_IMG = "secRatingImg";
    private static final String ASSET_APP_RATING = "appRating";
    private static final String ASSET_APP_CATEGORY = "appCategory";
    private static final String ASSET_HEADLINE = "headline";
    private static final String ASSET_SUMMARY = "summary";
    private static final String ASSET_CALL_TO_ACTION = "callToAction";
    private static final String ASSET_VIDEO = "videoUrl";
    private static final String ASSET_ADVERTISER_NAME = "source";
    private static final double MOPUB_STAR_RATING_SCALE = 5.0;
    private FlurryAgentListener mFlurryAgentListener;
    private static final List<FlurryAdNative> sFlurryNativeAds = new ArrayList<FlurryAdNative>();

    protected void loadNativeAd(final @NonNull Context context, final @NonNull CustomEventNative.CustomEventNativeListener customEventNativeListener, final @NonNull Map<String, Object> localExtras, @NonNull Map<String, String> serverExtras) {
        if (this.validateExtras(serverExtras)) {
            String flurryApiKey = serverExtras.get("apiKey");
            final String flurryAdSpace = serverExtras.get("adSpaceName");
            if (FlurryAgentWrapper.getInstance().isSessionActive() || this.mFlurryAgentListener != null) {
                this.fetchFlurryAd(context, flurryAdSpace, localExtras, customEventNativeListener);
            } else {
                this.mFlurryAgentListener = new FlurryAgentListener(){

                    public void onSessionStarted() {
                        FlurryCustomEventNative.this.fetchFlurryAd(context, flurryAdSpace, localExtras, customEventNativeListener);
                    }
                };
                FlurryAgentWrapper.getInstance().startSession(context, flurryApiKey, this.mFlurryAgentListener);
            }
        } else {
            customEventNativeListener.onNativeAdFailed(NativeErrorCode.NATIVE_ADAPTER_CONFIGURATION_ERROR);
            Log.i((String)LOG_TAG, (String)"Failed Native AdFetch: Missing required server extras [FLURRY_APIKEY and/or FLURRY_ADSPACE].");
        }
    }

    private static synchronized void mapNativeAd(@NonNull FlurryBaseNativeAd mopubSupportedAd, @NonNull FlurryAdNative flurryAdNative) {
        FlurryAdNativeAsset ctaAsset;
        FlurryAdNativeAsset coverImageAsset = flurryAdNative.getAsset(ASSET_SEC_HQ_IMAGE);
        FlurryAdNativeAsset iconImageAsset = flurryAdNative.getAsset(ASSET_SEC_IMAGE);
        if (coverImageAsset != null && !TextUtils.isEmpty((CharSequence)coverImageAsset.getValue())) {
            mopubSupportedAd.setMainImageUrl(coverImageAsset.getValue());
        }
        if (iconImageAsset != null && !TextUtils.isEmpty((CharSequence)iconImageAsset.getValue())) {
            mopubSupportedAd.setIconImageUrl(iconImageAsset.getValue());
        }
        mopubSupportedAd.setTitle(flurryAdNative.getAsset(ASSET_HEADLINE).getValue());
        mopubSupportedAd.setText(flurryAdNative.getAsset(ASSET_SUMMARY).getValue());
        mopubSupportedAd.addExtra(EXTRA_SEC_BRANDING_LOGO, flurryAdNative.getAsset(ASSET_SEC_HQ_BRANDING_LOGO).getValue());
        mopubSupportedAd.addExtra(EXTRA_SEC_ADVERTISER_NAME, flurryAdNative.getAsset(ASSET_ADVERTISER_NAME).getValue());
        if (mopubSupportedAd.isAppInstallAd()) {
            FlurryAdNativeAsset appRatingAsset;
            FlurryAdNativeAsset ratingHqImageAsset = flurryAdNative.getAsset(ASSET_SEC_HQ_RATING_IMG);
            if (ratingHqImageAsset != null && !TextUtils.isEmpty((CharSequence)ratingHqImageAsset.getValue())) {
                mopubSupportedAd.addExtra(EXTRA_STAR_RATING_IMG, ratingHqImageAsset.getValue());
            } else {
                FlurryAdNativeAsset ratingImageAsset = flurryAdNative.getAsset(ASSET_SEC_RATING_IMG);
                if (ratingImageAsset != null && !TextUtils.isEmpty((CharSequence)ratingImageAsset.getValue())) {
                    mopubSupportedAd.addExtra(EXTRA_STAR_RATING_IMG, ratingImageAsset.getValue());
                }
            }
            FlurryAdNativeAsset appCategoryAsset = flurryAdNative.getAsset(ASSET_APP_CATEGORY);
            if (appCategoryAsset != null) {
                mopubSupportedAd.addExtra(EXTRA_APP_CATEGORY, appCategoryAsset.getValue());
            }
            if ((appRatingAsset = flurryAdNative.getAsset(ASSET_APP_RATING)) != null) {
                mopubSupportedAd.setStarRating(FlurryCustomEventNative.getStarRatingValue(appRatingAsset.getValue()));
            }
        }
        if ((ctaAsset = flurryAdNative.getAsset(ASSET_CALL_TO_ACTION)) != null) {
            mopubSupportedAd.setCallToAction(ctaAsset.getValue());
        }
        if (mopubSupportedAd.getImageUrls().isEmpty()) {
            Log.d((String)LOG_TAG, (String)("preCacheImages: No images to cache for Flurry Native Ad: " + flurryAdNative.toString()));
            mopubSupportedAd.onNativeAdLoaded();
        } else {
            mopubSupportedAd.precacheImages();
        }
    }

    @Nullable
    private static Double getStarRatingValue(@Nullable String appRatingString) {
        String[] ratingParts;
        Double rating = null;
        if (appRatingString != null && (ratingParts = appRatingString.split("/")).length == 2) {
            try {
                float numer = Integer.valueOf(ratingParts[0]).intValue();
                float denom = Integer.valueOf(ratingParts[1]).intValue();
                rating = (double)(numer / denom) * 5.0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return rating;
    }

    private boolean validateExtras(Map<String, String> serverExtras) {
        String flurryApiKey = serverExtras.get("apiKey");
        String flurryAdSpace = serverExtras.get("adSpaceName");
        Log.i((String)LOG_TAG, (String)("ServerInfo fetched from Mopub apiKey : " + flurryApiKey + " and " + "adSpaceName" + " :" + flurryAdSpace));
        return !TextUtils.isEmpty((CharSequence)flurryApiKey) && !TextUtils.isEmpty((CharSequence)flurryAdSpace);
    }

    private void fetchFlurryAd(@NonNull Context context, String flurryAdSpace, @NonNull Map<String, Object> localExtras, @NonNull CustomEventNative.CustomEventNativeListener customEventNativeListener) {
        FlurryAdNative flurryAdNative = new FlurryAdNative(context, flurryAdSpace);
        if (localExtras.containsKey(LOCAL_EXTRA_TEST_MODE) && localExtras.get(LOCAL_EXTRA_TEST_MODE) instanceof Boolean) {
            FlurryAdTargeting targeting = new FlurryAdTargeting();
            targeting.setEnableTestAds(((Boolean)localExtras.get(LOCAL_EXTRA_TEST_MODE)).booleanValue());
        }
        FlurryBaseNativeAd flurryNativeAd = this.shouldAllowVideoNativeAds() ? new FlurryVideoEnabledNativeAd(context, flurryAdNative, customEventNativeListener) : new FlurryStaticNativeAd(context, flurryAdNative, customEventNativeListener);
        sFlurryNativeAds.add(flurryAdNative);
        flurryNativeAd.fetchAd();
    }

    private boolean shouldAllowVideoNativeAds() {
        try {
            Class.forName("com.mopub.nativeads.FlurryNativeAdRenderer");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    static abstract class FlurryBaseAdListener
    implements FlurryAdNativeListener {
        @NonNull
        private final FlurryBaseNativeAd mBaseNativeAd;

        FlurryBaseAdListener(@NonNull FlurryBaseNativeAd baseNativeAd) {
            this.mBaseNativeAd = baseNativeAd;
        }

        public void onFetched(FlurryAdNative flurryAdNative) {
            Log.d((String)LOG_TAG, (String)"onFetched: Flurry native ad fetched successfully!");
            FlurryCustomEventNative.mapNativeAd(this.mBaseNativeAd, flurryAdNative);
            sFlurryNativeAds.remove(flurryAdNative);
        }

        public void onShowFullscreen(FlurryAdNative flurryAdNative) {
            Log.d((String)LOG_TAG, (String)"onShowFullscreen: Flurry native ad in full-screen");
        }

        public void onCloseFullscreen(FlurryAdNative flurryAdNative) {
            Log.d((String)LOG_TAG, (String)"onCloseFullscreen: Flurry native ad full-screen closed");
        }

        public void onAppExit(FlurryAdNative flurryAdNative) {
            Log.d((String)LOG_TAG, (String)"onAppExit: Flurry native ad exited app");
        }

        public void onClicked(FlurryAdNative flurryAdNative) {
            Log.d((String)LOG_TAG, (String)"onClicked: Flurry native ad clicked");
        }

        public void onImpressionLogged(FlurryAdNative flurryAdNative) {
            Log.d((String)LOG_TAG, (String)"onImpressionLogged: Flurry native ad impression logged");
        }

        public void onExpanded(FlurryAdNative flurryAdNative) {
            Log.d((String)LOG_TAG, (String)"onExpanded: Flurry native ad expanded");
        }

        public void onCollapsed(FlurryAdNative flurryAdNative) {
            Log.d((String)LOG_TAG, (String)"onCollapsed: Flurry native ad collapsed");
        }

        public void onError(FlurryAdNative flurryAdNative, FlurryAdErrorType adErrorType, int errorCode) {
            Log.d((String)LOG_TAG, (String)String.format("onError: Flurry native ad not available. Error type: %s. Error code: %s", adErrorType.toString(), errorCode));
            sFlurryNativeAds.remove(flurryAdNative);
        }
    }

    static class FlurryVideoEnabledNativeAd
    extends BaseNativeAd
    implements FlurryBaseNativeAd {
        @NonNull
        private final Context mContext;
        @NonNull
        private final CustomEventNative.CustomEventNativeListener mCustomEventNativeListener;
        @NonNull
        private final FlurryAdNative mFlurryAdNative;
        private final FlurryAdNativeListener mFlurryNativelistener = new FlurryBaseAdListener(this){

            @Override
            public void onClicked(FlurryAdNative flurryAdNative) {
                super.onClicked(flurryAdNative);
                FlurryVideoEnabledNativeAd.this.notifyAdClicked();
            }

            @Override
            public void onImpressionLogged(FlurryAdNative flurryAdNative) {
                super.onImpressionLogged(flurryAdNative);
                FlurryVideoEnabledNativeAd.this.notifyAdImpressed();
            }

            @Override
            public void onError(FlurryAdNative adNative, FlurryAdErrorType adErrorType, int errorCode) {
                super.onError(adNative, adErrorType, errorCode);
                FlurryVideoEnabledNativeAd.this.mCustomEventNativeListener.onNativeAdFailed(NativeErrorCode.NETWORK_NO_FILL);
            }
        };
        @Nullable
        private String mTitle;
        @Nullable
        private String mText;
        @Nullable
        private String mCallToAction;
        @Nullable
        private String mMainImageUrl;
        @Nullable
        private String mIconImageUrl;
        @Nullable
        private Double mStarRating;
        @NonNull
        private final Map<String, Object> mExtras;

        FlurryVideoEnabledNativeAd(@NonNull Context context, @NonNull FlurryAdNative adNative, @NonNull CustomEventNative.CustomEventNativeListener customEventNativeListener) {
            this.mContext = context;
            this.mFlurryAdNative = adNative;
            this.mCustomEventNativeListener = customEventNativeListener;
            this.mExtras = new HashMap<String, Object>();
        }

        public void prepare(@NonNull View view) {
            this.mFlurryAdNative.setTrackingView(view);
            Log.d((String)LOG_TAG, (String)("prepare(" + this.mFlurryAdNative.toString() + " " + view.toString() + ")"));
        }

        public void clear(@NonNull View view) {
            this.mFlurryAdNative.removeTrackingView();
            Log.d((String)LOG_TAG, (String)("clear(" + this.mFlurryAdNative.toString() + ")"));
        }

        public void destroy() {
            Log.d((String)LOG_TAG, (String)("destroy(" + this.mFlurryAdNative.toString() + ") started."));
            this.mFlurryAdNative.destroy();
            FlurryAgentWrapper.getInstance().endSession(this.mContext);
        }

        @Override
        public synchronized void fetchAd() {
            Log.d((String)LOG_TAG, (String)"Fetching Flurry Native Ad now.");
            this.mFlurryAdNative.setListener(this.mFlurryNativelistener);
            this.mFlurryAdNative.fetchAd();
        }

        @Override
        public boolean isAppInstallAd() {
            return this.mFlurryAdNative.getAsset(FlurryCustomEventNative.ASSET_SEC_RATING_IMG) != null || this.mFlurryAdNative.getAsset(FlurryCustomEventNative.ASSET_SEC_HQ_RATING_IMG) != null || this.mFlurryAdNative.getAsset(FlurryCustomEventNative.ASSET_APP_CATEGORY) != null;
        }

        @Override
        public void precacheImages() {
            NativeImageHelper.preCacheImages((Context)this.mContext, this.getImageUrls(), (NativeImageHelper.ImageListener)new NativeImageHelper.ImageListener(){

                public void onImagesCached() {
                    Log.d((String)LOG_TAG, (String)"preCacheImages: Ad image cached.");
                    FlurryVideoEnabledNativeAd.this.mCustomEventNativeListener.onNativeAdLoaded((BaseNativeAd)FlurryVideoEnabledNativeAd.this);
                }

                public void onImagesFailedToCache(NativeErrorCode errorCode) {
                    FlurryVideoEnabledNativeAd.this.mCustomEventNativeListener.onNativeAdFailed(errorCode);
                    Log.d((String)LOG_TAG, (String)("preCacheImages: Unable to cache Ad image. Error[" + errorCode.toString() + "]"));
                }
            });
        }

        @Override
        @NonNull
        public List<String> getImageUrls() {
            String iconUrl;
            ArrayList<String> imageUrls = new ArrayList<String>(2);
            String mainImageUrl = this.getMainImageUrl();
            if (mainImageUrl != null) {
                imageUrls.add(this.getMainImageUrl());
                Log.d((String)LOG_TAG, (String)"Flurry Native Ad main image found.");
            }
            if ((iconUrl = this.getIconImageUrl()) != null) {
                imageUrls.add(this.getIconImageUrl());
                Log.d((String)LOG_TAG, (String)"Flurry Native Ad icon image found.");
            }
            return imageUrls;
        }

        @Override
        @Nullable
        public String getTitle() {
            return this.mTitle;
        }

        @Override
        @Nullable
        public String getText() {
            return this.mText;
        }

        @Override
        @Nullable
        public String getCallToAction() {
            return this.mCallToAction;
        }

        @Override
        @Nullable
        public String getMainImageUrl() {
            return this.mMainImageUrl;
        }

        @Override
        @Nullable
        public String getIconImageUrl() {
            return this.mIconImageUrl;
        }

        @Override
        @Nullable
        public Double getStarRating() {
            return this.mStarRating;
        }

        @Override
        @NonNull
        public Map<String, Object> getExtras() {
            return this.mExtras;
        }

        @Override
        public void setTitle(@Nullable String title) {
            this.mTitle = title;
        }

        @Override
        public void setText(@Nullable String text) {
            this.mText = text;
        }

        @Override
        public void setCallToAction(@Nullable String callToAction) {
            this.mCallToAction = callToAction;
        }

        @Override
        public void setMainImageUrl(@Nullable String mainImageUrl) {
            this.mMainImageUrl = mainImageUrl;
        }

        @Override
        public void setIconImageUrl(@Nullable String iconImageUrl) {
            this.mIconImageUrl = iconImageUrl;
        }

        @Override
        public void setStarRating(@Nullable Double starRating) {
            this.mStarRating = starRating;
        }

        @Override
        public void addExtra(@NonNull String key, @Nullable Object value) {
            this.mExtras.put(key, value);
        }

        @Override
        public void onNativeAdLoaded() {
            this.mCustomEventNativeListener.onNativeAdLoaded((BaseNativeAd)this);
        }

        boolean isVideoAd() {
            return this.mFlurryAdNative.isVideoAd();
        }

        void loadVideoIntoView(@NonNull ViewGroup videoView) {
            this.mFlurryAdNative.getAsset(FlurryCustomEventNative.ASSET_VIDEO).loadAssetIntoView((View)videoView);
        }
    }

    private static class FlurryStaticNativeAd
    extends StaticNativeAd
    implements FlurryBaseNativeAd {
        @NonNull
        private final Context mContext;
        @NonNull
        private final CustomEventNative.CustomEventNativeListener mCustomEventNativeListener;
        @NonNull
        private final FlurryAdNative mFlurryAdNative;
        private final FlurryAdNativeListener mFlurryNativelistener = new FlurryBaseAdListener(this){

            @Override
            public void onClicked(FlurryAdNative flurryAdNative) {
                super.onClicked(flurryAdNative);
                FlurryStaticNativeAd.this.notifyAdClicked();
            }

            @Override
            public void onImpressionLogged(FlurryAdNative flurryAdNative) {
                super.onImpressionLogged(flurryAdNative);
                FlurryStaticNativeAd.this.notifyAdImpressed();
            }

            @Override
            public void onError(FlurryAdNative adNative, FlurryAdErrorType adErrorType, int errorCode) {
                super.onError(adNative, adErrorType, errorCode);
                FlurryStaticNativeAd.this.mCustomEventNativeListener.onNativeAdFailed(NativeErrorCode.NETWORK_NO_FILL);
            }
        };

        FlurryStaticNativeAd(@NonNull Context context, @NonNull FlurryAdNative adNative, @NonNull CustomEventNative.CustomEventNativeListener customEventNativeListener) {
            this.mContext = context;
            this.mFlurryAdNative = adNative;
            this.mCustomEventNativeListener = customEventNativeListener;
        }

        public void prepare(@NonNull View view) {
            this.mFlurryAdNative.setTrackingView(view);
            Log.d((String)LOG_TAG, (String)("prepare(" + this.mFlurryAdNative.toString() + " " + view.toString() + ")"));
        }

        public void clear(@NonNull View view) {
            this.mFlurryAdNative.removeTrackingView();
            Log.d((String)LOG_TAG, (String)("clear(" + this.mFlurryAdNative.toString() + ")"));
        }

        public void destroy() {
            Log.d((String)LOG_TAG, (String)("destroy(" + this.mFlurryAdNative.toString() + ") started."));
            this.mFlurryAdNative.destroy();
            FlurryAgentWrapper.getInstance().endSession(this.mContext);
        }

        @Override
        public synchronized void fetchAd() {
            Log.d((String)LOG_TAG, (String)"Fetching Flurry Native Ad now.");
            this.mFlurryAdNative.setListener(this.mFlurryNativelistener);
            this.mFlurryAdNative.fetchAd();
        }

        @Override
        @NonNull
        public List<String> getImageUrls() {
            String iconUrl;
            ArrayList<String> imageUrls = new ArrayList<String>(2);
            String mainImageUrl = this.getMainImageUrl();
            if (mainImageUrl != null) {
                imageUrls.add(this.getMainImageUrl());
                Log.d((String)LOG_TAG, (String)"Flurry Native Ad main image found.");
            }
            if ((iconUrl = this.getIconImageUrl()) != null) {
                imageUrls.add(this.getIconImageUrl());
                Log.d((String)LOG_TAG, (String)"Flurry Native Ad icon image found.");
            }
            return imageUrls;
        }

        @Override
        public boolean isAppInstallAd() {
            return this.mFlurryAdNative.getAsset(FlurryCustomEventNative.ASSET_SEC_RATING_IMG) != null || this.mFlurryAdNative.getAsset(FlurryCustomEventNative.ASSET_SEC_HQ_RATING_IMG) != null || this.mFlurryAdNative.getAsset(FlurryCustomEventNative.ASSET_APP_CATEGORY) != null;
        }

        @Override
        public void onNativeAdLoaded() {
            this.mCustomEventNativeListener.onNativeAdLoaded((BaseNativeAd)this);
        }

        @Override
        public void precacheImages() {
            NativeImageHelper.preCacheImages((Context)this.mContext, this.getImageUrls(), (NativeImageHelper.ImageListener)new NativeImageHelper.ImageListener(){

                public void onImagesCached() {
                    Log.d((String)LOG_TAG, (String)"preCacheImages: Ad image cached.");
                    FlurryStaticNativeAd.this.mCustomEventNativeListener.onNativeAdLoaded((BaseNativeAd)FlurryStaticNativeAd.this);
                }

                public void onImagesFailedToCache(NativeErrorCode errorCode) {
                    FlurryStaticNativeAd.this.mCustomEventNativeListener.onNativeAdFailed(errorCode);
                    Log.d((String)LOG_TAG, (String)("preCacheImages: Unable to cache Ad image. Error[" + errorCode.toString() + "]"));
                }
            });
        }
    }
}

