/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.mopub.nativeads.BaseNativeAd;
import com.mopub.nativeads.FlurryCustomEventNative;
import com.mopub.nativeads.FlurryViewBinder;
import com.mopub.nativeads.MoPubAdRenderer;
import com.mopub.nativeads.NativeImageHelper;
import com.mopub.nativeads.NativeRendererHelper;
import com.mopub.nativeads.StaticNativeViewHolder;
import com.mopub.nativeads.ViewBinder;
import java.util.Map;
import java.util.WeakHashMap;

public class FlurryNativeAdRenderer
implements MoPubAdRenderer<FlurryCustomEventNative.FlurryVideoEnabledNativeAd> {
    @NonNull
    private final FlurryViewBinder mViewBinder;
    @NonNull
    private final WeakHashMap<View, FlurryNativeViewHolder> mViewHolderMap;

    public FlurryNativeAdRenderer(@NonNull FlurryViewBinder viewBinder) {
        this.mViewBinder = viewBinder;
        this.mViewHolderMap = new WeakHashMap();
    }

    @NonNull
    public View createAdView(@NonNull Context context, @Nullable ViewGroup parent) {
        return LayoutInflater.from((Context)context).inflate(this.mViewBinder.staticViewBinder.layoutId, parent, false);
    }

    public void renderAdView(@NonNull View view, @NonNull FlurryCustomEventNative.FlurryVideoEnabledNativeAd ad) {
        FlurryNativeViewHolder flurryNativeViewHolder = this.mViewHolderMap.get(view);
        if (flurryNativeViewHolder == null) {
            flurryNativeViewHolder = FlurryNativeViewHolder.fromViewBinder(view, this.mViewBinder);
            this.mViewHolderMap.put(view, flurryNativeViewHolder);
        }
        this.update(flurryNativeViewHolder, ad);
        NativeRendererHelper.updateExtras((View)((FlurryNativeViewHolder)flurryNativeViewHolder).staticNativeViewHolder.mainView, (Map)this.mViewBinder.staticViewBinder.extras, ad.getExtras());
        this.setViewVisibility(flurryNativeViewHolder, 0);
    }

    public boolean supports(@NonNull BaseNativeAd nativeAd) {
        return nativeAd instanceof FlurryCustomEventNative.FlurryVideoEnabledNativeAd;
    }

    private void update(FlurryNativeViewHolder viewHolder, FlurryCustomEventNative.FlurryVideoEnabledNativeAd ad) {
        NativeRendererHelper.addTextView((TextView)((FlurryNativeViewHolder)viewHolder).staticNativeViewHolder.titleView, (String)ad.getTitle());
        NativeRendererHelper.addTextView((TextView)((FlurryNativeViewHolder)viewHolder).staticNativeViewHolder.textView, (String)ad.getText());
        NativeRendererHelper.addTextView((TextView)((FlurryNativeViewHolder)viewHolder).staticNativeViewHolder.callToActionView, (String)ad.getCallToAction());
        NativeImageHelper.loadImageView((String)ad.getIconImageUrl(), (ImageView)((FlurryNativeViewHolder)viewHolder).staticNativeViewHolder.iconImageView);
        if (ad.isVideoAd()) {
            if (viewHolder.videoView != null) {
                viewHolder.videoView.setVisibility(0);
                ad.loadVideoIntoView(viewHolder.videoView);
            }
            if (((FlurryNativeViewHolder)viewHolder).staticNativeViewHolder.mainImageView != null) {
                ((FlurryNativeViewHolder)viewHolder).staticNativeViewHolder.mainImageView.setVisibility(8);
            }
        } else {
            if (viewHolder.videoView != null) {
                viewHolder.videoView.setVisibility(8);
            }
            if (((FlurryNativeViewHolder)viewHolder).staticNativeViewHolder.mainImageView != null) {
                ((FlurryNativeViewHolder)viewHolder).staticNativeViewHolder.mainImageView.setVisibility(0);
                NativeImageHelper.loadImageView((String)ad.getMainImageUrl(), (ImageView)((FlurryNativeViewHolder)viewHolder).staticNativeViewHolder.mainImageView);
            }
        }
    }

    private void setViewVisibility(@NonNull FlurryNativeViewHolder viewHolder, int visibility) {
        if (((FlurryNativeViewHolder)viewHolder).staticNativeViewHolder.mainView != null) {
            ((FlurryNativeViewHolder)viewHolder).staticNativeViewHolder.mainView.setVisibility(visibility);
        }
    }

    private static class FlurryNativeViewHolder {
        private final StaticNativeViewHolder staticNativeViewHolder;
        private final ViewGroup videoView;

        private FlurryNativeViewHolder(StaticNativeViewHolder staticNativeViewHolder, ViewGroup videoView) {
            this.staticNativeViewHolder = staticNativeViewHolder;
            this.videoView = videoView;
        }

        static FlurryNativeViewHolder fromViewBinder(View view, FlurryViewBinder viewBinder) {
            StaticNativeViewHolder staticNativeViewHolder = StaticNativeViewHolder.fromViewBinder((View)view, (ViewBinder)viewBinder.staticViewBinder);
            ViewGroup videoView = (ViewGroup)view.findViewById(viewBinder.videoViewId);
            return new FlurryNativeViewHolder(staticNativeViewHolder, videoView);
        }
    }
}

