/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.millennialmedia.AppInfo;
import com.millennialmedia.CreativeInfo;
import com.millennialmedia.InlineAd;
import com.millennialmedia.MMException;
import com.millennialmedia.MMLog;
import com.millennialmedia.MMSDK;
import com.millennialmedia.internal.ActivityListenerManager;
import com.mopub.common.MoPub;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.AdViewController;
import com.mopub.mobileads.CustomEventBanner;
import com.mopub.mobileads.MillennialUtils;
import com.mopub.mobileads.MoPubErrorCode;
import java.util.Map;

final class MillennialBanner
extends CustomEventBanner {
    private static final String TAG = MillennialBanner.class.getSimpleName();
    private static final String DCN_KEY = "dcn";
    private static final String APID_KEY = "adUnitID";
    private static final String AD_WIDTH_KEY = "adWidth";
    private static final String AD_HEIGHT_KEY = "adHeight";
    private InlineAd inlineAd;
    private CustomEventBanner.CustomEventBannerListener bannerListener;
    private FrameLayout internalView;

    MillennialBanner() {
    }

    private CreativeInfo getCreativeInfo() {
        if (this.inlineAd == null) {
            return null;
        }
        return this.inlineAd.getCreativeInfo();
    }

    protected void loadBanner(Context context, CustomEventBanner.CustomEventBannerListener customEventBannerListener, Map<String, Object> localExtras, Map<String, String> serverExtras) {
        if (context instanceof Activity) {
            try {
                MMSDK.initialize((Activity)((Activity)context), (ActivityListenerManager.LifecycleState)ActivityListenerManager.LifecycleState.RESUMED);
            }
            catch (IllegalStateException e) {
                MoPubLog.d((String)"Exception occurred initializing the MM SDK.", (Throwable)e);
                this.bannerListener.onBannerFailed(MoPubErrorCode.INTERNAL_ERROR);
                return;
            }
        } else if (context instanceof Application) {
            try {
                MMSDK.initialize((Application)((Application)context));
            }
            catch (MMException e) {
                MoPubLog.d((String)"Exception occurred initializing the MM SDK.", (Throwable)e);
                this.bannerListener.onBannerFailed(MoPubErrorCode.INTERNAL_ERROR);
                return;
            }
        } else {
            MoPubLog.d((String)"MM SDK must be initialized with an Activity or Application context.");
            this.bannerListener.onBannerFailed(MoPubErrorCode.INTERNAL_ERROR);
            return;
        }
        this.bannerListener = customEventBannerListener;
        String apid = serverExtras.get(APID_KEY);
        int width = Integer.parseInt(serverExtras.get(AD_WIDTH_KEY));
        int height = Integer.parseInt(serverExtras.get(AD_HEIGHT_KEY));
        if (MillennialUtils.isEmpty(apid) || width < 0 || height < 0) {
            MoPubLog.d((String)"We were given invalid extras! Make sure placement ID, width, and height are specified.");
            this.bannerListener.onBannerFailed(MoPubErrorCode.ADAPTER_CONFIGURATION_ERROR);
            return;
        }
        String dcn = serverExtras.get(DCN_KEY);
        AppInfo ai = new AppInfo().setMediator("MoPubMM-1.3.0");
        if (!MillennialUtils.isEmpty(dcn)) {
            ai.setSiteId(dcn);
        }
        try {
            MMSDK.setAppInfo((AppInfo)ai);
            this.internalView = new FrameLayout(context);
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -2);
            lp.gravity = 1;
            this.internalView.setLayoutParams((ViewGroup.LayoutParams)lp);
            this.inlineAd = InlineAd.createInstance((String)apid, (ViewGroup)this.internalView);
            InlineAd.InlineAdMetadata mInlineAdMetadata = new InlineAd.InlineAdMetadata().setAdSize(new InlineAd.AdSize(width, height));
            this.inlineAd.setListener((InlineAd.InlineListener)new MillennialInlineListener());
            MMSDK.setLocationEnabled((MoPub.getLocationAwareness() != MoPub.LocationAwareness.DISABLED ? 1 : 0) != 0);
            AdViewController.setShouldHonorServerDimensions((View)this.internalView);
            this.inlineAd.request(mInlineAdMetadata);
        }
        catch (MMException e) {
            MoPubLog.d((String)"MM SDK exception occurred obtaining an inline ad unit.", (Throwable)e);
            this.bannerListener.onBannerFailed(MoPubErrorCode.INTERNAL_ERROR);
        }
    }

    protected void onInvalidate() {
        if (this.inlineAd != null) {
            this.inlineAd.destroy();
            this.inlineAd = null;
        }
    }

    static {
        MoPubLog.d((String)"Millennial Media Adapter Version: MoPubMM-1.3.0");
    }

    class MillennialInlineListener
    implements InlineAd.InlineListener {
        MillennialInlineListener() {
        }

        public void onAdLeftApplication(InlineAd inlineAd) {
            MoPubLog.d((String)"Millennial Inline Ad - Leaving application");
        }

        public void onClicked(InlineAd inlineAd) {
            MoPubLog.d((String)"Millennial Inline Ad - Ad clicked");
            MillennialUtils.postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    MillennialBanner.this.bannerListener.onBannerClicked();
                }
            });
        }

        public void onCollapsed(InlineAd inlineAd) {
            MoPubLog.d((String)"Millennial Inline Ad - Banner collapsed");
            MillennialUtils.postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    MillennialBanner.this.bannerListener.onBannerCollapsed();
                }
            });
        }

        public void onExpanded(InlineAd inlineAd) {
            MoPubLog.d((String)"Millennial Inline Ad - Banner expanded");
            MillennialUtils.postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    MillennialBanner.this.bannerListener.onBannerExpanded();
                }
            });
        }

        public void onRequestFailed(InlineAd inlineAd, InlineAd.InlineErrorStatus inlineErrorStatus) {
            MoPubErrorCode mopubErrorCode;
            MoPubLog.d((String)("Millennial Inline Ad - Banner failed (" + inlineErrorStatus.getErrorCode() + "): " + inlineErrorStatus.getDescription()));
            switch (inlineErrorStatus.getErrorCode()) {
                case 1: {
                    mopubErrorCode = MoPubErrorCode.ADAPTER_CONFIGURATION_ERROR;
                    break;
                }
                case 4: {
                    mopubErrorCode = MoPubErrorCode.INTERNAL_ERROR;
                    break;
                }
                case 3: {
                    mopubErrorCode = MoPubErrorCode.WARMUP;
                    break;
                }
                case 2: {
                    mopubErrorCode = MoPubErrorCode.NO_CONNECTION;
                    break;
                }
                case 7: {
                    mopubErrorCode = MoPubErrorCode.UNSPECIFIED;
                    break;
                }
                default: {
                    mopubErrorCode = MoPubErrorCode.NETWORK_NO_FILL;
                }
            }
            final MoPubErrorCode fErrorCode = mopubErrorCode;
            MillennialUtils.postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    MillennialBanner.this.bannerListener.onBannerFailed(fErrorCode);
                }
            });
        }

        public void onRequestSucceeded(InlineAd inlineAd) {
            MoPubLog.d((String)"Millennial Inline Ad - Banner request succeeded");
            CreativeInfo creativeInfo = MillennialBanner.this.getCreativeInfo();
            if (creativeInfo != null && MMLog.isDebugEnabled()) {
                MMLog.d((String)TAG, (String)("Banner Creative Info: " + creativeInfo));
            }
            MillennialUtils.postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    MillennialBanner.this.bannerListener.onBannerLoaded((View)MillennialBanner.this.internalView);
                }
            });
        }

        public void onResize(InlineAd inlineAd, int w, int h) {
            MoPubLog.d((String)("Millennial Inline Ad - Banner about to resize (width: " + w + ", height: " + h + ")"));
        }

        public void onResized(InlineAd inlineAd, int w, int h, boolean isClosed) {
            MoPubLog.d((String)("Millennial Inline Ad - Banner resized (width: " + w + ", height: " + h + "). " + (isClosed ? "Returned to original placement." : "Got a fresh, new place.")));
        }
    }
}

