/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import com.millennialmedia.AppInfo;
import com.millennialmedia.CreativeInfo;
import com.millennialmedia.InterstitialAd;
import com.millennialmedia.MMException;
import com.millennialmedia.MMLog;
import com.millennialmedia.MMSDK;
import com.millennialmedia.internal.ActivityListenerManager;
import com.mopub.common.MoPub;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.CustomEventInterstitial;
import com.mopub.mobileads.MillennialUtils;
import com.mopub.mobileads.MoPubErrorCode;
import java.util.Map;

final class MillennialInterstitial
extends CustomEventInterstitial {
    private static final String TAG = MillennialInterstitial.class.getSimpleName();
    private static final String DCN_KEY = "dcn";
    private static final String APID_KEY = "adUnitID";
    private InterstitialAd millennialInterstitial;
    private Context context;
    private CustomEventInterstitial.CustomEventInterstitialListener interstitialListener;

    MillennialInterstitial() {
    }

    private CreativeInfo getCreativeInfo() {
        if (this.millennialInterstitial == null) {
            return null;
        }
        return this.millennialInterstitial.getCreativeInfo();
    }

    protected void loadInterstitial(Context context, CustomEventInterstitial.CustomEventInterstitialListener customEventInterstitialListener, Map<String, Object> localExtras, Map<String, String> serverExtras) {
        this.interstitialListener = customEventInterstitialListener;
        this.context = context;
        if (context instanceof Activity) {
            try {
                MMSDK.initialize((Activity)((Activity)context), (ActivityListenerManager.LifecycleState)ActivityListenerManager.LifecycleState.RESUMED);
            }
            catch (IllegalStateException e) {
                MoPubLog.d((String)"Exception occurred initializing the MM SDK.", (Throwable)e);
                this.interstitialListener.onInterstitialFailed(MoPubErrorCode.INTERNAL_ERROR);
                return;
            }
        } else if (context instanceof Application) {
            try {
                MMSDK.initialize((Application)((Application)context));
            }
            catch (MMException e) {
                MoPubLog.d((String)"Exception occurred initializing the MM SDK.", (Throwable)e);
                this.interstitialListener.onInterstitialFailed(MoPubErrorCode.INTERNAL_ERROR);
                return;
            }
        } else {
            MoPubLog.d((String)"MM SDK must be initialized with an Activity or Application context.");
            this.interstitialListener.onInterstitialFailed(MoPubErrorCode.INTERNAL_ERROR);
            return;
        }
        String apid = serverExtras.get(APID_KEY);
        if (MillennialUtils.isEmpty(apid)) {
            MoPubLog.d((String)"Invalid extras-- Be sure you have an placement ID specified.");
            this.interstitialListener.onInterstitialFailed(MoPubErrorCode.ADAPTER_CONFIGURATION_ERROR);
            return;
        }
        String dcn = serverExtras.get(DCN_KEY);
        AppInfo ai = new AppInfo().setMediator("MoPubMM-1.3.0");
        if (!MillennialUtils.isEmpty(dcn)) {
            ai.setSiteId(dcn);
        }
        try {
            MMSDK.setAppInfo((AppInfo)ai);
            MMSDK.setLocationEnabled((MoPub.getLocationAwareness() != MoPub.LocationAwareness.DISABLED ? 1 : 0) != 0);
            this.millennialInterstitial = InterstitialAd.createInstance((String)apid);
            this.millennialInterstitial.setListener((InterstitialAd.InterstitialListener)new MillennialInterstitialListener());
            this.millennialInterstitial.load(context, null);
        }
        catch (MMException e) {
            MoPubLog.d((String)"Exception occurred while obtaining an interstitial from MM SDK.", (Throwable)e);
            this.interstitialListener.onInterstitialFailed(MoPubErrorCode.INTERNAL_ERROR);
        }
    }

    protected void showInterstitial() {
        if (this.millennialInterstitial.isReady()) {
            try {
                this.millennialInterstitial.show(this.context);
            }
            catch (MMException e) {
                MoPubLog.d((String)"An exception occurred while attempting to show interstitial.", (Throwable)e);
                this.interstitialListener.onInterstitialFailed(MoPubErrorCode.INTERNAL_ERROR);
            }
        } else {
            MoPubLog.d((String)"showInterstitial called but interstitial is not ready.");
        }
    }

    protected void onInvalidate() {
        if (this.millennialInterstitial != null) {
            this.millennialInterstitial.destroy();
            this.millennialInterstitial = null;
        }
    }

    static {
        MoPubLog.d((String)"Millennial Media Adapter Version: MoPubMM-1.3.0");
    }

    class MillennialInterstitialListener
    implements InterstitialAd.InterstitialListener {
        MillennialInterstitialListener() {
        }

        public void onAdLeftApplication(InterstitialAd interstitialAd) {
            MoPubLog.d((String)"Millennial Interstitial Ad - Leaving application");
        }

        public void onClicked(InterstitialAd interstitialAd) {
            MoPubLog.d((String)"Millennial Interstitial Ad - Ad was clicked");
            MillennialUtils.postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    MillennialInterstitial.this.interstitialListener.onInterstitialClicked();
                }
            });
        }

        public void onClosed(InterstitialAd interstitialAd) {
            MoPubLog.d((String)"Millennial Interstitial Ad - Ad was closed");
            MillennialUtils.postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    MillennialInterstitial.this.interstitialListener.onInterstitialDismissed();
                }
            });
        }

        public void onExpired(InterstitialAd interstitialAd) {
            MoPubLog.d((String)"Millennial Interstitial Ad - Ad expired");
            MillennialUtils.postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    MillennialInterstitial.this.interstitialListener.onInterstitialFailed(MoPubErrorCode.NO_FILL);
                }
            });
        }

        public void onLoadFailed(InterstitialAd interstitialAd, InterstitialAd.InterstitialErrorStatus interstitialErrorStatus) {
            MoPubErrorCode moPubErrorCode;
            MoPubLog.d((String)("Millennial Interstitial Ad - load failed (" + interstitialErrorStatus.getErrorCode() + "): " + interstitialErrorStatus.getDescription()));
            switch (interstitialErrorStatus.getErrorCode()) {
                case 203: {
                    MillennialInterstitial.this.interstitialListener.onInterstitialLoaded();
                    MoPubLog.d((String)"Millennial Interstitial Ad - Attempted to load ads when ads are already loaded.");
                    return;
                }
                case 1: 
                case 3: 
                case 4: 
                case 201: {
                    moPubErrorCode = MoPubErrorCode.INTERNAL_ERROR;
                    break;
                }
                case 2: {
                    moPubErrorCode = MoPubErrorCode.NO_CONNECTION;
                    break;
                }
                case 7: {
                    moPubErrorCode = MoPubErrorCode.UNSPECIFIED;
                    break;
                }
                default: {
                    moPubErrorCode = MoPubErrorCode.NETWORK_NO_FILL;
                }
            }
            MillennialUtils.postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    MillennialInterstitial.this.interstitialListener.onInterstitialFailed(moPubErrorCode);
                }
            });
        }

        public void onLoaded(InterstitialAd interstitialAd) {
            MoPubLog.d((String)"Millennial Interstitial Ad - Ad loaded splendidly");
            CreativeInfo creativeInfo = MillennialInterstitial.this.getCreativeInfo();
            if (creativeInfo != null && MMLog.isDebugEnabled()) {
                MoPubLog.d((String)("Interstitial Creative Info: " + creativeInfo));
            }
            MillennialUtils.postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    MillennialInterstitial.this.interstitialListener.onInterstitialLoaded();
                }
            });
        }

        public void onShowFailed(InterstitialAd interstitialAd, InterstitialAd.InterstitialErrorStatus interstitialErrorStatus) {
            MoPubLog.d((String)("Millennial Interstitial Ad - Show failed (" + interstitialErrorStatus.getErrorCode() + "): " + interstitialErrorStatus.getDescription()));
            MillennialUtils.postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    MillennialInterstitial.this.interstitialListener.onInterstitialFailed(MoPubErrorCode.INTERNAL_ERROR);
                }
            });
        }

        public void onShown(InterstitialAd interstitialAd) {
            MoPubLog.d((String)"Millennial Interstitial Ad - Ad shown");
            MillennialUtils.postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    MillennialInterstitial.this.interstitialListener.onInterstitialShown();
                }
            });
        }
    }
}

