/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.millennialmedia.AppInfo;
import com.millennialmedia.CreativeInfo;
import com.millennialmedia.InterstitialAd;
import com.millennialmedia.MMException;
import com.millennialmedia.MMLog;
import com.millennialmedia.MMSDK;
import com.millennialmedia.XIncentivizedEventListener;
import com.millennialmedia.internal.ActivityListenerManager;
import com.mopub.common.BaseLifecycleListener;
import com.mopub.common.LifecycleListener;
import com.mopub.common.MoPub;
import com.mopub.common.MoPubReward;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.CustomEventRewardedVideo;
import com.mopub.mobileads.MillennialUtils;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.MoPubRewardedVideoManager;
import java.util.Map;

final class MillennialRewardedVideo
extends CustomEventRewardedVideo {
    private static final String TAG = MillennialRewardedVideo.class.getSimpleName();
    private static final String DCN_KEY = "dcn";
    private static final String APID_KEY = "adUnitID";
    private InterstitialAd millennialInterstitial;
    private MillennialRewardedVideoListener millennialRewardedVideoListener = new MillennialRewardedVideoListener();
    private Activity activity;
    private String apid = null;

    MillennialRewardedVideo() {
    }

    private CreativeInfo getCreativeInfo() {
        if (this.millennialInterstitial == null) {
            return null;
        }
        return this.millennialInterstitial.getCreativeInfo();
    }

    @Nullable
    protected CustomEventRewardedVideo.CustomEventRewardedVideoListener getVideoListenerForSdk() {
        return this.millennialRewardedVideoListener;
    }

    @Nullable
    protected LifecycleListener getLifecycleListener() {
        return new BaseLifecycleListener();
    }

    @NonNull
    protected String getAdNetworkId() {
        return this.apid == null ? "" : this.apid;
    }

    protected void onInvalidate() {
        if (this.millennialInterstitial != null) {
            this.millennialInterstitial.destroy();
            this.millennialInterstitial = null;
            this.apid = null;
        }
    }

    protected boolean checkAndInitializeSdk(@NonNull Activity launcherActivity, @NonNull Map<String, Object> localExtras, @NonNull Map<String, String> serverExtras) throws Exception {
        try {
            MMSDK.initialize((Activity)launcherActivity, (ActivityListenerManager.LifecycleState)ActivityListenerManager.LifecycleState.RESUMED);
        }
        catch (IllegalStateException e) {
            MoPubLog.d((String)"An exception occurred initializing the MM SDK", (Throwable)e);
            return false;
        }
        return true;
    }

    protected void loadWithSdkInitialized(@NonNull Activity activity, @NonNull Map<String, Object> localExtras, @NonNull Map<String, String> serverExtras) throws Exception {
        this.activity = activity;
        this.apid = serverExtras.get(APID_KEY);
        String dcn = serverExtras.get(DCN_KEY);
        if (MillennialUtils.isEmpty(this.apid)) {
            MoPubLog.d((String)"Invalid extras-- Be sure you have a placement ID specified.");
            MoPubRewardedVideoManager.onRewardedVideoLoadFailure(MillennialRewardedVideo.class, (String)"", (MoPubErrorCode)MoPubErrorCode.ADAPTER_CONFIGURATION_ERROR);
            return;
        }
        AppInfo ai = new AppInfo().setMediator("MoPubMM-1.3.0").setSiteId(dcn);
        try {
            MMSDK.setAppInfo((AppInfo)ai);
            MMSDK.setLocationEnabled((MoPub.getLocationAwareness() != MoPub.LocationAwareness.DISABLED ? 1 : 0) != 0);
            this.millennialInterstitial = InterstitialAd.createInstance((String)this.apid);
            this.millennialInterstitial.setListener((InterstitialAd.InterstitialListener)this.millennialRewardedVideoListener);
            this.millennialInterstitial.xSetIncentivizedListener((XIncentivizedEventListener)this.millennialRewardedVideoListener);
            this.millennialInterstitial.load((Context)activity, null);
        }
        catch (MMException e) {
            MoPubLog.d((String)"An exception occurred loading an InterstitialAd", (Throwable)e);
            MoPubRewardedVideoManager.onRewardedVideoLoadFailure(MillennialRewardedVideo.class, (String)this.apid, (MoPubErrorCode)MoPubErrorCode.INTERNAL_ERROR);
        }
    }

    protected boolean hasVideoAvailable() {
        return this.millennialInterstitial != null && this.millennialInterstitial.isReady();
    }

    protected void showVideo() {
        if (this.millennialInterstitial != null && this.millennialInterstitial.isReady()) {
            try {
                this.millennialInterstitial.show((Context)this.activity);
            }
            catch (MMException e) {
                MoPubLog.d((String)"An exception occurred showing the MM SDK interstitial.", (Throwable)e);
                MoPubRewardedVideoManager.onRewardedVideoPlaybackError(MillennialRewardedVideo.class, (String)this.millennialInterstitial.placementId, (MoPubErrorCode)MoPubErrorCode.INTERNAL_ERROR);
            }
        } else {
            MoPubLog.d((String)"showVideo called before MillennialInterstitial ad was loaded.");
        }
    }

    static {
        MoPubLog.d((String)"Millennial Media Adapter Version: MoPubMM-1.3.0");
    }

    class MillennialRewardedVideoListener
    implements InterstitialAd.InterstitialListener,
    XIncentivizedEventListener,
    CustomEventRewardedVideo.CustomEventRewardedVideoListener {
        MillennialRewardedVideoListener() {
        }

        public void onAdLeftApplication(InterstitialAd interstitialAd) {
            MoPubLog.d((String)"Millennial Rewarded Video Ad - Leaving application");
        }

        public void onClicked(final InterstitialAd interstitialAd) {
            MoPubLog.d((String)"Millennial Rewarded Video Ad - Ad was clicked");
            MillennialUtils.postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    MoPubRewardedVideoManager.onRewardedVideoClicked(MillennialRewardedVideo.class, (String)interstitialAd.placementId);
                }
            });
        }

        public void onClosed(final InterstitialAd interstitialAd) {
            MoPubLog.d((String)"Millennial Rewarded Video Ad - Ad was closed");
            MillennialUtils.postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    MoPubRewardedVideoManager.onRewardedVideoClosed(MillennialRewardedVideo.class, (String)interstitialAd.placementId);
                }
            });
        }

        public void onExpired(final InterstitialAd interstitialAd) {
            MoPubLog.d((String)"Millennial Rewarded Video Ad - Ad expired");
            MillennialUtils.postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    MoPubRewardedVideoManager.onRewardedVideoLoadFailure(MillennialRewardedVideo.class, (String)interstitialAd.placementId, (MoPubErrorCode)MoPubErrorCode.VIDEO_NOT_AVAILABLE);
                }
            });
        }

        public void onLoadFailed(final InterstitialAd interstitialAd, InterstitialAd.InterstitialErrorStatus interstitialErrorStatus) {
            MoPubErrorCode moPubErrorCode;
            MoPubLog.d((String)("Millennial Rewarded Video Ad - load failed (" + interstitialErrorStatus.getErrorCode() + "): " + interstitialErrorStatus.getDescription()));
            switch (interstitialErrorStatus.getErrorCode()) {
                case 203: {
                    MillennialUtils.postOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            MoPubRewardedVideoManager.onRewardedVideoLoadSuccess(MillennialRewardedVideo.class, (String)interstitialAd.placementId);
                        }
                    });
                    MoPubLog.d((String)"Millennial Rewarded Video Ad - Attempted to load ads when ads are already loaded.");
                    return;
                }
                case 1: 
                case 3: 
                case 4: 
                case 201: {
                    moPubErrorCode = MoPubErrorCode.INTERNAL_ERROR;
                    break;
                }
                case 2: {
                    moPubErrorCode = MoPubErrorCode.NO_CONNECTION;
                    break;
                }
                case 7: {
                    moPubErrorCode = MoPubErrorCode.UNSPECIFIED;
                    break;
                }
                default: {
                    moPubErrorCode = MoPubErrorCode.NETWORK_NO_FILL;
                }
            }
            MillennialUtils.postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    MoPubRewardedVideoManager.onRewardedVideoLoadFailure(MillennialRewardedVideo.class, (String)interstitialAd.placementId, (MoPubErrorCode)moPubErrorCode);
                }
            });
        }

        public void onLoaded(final InterstitialAd interstitialAd) {
            MoPubLog.d((String)"Millennial Rewarded Video Ad - Ad loaded splendidly");
            CreativeInfo creativeInfo = MillennialRewardedVideo.this.getCreativeInfo();
            if (creativeInfo != null && MMLog.isDebugEnabled()) {
                MoPubLog.d((String)("Rewarded Video Creative Info: " + creativeInfo));
            }
            MillennialUtils.postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    MoPubRewardedVideoManager.onRewardedVideoLoadSuccess(MillennialRewardedVideo.class, (String)interstitialAd.placementId);
                }
            });
        }

        public void onShowFailed(final InterstitialAd interstitialAd, InterstitialAd.InterstitialErrorStatus interstitialErrorStatus) {
            MoPubLog.d((String)("Millennial Rewarded Video Ad - Show failed (" + interstitialErrorStatus.getErrorCode() + "): " + interstitialErrorStatus.getDescription()));
            MillennialUtils.postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    MoPubRewardedVideoManager.onRewardedVideoPlaybackError(MillennialRewardedVideo.class, (String)interstitialAd.placementId, (MoPubErrorCode)MoPubErrorCode.VIDEO_PLAYBACK_ERROR);
                }
            });
        }

        public void onShown(final InterstitialAd interstitialAd) {
            MoPubLog.d((String)"Millennial Rewarded Video Ad - Ad shown");
            MillennialUtils.postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    MoPubRewardedVideoManager.onRewardedVideoStarted(MillennialRewardedVideo.class, (String)interstitialAd.placementId);
                }
            });
        }

        public boolean onVideoComplete() {
            MoPubLog.d((String)"Millennial Rewarded Video Ad - Video completed");
            MillennialUtils.postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    MoPubRewardedVideoManager.onRewardedVideoCompleted(MillennialRewardedVideo.class, (String)((MillennialRewardedVideo)MillennialRewardedVideo.this).millennialInterstitial.placementId, (MoPubReward)MoPubReward.success((String)"", (int)0));
                }
            });
            return false;
        }

        public boolean onCustomEvent(XIncentivizedEventListener.XIncentiveEvent xIncentiveEvent) {
            MoPubLog.d((String)("Millennial Rewarded Video Ad - Custom event received: " + xIncentiveEvent.eventId + ", " + xIncentiveEvent.args));
            return false;
        }
    }
}

