/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.view.View;
import com.millennialmedia.AppInfo;
import com.millennialmedia.CreativeInfo;
import com.millennialmedia.MMException;
import com.millennialmedia.MMLog;
import com.millennialmedia.MMSDK;
import com.millennialmedia.NativeAd;
import com.millennialmedia.internal.ActivityListenerManager;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.MillennialUtils;
import com.mopub.nativeads.BaseNativeAd;
import com.mopub.nativeads.ClickInterface;
import com.mopub.nativeads.CustomEventNative;
import com.mopub.nativeads.ImpressionInterface;
import com.mopub.nativeads.ImpressionTracker;
import com.mopub.nativeads.NativeClickHandler;
import com.mopub.nativeads.NativeErrorCode;
import com.mopub.nativeads.NativeImageHelper;
import com.mopub.nativeads.StaticNativeAd;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MillennialNative
extends CustomEventNative {
    private static final String DCN_KEY = "dcn";
    private static final String APID_KEY = "adUnitID";
    private static final String TAG = MillennialNative.class.getSimpleName();
    MillennialStaticNativeAd staticNativeAd;

    public CreativeInfo getCreativeInfo() {
        if (this.staticNativeAd == null) {
            return null;
        }
        return this.staticNativeAd.getCreativeInfo();
    }

    protected void loadNativeAd(Context context, CustomEventNative.CustomEventNativeListener customEventNativeListener, Map<String, Object> localExtras, Map<String, String> serverExtras) {
        if (context instanceof Activity) {
            try {
                MMSDK.initialize((Activity)((Activity)context), (ActivityListenerManager.LifecycleState)ActivityListenerManager.LifecycleState.RESUMED);
            }
            catch (IllegalStateException e) {
                MoPubLog.d((String)"Exception occurred initializing the MM SDK.", (Throwable)e);
                customEventNativeListener.onNativeAdFailed(NativeErrorCode.NATIVE_ADAPTER_CONFIGURATION_ERROR);
                return;
            }
        } else if (context instanceof Application) {
            try {
                MMSDK.initialize((Application)((Application)context));
            }
            catch (MMException e) {
                MoPubLog.d((String)"Exception occurred initializing the MM SDK.", (Throwable)e);
                customEventNativeListener.onNativeAdFailed(NativeErrorCode.NATIVE_ADAPTER_CONFIGURATION_ERROR);
                return;
            }
        } else {
            MoPubLog.d((String)"MM SDK must be initialized with an Activity or Application context.");
            customEventNativeListener.onNativeAdFailed(NativeErrorCode.NATIVE_ADAPTER_CONFIGURATION_ERROR);
            return;
        }
        String placementId = serverExtras.get(APID_KEY);
        String siteId = serverExtras.get(DCN_KEY);
        if (MillennialUtils.isEmpty(placementId)) {
            customEventNativeListener.onNativeAdFailed(NativeErrorCode.NATIVE_ADAPTER_CONFIGURATION_ERROR);
            return;
        }
        AppInfo ai = new AppInfo().setMediator("MoPubMM-1.3.0").setSiteId(siteId);
        try {
            MMSDK.setAppInfo((AppInfo)ai);
            NativeAd nativeAd = NativeAd.createInstance((String)placementId, (String)"inline");
            this.staticNativeAd = new MillennialStaticNativeAd(context, nativeAd, new ImpressionTracker(context), new NativeClickHandler(context), customEventNativeListener);
            this.staticNativeAd.loadAd();
        }
        catch (MMException e) {
            MoPubLog.d((String)"An exception occurred loading a native ad from MM SDK", (Throwable)e);
            customEventNativeListener.onNativeAdFailed(NativeErrorCode.NATIVE_ADAPTER_CONFIGURATION_ERROR);
        }
    }

    static {
        MoPubLog.d((String)"Millennial Media Adapter Version: MoPubMM-1.3.0");
    }

    static class MillennialStaticNativeAd
    extends StaticNativeAd
    implements NativeAd.NativeListener {
        private final Context context;
        private NativeAd nativeAd;
        private final ImpressionTracker impressionTracker;
        private final NativeClickHandler nativeClickHandler;
        private final CustomEventNative.CustomEventNativeListener listener;

        private MillennialStaticNativeAd(Context context, NativeAd nativeAd, ImpressionTracker impressionTracker, NativeClickHandler nativeClickHandler, CustomEventNative.CustomEventNativeListener customEventNativeListener) {
            this.context = context.getApplicationContext();
            this.nativeAd = nativeAd;
            this.impressionTracker = impressionTracker;
            this.nativeClickHandler = nativeClickHandler;
            this.listener = customEventNativeListener;
            nativeAd.setListener((NativeAd.NativeListener)this);
        }

        void loadAd() throws MMException {
            MoPubLog.d((String)"Millennial native ad loading.");
            this.nativeAd.load(this.context, null);
        }

        CreativeInfo getCreativeInfo() {
            if (this.nativeAd == null) {
                return null;
            }
            return this.nativeAd.getCreativeInfo();
        }

        public void prepare(View view) {
            this.nativeAd.getIconImage();
            this.nativeAd.getDisclaimer();
            this.impressionTracker.addView(view, (ImpressionInterface)this);
            this.nativeClickHandler.setOnClickListener(view, (ClickInterface)this);
        }

        public void clear(View view) {
            this.impressionTracker.removeView(view);
            this.nativeClickHandler.clearOnClickListener(view);
        }

        public void destroy() {
            this.impressionTracker.destroy();
            this.nativeAd.destroy();
            this.nativeAd = null;
        }

        public void recordImpression(View view) {
            this.notifyAdImpressed();
            try {
                this.nativeAd.fireImpression();
                MoPubLog.d((String)"Millennial native ad impression recorded.");
            }
            catch (MMException e) {
                MoPubLog.d((String)"Error tracking Millennial native ad impression", (Throwable)e);
            }
        }

        public void handleClick(View view) {
            this.notifyAdClicked();
            this.nativeClickHandler.openClickDestinationUrl(this.getClickDestinationUrl(), view);
            this.nativeAd.fireCallToActionClicked();
            MoPubLog.d((String)"Millennial native ad clicked.");
        }

        public void onLoaded(NativeAd nativeAd) {
            CreativeInfo creativeInfo = this.getCreativeInfo();
            if (creativeInfo != null && MMLog.isDebugEnabled()) {
                MoPubLog.d((String)("Native Creative Info: " + creativeInfo));
            }
            String iconImageUrl = nativeAd.getImageUrl(NativeAd.ComponentName.ICON_IMAGE, 1);
            String mainImageUrl = nativeAd.getImageUrl(NativeAd.ComponentName.MAIN_IMAGE, 1);
            this.setTitle(nativeAd.getTitle().getText().toString());
            this.setText(nativeAd.getBody().getText().toString());
            this.setCallToAction(nativeAd.getCallToActionButton().getText().toString());
            String clickDestinationUrl = nativeAd.getCallToActionUrl();
            if (clickDestinationUrl == null) {
                MillennialUtils.postOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MoPubLog.d((String)"Millennial native ad encountered null destination url.");
                        MillennialStaticNativeAd.this.listener.onNativeAdFailed(NativeErrorCode.NATIVE_ADAPTER_CONFIGURATION_ERROR);
                    }
                });
                return;
            }
            this.setClickDestinationUrl(clickDestinationUrl);
            this.setIconImageUrl(iconImageUrl);
            this.setMainImageUrl(mainImageUrl);
            final ArrayList<String> urls = new ArrayList<String>();
            if (iconImageUrl != null) {
                urls.add(iconImageUrl);
            }
            if (mainImageUrl != null) {
                urls.add(mainImageUrl);
            }
            if (nativeAd.getDisclaimer() != null) {
                this.addExtra("disclaimer", nativeAd.getDisclaimer().getText());
            }
            if (nativeAd.getRating() != null) {
                this.addExtra("rating", nativeAd.getRating().getText());
            }
            MillennialUtils.postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    NativeImageHelper.preCacheImages((Context)MillennialStaticNativeAd.this.context, (List)urls, (NativeImageHelper.ImageListener)new NativeImageHelper.ImageListener(){

                        public void onImagesCached() {
                            MillennialStaticNativeAd.this.listener.onNativeAdLoaded((BaseNativeAd)MillennialStaticNativeAd.this);
                            MoPubLog.d((String)"Millennial native ad loaded.");
                        }

                        public void onImagesFailedToCache(NativeErrorCode errorCode) {
                            MillennialStaticNativeAd.this.listener.onNativeAdFailed(errorCode);
                        }
                    });
                }
            });
        }

        public void onLoadFailed(NativeAd nativeAd, NativeAd.NativeErrorStatus nativeErrorStatus) {
            NativeErrorCode error;
            switch (nativeErrorStatus.getErrorCode()) {
                case 6: {
                    error = NativeErrorCode.NETWORK_TIMEOUT;
                    break;
                }
                case 2: {
                    error = NativeErrorCode.CONNECTION_ERROR;
                    break;
                }
                case 7: {
                    error = NativeErrorCode.UNSPECIFIED;
                    break;
                }
                case 3: 
                case 5: {
                    error = NativeErrorCode.UNEXPECTED_RESPONSE_CODE;
                    break;
                }
                case 1: {
                    error = NativeErrorCode.NATIVE_ADAPTER_CONFIGURATION_ERROR;
                    break;
                }
                case 4: 
                case 301: {
                    error = NativeErrorCode.UNSPECIFIED;
                    break;
                }
                default: {
                    error = NativeErrorCode.NETWORK_NO_FILL;
                }
            }
            MillennialUtils.postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    MillennialStaticNativeAd.this.listener.onNativeAdFailed(error);
                }
            });
            MoPubLog.d((String)("Millennial native ad failed: " + nativeErrorStatus.getDescription()));
        }

        public void onClicked(NativeAd nativeAd, NativeAd.ComponentName componentName, int i) {
            MoPubLog.d((String)"Millennial native ad click tracker fired.");
        }

        public void onAdLeftApplication(NativeAd nativeAd) {
            MoPubLog.d((String)"Millennial native ad has left the application.");
        }

        public void onExpired(NativeAd nativeAd) {
            MoPubLog.d((String)"Millennial native ad has expired!");
        }
    }
}

