/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.volley.toolbox;

import com.mopub.volley.AuthFailureError;
import com.mopub.volley.Request;
import com.mopub.volley.toolbox.HttpStack;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class HttpClientStack
implements HttpStack {
    protected final HttpClient mClient;
    private static final String HEADER_CONTENT_TYPE = "Content-Type";

    public HttpClientStack(HttpClient client) {
        this.mClient = client;
    }

    private static void addHeaders(HttpUriRequest httpRequest, Map<String, String> headers) {
        for (String key : headers.keySet()) {
            httpRequest.setHeader(key, headers.get(key));
        }
    }

    private static List<NameValuePair> getPostParameterPairs(Map<String, String> postParams) {
        ArrayList<NameValuePair> result = new ArrayList<NameValuePair>(postParams.size());
        for (String key : postParams.keySet()) {
            result.add((NameValuePair)new BasicNameValuePair(key, postParams.get(key)));
        }
        return result;
    }

    @Override
    public HttpResponse performRequest(Request<?> request, Map<String, String> additionalHeaders) throws IOException, AuthFailureError {
        HttpUriRequest httpRequest = HttpClientStack.createHttpRequest(request, additionalHeaders);
        HttpClientStack.addHeaders(httpRequest, additionalHeaders);
        HttpClientStack.addHeaders(httpRequest, request.getHeaders());
        this.onPrepareRequest(httpRequest);
        HttpParams httpParams = httpRequest.getParams();
        int timeoutMs = request.getTimeoutMs();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)5000);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)timeoutMs);
        return this.mClient.execute(httpRequest);
    }

    static HttpUriRequest createHttpRequest(Request<?> request, Map<String, String> additionalHeaders) throws AuthFailureError {
        switch (request.getMethod()) {
            case -1: {
                byte[] postBody = request.getPostBody();
                if (postBody != null) {
                    HttpPost postRequest = new HttpPost(request.getUrl());
                    postRequest.addHeader(HEADER_CONTENT_TYPE, request.getPostBodyContentType());
                    ByteArrayEntity entity = new ByteArrayEntity(postBody);
                    postRequest.setEntity((HttpEntity)entity);
                    return postRequest;
                }
                return new HttpGet(request.getUrl());
            }
            case 0: {
                return new HttpGet(request.getUrl());
            }
            case 3: {
                return new HttpDelete(request.getUrl());
            }
            case 1: {
                HttpPost postRequest = new HttpPost(request.getUrl());
                postRequest.addHeader(HEADER_CONTENT_TYPE, request.getBodyContentType());
                HttpClientStack.setEntityIfNonEmptyBody((HttpEntityEnclosingRequestBase)postRequest, request);
                return postRequest;
            }
            case 2: {
                HttpPut putRequest = new HttpPut(request.getUrl());
                putRequest.addHeader(HEADER_CONTENT_TYPE, request.getBodyContentType());
                HttpClientStack.setEntityIfNonEmptyBody((HttpEntityEnclosingRequestBase)putRequest, request);
                return putRequest;
            }
            case 4: {
                return new HttpHead(request.getUrl());
            }
            case 5: {
                return new HttpOptions(request.getUrl());
            }
            case 6: {
                return new HttpTrace(request.getUrl());
            }
            case 7: {
                HttpPatch patchRequest = new HttpPatch(request.getUrl());
                patchRequest.addHeader(HEADER_CONTENT_TYPE, request.getBodyContentType());
                HttpClientStack.setEntityIfNonEmptyBody(patchRequest, request);
                return patchRequest;
            }
        }
        throw new IllegalStateException("Unknown request method.");
    }

    private static void setEntityIfNonEmptyBody(HttpEntityEnclosingRequestBase httpRequest, Request<?> request) throws AuthFailureError {
        byte[] body = request.getBody();
        if (body != null) {
            ByteArrayEntity entity = new ByteArrayEntity(body);
            httpRequest.setEntity((HttpEntity)entity);
        }
    }

    protected void onPrepareRequest(HttpUriRequest request) throws IOException {
    }

    public static final class HttpPatch
    extends HttpEntityEnclosingRequestBase {
        public static final String METHOD_NAME = "PATCH";

        public HttpPatch() {
        }

        public HttpPatch(URI uri) {
            this.setURI(uri);
        }

        public HttpPatch(String uri) {
            this.setURI(URI.create(uri));
        }

        public String getMethod() {
            return METHOD_NAME;
        }
    }
}

