/*
 * Decompiled with CFR 0.152.
 */
package com.nascentdigital.pipeline;

import com.nascentdigital.pipeline.Aggregator;
import com.nascentdigital.pipeline.DuplicateKeyException;
import com.nascentdigital.pipeline.Grouping;
import com.nascentdigital.pipeline.NoElementFoundException;
import com.nascentdigital.pipeline.PipelineOperation;
import com.nascentdigital.pipeline.Predicate;
import com.nascentdigital.pipeline.Selector;
import com.nascentdigital.pipeline.annotations.Group;
import com.nascentdigital.pipeline.annotations.GroupType;
import com.nascentdigital.pipeline.operations.ArraySourceOperation;
import com.nascentdigital.pipeline.operations.CastOperation;
import com.nascentdigital.pipeline.operations.ConcatOperation;
import com.nascentdigital.pipeline.operations.DistinctOperation;
import com.nascentdigital.pipeline.operations.FilterOperation;
import com.nascentdigital.pipeline.operations.FlatProjectionOperation;
import com.nascentdigital.pipeline.operations.GroupByOperation;
import com.nascentdigital.pipeline.operations.IterableSourceOperation;
import com.nascentdigital.pipeline.operations.ProjectionOperation;
import com.nascentdigital.pipeline.operations.SkipOperation;
import com.nascentdigital.pipeline.operations.SkipWhileOperation;
import com.nascentdigital.pipeline.operations.TakeOperation;
import com.nascentdigital.pipeline.operations.TakeWhileOperation;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Pipeline<TElement>
implements Iterable<TElement> {
    private final PipelineOperation<TElement> _operation;

    private Pipeline(PipelineOperation<TElement> operation) {
        this._operation = operation;
    }

    @Group(type=GroupType.Creation)
    public static <TElement> Pipeline<TElement> from(TElement[] source) {
        return new Pipeline<TElement>(new ArraySourceOperation<TElement>(source));
    }

    @Group(type=GroupType.Creation)
    public static <TElement> Pipeline<TElement> from(Iterable<TElement> source) {
        return new Pipeline<TElement>(new IterableSourceOperation<TElement>(source));
    }

    @Group(type=GroupType.Creation)
    public static <TKey, TValue> Pipeline<Map.Entry<TKey, TValue>> from(Map<TKey, TValue> map) {
        Set<Map.Entry<TKey, TValue>> source = map.entrySet();
        return new Pipeline<Map.Entry<TKey, TValue>>(new IterableSourceOperation<Map.Entry<TKey, TValue>>(source));
    }

    @Group(type=GroupType.Concatenation)
    public Pipeline<TElement> concat(Iterable<TElement> addition) {
        if (addition == null) {
            return this;
        }
        return new Pipeline<TElement>(new ConcatOperation<TElement>(this, addition));
    }

    @Group(type=GroupType.Concatenation)
    public Pipeline<TElement> concat(TElement[] addition) {
        if (addition == null) {
            return this;
        }
        return new Pipeline<TElement>(new ConcatOperation<TElement>(this, Arrays.asList(addition)));
    }

    @Group(type=GroupType.Concatenation)
    public String join(CharSequence separator) {
        String string;
        TElement element;
        StringBuilder builder = new StringBuilder();
        Iterator<TElement> iterator = this.iterator();
        if (iterator.hasNext()) {
            element = iterator.next();
            string = element == null ? "" : element.toString();
            builder.append(string);
        }
        while (iterator.hasNext()) {
            builder.append(separator);
            element = iterator.next();
            string = element == null ? "" : element.toString();
            builder.append(string);
        }
        return builder.toString();
    }

    @Group(type=GroupType.Filtering)
    public Pipeline<TElement> where(Predicate<TElement> predicate) {
        return new Pipeline<TElement>(new FilterOperation<TElement>(this, predicate));
    }

    @Group(type=GroupType.Filtering)
    public Pipeline<TElement> distinct() {
        return new Pipeline(new DistinctOperation(this));
    }

    @Group(type=GroupType.Projection)
    public <TProjected> Pipeline<TProjected> map(Selector<TElement, TProjected> selector) {
        return new Pipeline<TElement>(new ProjectionOperation<TElement, TProjected>(this, selector));
    }

    @Group(type=GroupType.Projection)
    public <TProjected> Pipeline<TProjected> flatMap(Selector<TElement, Iterable<TProjected>> selector) {
        return new Pipeline<TElement>(new FlatProjectionOperation<TElement, TProjected>(this, selector));
    }

    @Group(type=GroupType.PartitionOperators)
    public Pipeline<TElement> skip(int count) {
        return new Pipeline(new SkipOperation(this, count));
    }

    @Group(type=GroupType.PartitionOperators)
    public Pipeline<TElement> skipWhile(Predicate<TElement> predicate) {
        return new Pipeline<TElement>(new SkipWhileOperation<TElement>(this, predicate));
    }

    @Group(type=GroupType.PartitionOperators)
    public Pipeline<TElement> take(int count) {
        return new Pipeline(new TakeOperation(this, count));
    }

    @Group(type=GroupType.PartitionOperators)
    public Pipeline<TElement> takeWhile(Predicate<TElement> predicate) {
        return new Pipeline<TElement>(new TakeWhileOperation<TElement>(this, predicate));
    }

    @Group(type=GroupType.Reduce)
    public <TOutput> TOutput reduce(Aggregator<TElement, TOutput> aggregator, TOutput initial) {
        TOutput aggregate = initial;
        for (TElement element : this) {
            aggregate = aggregator.aggregate(aggregate, element);
        }
        return aggregate;
    }

    @Group(type=GroupType.Aggregation)
    public int count() {
        int count = 0;
        Iterator<TElement> iterator = this.iterator();
        while (iterator.hasNext()) {
            ++count;
            iterator.next();
        }
        return count;
    }

    @Group(type=GroupType.Aggregation)
    public int count(Predicate<TElement> predicate) {
        int count = 0;
        for (TElement element : this) {
            if (!predicate.evaluate(element)) continue;
            ++count;
        }
        return count;
    }

    @Group(type=GroupType.Sum)
    public byte sumBytes(Selector<TElement, Number> selector) {
        byte total = 0;
        for (TElement element : this) {
            Number value = selector.select(element);
            if (value == null) continue;
            total = (byte)(total + value.byteValue());
        }
        return total;
    }

    @Group(type=GroupType.Sum)
    public short sumShorts(Selector<TElement, Number> selector) {
        short total = 0;
        for (TElement element : this) {
            Number value = selector.select(element);
            if (value == null) continue;
            total = (short)(total + value.shortValue());
        }
        return total;
    }

    @Group(type=GroupType.Sum)
    public int sumInts(Selector<TElement, Number> selector) {
        int total = 0;
        for (TElement element : this) {
            Number value = selector.select(element);
            if (value == null) continue;
            total += value.intValue();
        }
        return total;
    }

    @Group(type=GroupType.Sum)
    public long sumLongs(Selector<TElement, Number> selector) {
        long total = 0L;
        for (TElement element : this) {
            Number value = selector.select(element);
            if (value == null) continue;
            total += value.longValue();
        }
        return total;
    }

    @Group(type=GroupType.Sum)
    public float sumFloats(Selector<TElement, Number> selector) {
        float total = 0.0f;
        for (TElement element : this) {
            Number value = selector.select(element);
            if (value == null) continue;
            total += value.floatValue();
        }
        return total;
    }

    @Group(type=GroupType.Sum)
    public double sumDoubles(Selector<TElement, Number> selector) {
        double total = 0.0;
        for (TElement element : this) {
            Number value = selector.select(element);
            if (value == null) continue;
            total += value.doubleValue();
        }
        return total;
    }

    @Group(type=GroupType.Min)
    public Byte minByte(Selector<TElement, Byte> selector) {
        Byte minimum = null;
        for (TElement element : this) {
            Byte value = selector.select(element);
            if (minimum == null) {
                minimum = value;
                continue;
            }
            if (value == null || minimum.compareTo(value) <= 0) continue;
            minimum = value;
        }
        return minimum;
    }

    @Group(type=GroupType.Min)
    public Short minShort(Selector<TElement, Short> selector) {
        Short minimum = null;
        for (TElement element : this) {
            Short value = selector.select(element);
            if (minimum == null) {
                minimum = value;
                continue;
            }
            if (value == null || minimum.compareTo(value) <= 0) continue;
            minimum = value;
        }
        return minimum;
    }

    @Group(type=GroupType.Min)
    public Integer minInteger(Selector<TElement, Integer> selector) {
        Integer minimum = null;
        for (TElement element : this) {
            Integer value = selector.select(element);
            if (minimum == null) {
                minimum = value;
                continue;
            }
            if (value == null || minimum.compareTo(value) <= 0) continue;
            minimum = value;
        }
        return minimum;
    }

    @Group(type=GroupType.Min)
    public Long minLong(Selector<TElement, Long> selector) {
        Long minimum = null;
        for (TElement element : this) {
            Long value = selector.select(element);
            if (minimum == null) {
                minimum = value;
                continue;
            }
            if (value == null || minimum.compareTo(value) <= 0) continue;
            minimum = value;
        }
        return minimum;
    }

    @Group(type=GroupType.Min)
    public Float minFloat(Selector<TElement, Float> selector) {
        Float minimum = null;
        for (TElement element : this) {
            Float value = selector.select(element);
            if (minimum == null) {
                minimum = value;
                continue;
            }
            if (value == null || minimum.compareTo(value) <= 0) continue;
            minimum = value;
        }
        return minimum;
    }

    @Group(type=GroupType.Min)
    public Double minDouble(Selector<TElement, Double> selector) {
        Double minimum = null;
        for (TElement element : this) {
            Double value = selector.select(element);
            if (minimum == null) {
                minimum = value;
                continue;
            }
            if (value == null || minimum.compareTo(value) <= 0) continue;
            minimum = value;
        }
        return minimum;
    }

    @Group(type=GroupType.Max)
    public Byte maxByte(Selector<TElement, Byte> selector) {
        Byte maximum = null;
        for (TElement element : this) {
            Byte value = selector.select(element);
            if (maximum == null) {
                maximum = value;
                continue;
            }
            if (value == null || maximum.compareTo(value) >= 0) continue;
            maximum = value;
        }
        return maximum;
    }

    @Group(type=GroupType.Max)
    public Short maxShort(Selector<TElement, Short> selector) {
        Short maximum = null;
        for (TElement element : this) {
            Short value = selector.select(element);
            if (maximum == null) {
                maximum = value;
                continue;
            }
            if (value == null || maximum.compareTo(value) >= 0) continue;
            maximum = value;
        }
        return maximum;
    }

    @Group(type=GroupType.Max)
    public Integer maxInteger(Selector<TElement, Integer> selector) {
        Integer maximum = null;
        for (TElement element : this) {
            Integer value = selector.select(element);
            if (maximum == null) {
                maximum = value;
                continue;
            }
            if (value == null || maximum.compareTo(value) >= 0) continue;
            maximum = value;
        }
        return maximum;
    }

    @Group(type=GroupType.Max)
    public Long maxLong(Selector<TElement, Long> selector) {
        Long maximum = null;
        for (TElement element : this) {
            Long value = selector.select(element);
            if (maximum == null) {
                maximum = value;
                continue;
            }
            if (value == null || maximum.compareTo(value) >= 0) continue;
            maximum = value;
        }
        return maximum;
    }

    @Group(type=GroupType.Max)
    public Float maxFloat(Selector<TElement, Float> selector) {
        Float maximum = null;
        for (TElement element : this) {
            Float value = selector.select(element);
            if (maximum == null) {
                maximum = value;
                continue;
            }
            if (value == null || maximum.compareTo(value) >= 0) continue;
            maximum = value;
        }
        return maximum;
    }

    @Group(type=GroupType.Max)
    public Double maxDouble(Selector<TElement, Double> selector) {
        Double maximum = null;
        for (TElement element : this) {
            Double value = selector.select(element);
            if (maximum == null) {
                maximum = value;
                continue;
            }
            if (value == null || maximum.compareTo(value) >= 0) continue;
            maximum = value;
        }
        return maximum;
    }

    @Group(type=GroupType.Grouping)
    public <TKey> Pipeline<Grouping<TKey, TElement>> groupBy(Selector<TElement, TKey> selector) {
        return new Pipeline<Grouping<TKey, TElement>>(new GroupByOperation<TElement, TKey>(this, selector));
    }

    @Group(type=GroupType.Quantification)
    public boolean contains(TElement value) {
        for (TElement element : this) {
            if (!(element == null ? value == null : element.equals(value))) continue;
            return true;
        }
        return false;
    }

    @Group(type=GroupType.Quantification)
    public boolean all(Predicate<TElement> predicate) {
        for (TElement element : this) {
            if (predicate.evaluate(element)) continue;
            return false;
        }
        return true;
    }

    @Group(type=GroupType.Quantification)
    public boolean any() {
        return this.iterator().hasNext();
    }

    @Group(type=GroupType.Quantification)
    public boolean any(Predicate<TElement> predicate) {
        for (TElement element : this) {
            if (!predicate.evaluate(element)) continue;
            return true;
        }
        return false;
    }

    @Group(type=GroupType.ElementOperators)
    public TElement first() throws NoElementFoundException {
        Iterator<TElement> iterator = this.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        throw new NoElementFoundException("Pipeline is empty.");
    }

    @Group(type=GroupType.ElementOperators)
    public TElement first(Predicate<TElement> predicate) throws NoElementFoundException {
        for (TElement element : this) {
            if (!predicate.evaluate(element)) continue;
            return element;
        }
        throw new NoElementFoundException("No element matching predicate.");
    }

    @Group(type=GroupType.ElementOperators)
    public TElement firstOrDefault() {
        try {
            return this.first();
        }
        catch (NoElementFoundException e) {
            return null;
        }
    }

    @Group(type=GroupType.ElementOperators)
    public TElement firstOrDefault(Predicate<TElement> predicate) {
        try {
            return this.first(predicate);
        }
        catch (NoElementFoundException e) {
            return null;
        }
    }

    @Group(type=GroupType.ConversionOperations)
    public <TDerived> Pipeline<TDerived> cast(Class<TDerived> targetClass) throws ClassCastException {
        return new Pipeline<TElement>(new CastOperation(this, targetClass));
    }

    @Group(type=GroupType.ConversionOperations)
    public TElement[] toArray(Class<TElement> elementType) {
        List<TElement> sequence = this.toList();
        Object[] array = (Object[])Array.newInstance(elementType, sequence.size());
        return array.length == 0 ? array : sequence.toArray(array);
    }

    @Group(type=GroupType.ConversionOperations)
    public List<TElement> toList() {
        ArrayList sequence = new ArrayList();
        for (Object element : this._operation) {
            sequence.add(element);
        }
        return sequence;
    }

    @Group(type=GroupType.ConversionOperations)
    public <TKey> Map<TKey, TElement> toMap(Selector<TElement, TKey> keySelector) throws DuplicateKeyException {
        HashMap<TKey, TElement> map = new HashMap<TKey, TElement>();
        for (TElement element : this) {
            TKey key = keySelector.select(element);
            if (map.containsKey(key)) {
                throw new DuplicateKeyException("Duplicate key encountered: " + key);
            }
            map.put(key, element);
        }
        return map;
    }

    @Group(type=GroupType.ConversionOperations)
    public <TKey, TValue> Map<TKey, TValue> toMap(Selector<TElement, TKey> keySelector, Selector<TElement, TValue> valueSelector) throws DuplicateKeyException {
        HashMap<TKey, TValue> map = new HashMap<TKey, TValue>();
        for (TElement element : this) {
            TKey key = keySelector.select(element);
            if (map.containsKey(key)) {
                throw new DuplicateKeyException("Duplicate key encountered: " + key);
            }
            TValue value = valueSelector.select(element);
            map.put(key, value);
        }
        return map;
    }

    @Override
    @Group(type=GroupType.InterfaceIterator)
    public Iterator<TElement> iterator() {
        return this._operation.iterator();
    }
}

