/*
 * Decompiled with CFR 0.152.
 */
package com.nascentdigital.pipeline.operations;

import com.nascentdigital.pipeline.Grouping;
import com.nascentdigital.pipeline.PipelineOperation;
import com.nascentdigital.pipeline.Selector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class GroupByOperation<TElement, TKey>
implements PipelineOperation<Grouping<TKey, TElement>> {
    private final Iterable<TElement> _source;
    private final Selector<TElement, TKey> _selector;

    public GroupByOperation(Iterable<TElement> source, Selector<TElement, TKey> selector) {
        this._source = source;
        this._selector = selector;
    }

    @Override
    public Iterator<Grouping<TKey, TElement>> iterator() {
        HashMap<TKey, ArrayList<TElement>> groups = new HashMap<TKey, ArrayList<TElement>>();
        for (TElement element : this._source) {
            TKey key = this._selector.select(element);
            ArrayList<TElement> group = (ArrayList<TElement>)groups.get(key);
            if (group == null) {
                group = new ArrayList<TElement>();
                groups.put(key, group);
            }
            group.add(element);
        }
        ArrayList groupings = new ArrayList();
        for (Map.Entry groupEntry : groups.entrySet()) {
            Grouping grouping = new Grouping(groupEntry.getKey(), (Iterable)groupEntry.getValue());
            groupings.add(grouping);
        }
        return groupings.iterator();
    }
}

