/*
 * Decompiled with CFR 0.152.
 */
package com.nascentdigital.pipeline.operations;

import com.nascentdigital.pipeline.PipelineOperation;
import com.nascentdigital.pipeline.Predicate;

public class SkipWhileOperation<TElement>
implements PipelineOperation<TElement> {
    private final Iterable<TElement> _source;
    private final Predicate<TElement> _predicate;

    public SkipWhileOperation(Iterable<TElement> source, Predicate<TElement> predicate) {
        this._source = source;
        this._predicate = predicate;
    }

    public Iterator iterator() {
        return new Iterator();
    }

    private class Iterator
    implements java.util.Iterator<TElement> {
        private final java.util.Iterator<TElement> _input;
        private TElement _firstElement;
        private boolean _first;

        Iterator() {
            for (Object element : SkipWhileOperation.this._source) {
                if (SkipWhileOperation.this._predicate.evaluate(element)) continue;
                this._firstElement = element;
                this._first = true;
                break;
            }
        }

        @Override
        public boolean hasNext() {
            return this._first || this._input.hasNext();
        }

        @Override
        public TElement next() {
            Object element;
            if (this._first) {
                element = this._firstElement;
                this._firstElement = null;
                this._first = false;
            } else {
                element = this._input.next();
            }
            return element;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not implemented.");
        }
    }
}

