/*
 * Decompiled with CFR 0.152.
 */
package com.neopixl.spitfire.request;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.android.volley.AuthFailureError;
import com.android.volley.Cache;
import com.android.volley.NetworkResponse;
import com.android.volley.ParseError;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.VolleyLog;
import com.android.volley.toolbox.HttpHeaderParser;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.neopixl.spitfire.SpitfireManager;
import com.neopixl.spitfire.listener.RequestListener;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class AbstractRequest<T>
extends Request<T> {
    private List<Integer> mAcceptedStatusCodes;
    private Class<T> classResponse;
    private byte[] body;
    @Nullable
    private final RequestListener<T> mListener;
    @Nullable
    private Map<String, String> headers;
    private NetworkResponse networkResponse;

    AbstractRequest(AbstractBuilder builder) {
        super(builder.method, builder.url, null);
        Map builderHeaders = builder.headers;
        this.headers = builderHeaders != null ? builderHeaders : new HashMap();
        this.classResponse = builder.classResponse;
        this.setShouldCache(builder.method == 0);
        this.mListener = builder.mListener;
        this.mAcceptedStatusCodes = new ArrayList<Integer>();
        this.mAcceptedStatusCodes.add(200);
        this.mAcceptedStatusCodes.add(204);
        this.mAcceptedStatusCodes.add(202);
        this.mAcceptedStatusCodes.add(201);
        this.setRetryPolicy(SpitfireManager.getDefaultRetryPolicy());
    }

    public void addAcceptedStatusCodes(@NonNull int[] statusCodes) {
        for (int statusCode : statusCodes) {
            this.mAcceptedStatusCodes.add(statusCode);
        }
    }

    public void addAcceptedStatusCodes(@NonNull int statusCodes) {
        this.mAcceptedStatusCodes.add(statusCodes);
    }

    @NonNull
    public List<Integer> getAcceptedStatusCodes() {
        return this.mAcceptedStatusCodes;
    }

    protected void deliverResponse(T response) {
        if (this.mListener != null) {
            this.mListener.onSuccess(this, this.networkResponse, response);
        }
    }

    public void deliverError(VolleyError error) {
        if (error != null && error.networkResponse != null && this.networkResponse == null) {
            this.networkResponse = error.networkResponse;
        }
        if (this.mListener != null) {
            this.mListener.onFailure(this, this.networkResponse, error);
        }
    }

    protected Response<T> parseNetworkResponse(NetworkResponse response) {
        this.networkResponse = response;
        JavaType returnType = this.getReturnType();
        Object returnData = null;
        if (returnType != null) {
            try {
                if (response.data != null) {
                    returnData = SpitfireManager.getObjectMapper().readValue(response.data, returnType);
                }
            }
            catch (Exception e) {
                VolleyLog.e((Throwable)e, (String)"An error occurred while parsing network response:", (Object[])new Object[0]);
                returnData = null;
            }
        }
        if (returnData == null && this.classResponse != Void.class) {
            ParseError parseError = new ParseError(response);
            String content = "";
            if (response.data != null) {
                content = new String(response.data);
            }
            VolleyLog.e((Throwable)parseError, (String)("Return data is null. API returned : " + content), (Object[])new Object[0]);
            return Response.error((VolleyError)parseError);
        }
        return Response.success(returnData, (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)response));
    }

    @Nullable
    private JavaType getReturnType() {
        if (this.classResponse == Void.class) {
            return null;
        }
        if (this.classResponse.isArray()) {
            return TypeFactory.defaultInstance().constructArrayType(this.classResponse.getComponentType());
        }
        if (this.classResponse == List.class) {
            return TypeFactory.defaultInstance().constructCollectionType(List.class, this.classResponse.getComponentType());
        }
        if (this.classResponse == Map.class) {
            return TypeFactory.defaultInstance().constructMapType(Map.class, String.class, this.classResponse.getComponentType());
        }
        return TypeFactory.defaultInstance().constructType(this.classResponse);
    }

    @NonNull
    public Map<String, String> getHeaders() throws AuthFailureError {
        HashMap<String, String> currentHeader = new HashMap<String, String>(super.getHeaders());
        currentHeader.putAll(this.headers);
        String bodyContentType = this.getBodyContentType();
        if (bodyContentType == null && currentHeader.containsKey("Content-Type")) {
            currentHeader.remove("Content-Type");
        }
        return currentHeader;
    }

    @Nullable
    public final byte[] getBody() throws AuthFailureError {
        if (this.body == null) {
            this.body = this.calculateBody();
        }
        return this.body;
    }

    byte[] calculateBody() throws AuthFailureError {
        if (this.getMethod() == 0) {
            return null;
        }
        Map params = this.getParams();
        return params != null && params.size() > 0 ? this.encodeParameters(params, this.getParamsEncoding()) : null;
    }

    private byte[] encodeParameters(Map<String, String> params, String paramsEncoding) {
        StringBuilder encodedParams = new StringBuilder();
        try {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                encodedParams.append(URLEncoder.encode(entry.getKey(), paramsEncoding));
                encodedParams.append('=');
                encodedParams.append(URLEncoder.encode(entry.getValue(), paramsEncoding));
                encodedParams.append('&');
            }
            return encodedParams.toString().getBytes(paramsEncoding);
        }
        catch (UnsupportedEncodingException var6) {
            throw new RuntimeException("Encoding not supported: " + paramsEncoding, var6);
        }
    }

    public static abstract class AbstractBuilder<T, RequestType extends AbstractRequest<T>> {
        protected int method = -10;
        @NonNull
        private String url;
        private Class<T> classResponse;
        @Nullable
        private RequestListener<T> mListener;
        private Map<String, String> headers;

        public AbstractBuilder(int method, @NonNull String url, Class<T> classResponse) {
            this.method = method;
            this.url = url;
            this.classResponse = classResponse;
        }

        public AbstractBuilder<T, RequestType> listener(@Nullable RequestListener<T> listener) {
            this.mListener = listener;
            return this;
        }

        public AbstractBuilder<T, RequestType> headers(@Nullable Map<String, String> headers) {
            this.headers = new HashMap<String, String>(headers);
            return this;
        }

        public abstract RequestType build();
    }
}

