/*
 * Decompiled with CFR 0.152.
 */
package com.neopixl.spitfire.request;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.android.volley.AuthFailureError;
import com.neopixl.spitfire.listener.RequestListener;
import com.neopixl.spitfire.model.RequestData;
import com.neopixl.spitfire.request.AbstractRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

public class UploadFileRequest<T>
extends AbstractRequest<T> {
    private RequestData partData;

    public UploadFileRequest(Builder<T> builder) {
        super(builder);
        this.partData = ((Builder)builder).partData;
        if (this.partData == null) {
            throw new IllegalArgumentException("Partdata should not be null.");
        }
        if (builder.method == 0) {
            throw new IllegalArgumentException("Cannot use streamfile with GET request");
        }
    }

    @NonNull
    public String getBodyContentType() {
        return this.getPartData().getType();
    }

    @Override
    @Nullable
    byte[] calculateBody() throws AuthFailureError {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            ByteArrayInputStream fileInputStream = new ByteArrayInputStream(this.getPartData().getContent());
            int bytesAvailable = fileInputStream.available();
            int maxBufferSize = 0x100000;
            int bufferSize = Math.min(bytesAvailable, maxBufferSize);
            byte[] buffer = new byte[bufferSize];
            int bytesRead = fileInputStream.read(buffer, 0, bufferSize);
            while (bytesRead > 0) {
                dos.write(buffer, 0, bufferSize);
                bytesAvailable = fileInputStream.available();
                bufferSize = Math.min(bytesAvailable, maxBufferSize);
                bytesRead = fileInputStream.read(buffer, 0, bufferSize);
            }
            return bos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public RequestData getPartData() {
        return this.partData;
    }

    public static class Builder<T>
    extends AbstractRequest.AbstractBuilder<T, UploadFileRequest<T>> {
        private RequestData partData;

        public Builder(int method, @NonNull String url, Class<T> classResponse) {
            super(method, url, classResponse);
        }

        public Builder<T> partData(@NonNull RequestData partData) {
            this.partData = partData;
            return this;
        }

        public Builder<T> listener(@Nullable RequestListener<T> listener) {
            super.listener(listener);
            return this;
        }

        public Builder<T> headers(@NonNull Map headers) {
            super.headers(headers);
            return this;
        }

        @Override
        public UploadFileRequest<T> build() {
            return new UploadFileRequest(this);
        }
    }
}

