/*
 * Decompiled with CFR 0.152.
 */
package com.neopixl.spitfire;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.RetryPolicy;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;

public final class SpitfireManager {
    @Nullable
    private static ObjectMapper objectMapper;
    @Nullable
    private static DefaultRetryPolicy customDefaultRetryPolicy;
    private static int requestTimeout;

    public static void setRequestTimeout(int timeout) {
        requestTimeout = timeout;
    }

    public static void setDefaultRetryPolicy(@NonNull DefaultRetryPolicy newRetryPolicy) {
        customDefaultRetryPolicy = newRetryPolicy;
    }

    @NonNull
    public static RetryPolicy getDefaultRetryPolicy() {
        return SpitfireManager.generateRetryPolicy();
    }

    @NonNull
    public static ObjectMapper getObjectMapper() {
        if (objectMapper == null) {
            objectMapper = new ObjectMapper();
            objectMapper.configure(SerializationFeature.INDENT_OUTPUT, false);
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
        return objectMapper;
    }

    public static void setObjectMapper(@NonNull ObjectMapper objectMapper) {
        if (objectMapper == null) {
            throw new IllegalArgumentException("Object mapper should not be null");
        }
        SpitfireManager.objectMapper = objectMapper;
    }

    @NonNull
    private static RetryPolicy generateRetryPolicy() {
        if (customDefaultRetryPolicy != null) {
            new DefaultRetryPolicy(customDefaultRetryPolicy.getCurrentTimeout(), customDefaultRetryPolicy.getCurrentRetryCount(), customDefaultRetryPolicy.getBackoffMultiplier());
        }
        return new DefaultRetryPolicy(requestTimeout, 1, 1.0f);
    }

    static {
        requestTimeout = 30000;
    }
}

