/*
 * Decompiled with CFR 0.152.
 */
package com.neopixl.spitfire.request;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.android.volley.AuthFailureError;
import com.android.volley.VolleyLog;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.neopixl.spitfire.SpitfireManager;
import com.neopixl.spitfire.listener.RequestListener;
import com.neopixl.spitfire.request.AbstractRequest;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class BaseRequest<T>
extends AbstractRequest<T> {
    @Nullable
    private final Object jsonObject;
    @Nullable
    private final Map<String, String> parameters;

    protected BaseRequest(Builder builder) {
        super(builder);
        this.parameters = builder.parameters;
        this.jsonObject = builder.jsonObject;
        if (builder.method == 0 && this.jsonObject != null) {
            throw new IllegalArgumentException("Cannot use json body request with GET");
        }
    }

    @NonNull
    public String getJsonContentType() {
        return "application/json; charset=" + this.getParamsEncoding();
    }

    @NonNull
    public String getBodyContentType() {
        if (HTTP_METHOD_JSON_ALLOWED.contains(this.getMethod()) && this.getJsonObject() != null) {
            return this.getJsonContentType();
        }
        return super.getBodyContentType();
    }

    @Override
    @Nullable
    byte[] calculateBody() throws AuthFailureError {
        String bodyContentType = this.getBodyContentType();
        int method = this.getMethod();
        if (method != 0 && bodyContentType != null && bodyContentType.equals(this.getJsonContentType())) {
            return this.getJsonBody();
        }
        return super.calculateBody();
    }

    @Nullable
    public byte[] getJsonBody() {
        byte[] ptext;
        try {
            ptext = SpitfireManager.getObjectMapper().writeValueAsBytes(this.getJsonObject());
        }
        catch (JsonProcessingException e) {
            JSONObject object = new JSONObject(this.getParams());
            ptext = object.toString().getBytes();
        }
        try {
            VolleyLog.d((String)("Sending JSON BODY : " + new String(ptext, this.getParamsEncoding())), (Object[])new Object[0]);
        }
        catch (Exception e) {
            VolleyLog.d((String)"Sending JSON BODY", (Object[])new Object[0]);
        }
        return ptext;
    }

    @NonNull
    public String getUrl() {
        int method = this.getMethod();
        String topUrl = super.getUrl();
        if (method == 0) {
            return this.parseGetUrl(method, topUrl, this.getParams(), this.getParamsEncoding());
        }
        return topUrl;
    }

    @Nullable
    public Object getJsonObject() {
        return this.jsonObject;
    }

    @Nullable
    public Map<String, String> getParams() {
        return this.parameters;
    }

    @NonNull
    protected String parseGetUrl(int method, @NonNull String url, @Nullable Map<String, String> params, @NonNull String encoding) {
        if (method == 0 && params != null && !params.isEmpty()) {
            StringBuilder result = new StringBuilder(url);
            int startLength = result.length();
            for (String key : params.keySet()) {
                try {
                    String encodedKey = URLEncoder.encode(key, encoding);
                    String encodedValue = URLEncoder.encode(params.get(key), encoding);
                    if (result.length() > startLength) {
                        result.append("&");
                    } else {
                        result.append("?");
                    }
                    result.append(encodedKey);
                    result.append("=");
                    result.append(encodedValue);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return result.toString();
        }
        return url;
    }

    public static class Builder<T>
    extends AbstractRequest.AbstractBuilder<T, BaseRequest<T>> {
        @Nullable
        private Map<String, String> parameters;
        @Nullable
        private Object jsonObject;

        public Builder(int method, @NonNull String url, @NonNull Class<T> classResponse) {
            super(method, url, classResponse);
        }

        @NonNull
        public Builder<T> json(@Nullable Object jsonObject) {
            this.jsonObject = jsonObject;
            return this;
        }

        @NonNull
        public Builder<T> parameters(@NonNull Map<String, String> parameters) {
            this.parameters = new HashMap<String, String>(parameters);
            return this;
        }

        @NonNull
        public Builder<T> listener(@Nullable RequestListener<T> listener) {
            super.listener(listener);
            return this;
        }

        @NonNull
        public Builder<T> headers(@Nullable Map<String, String> headers) {
            super.headers(headers);
            return this;
        }

        @Override
        @NonNull
        public BaseRequest<T> build() {
            return new BaseRequest(this);
        }
    }
}

