/*
 * Decompiled with CFR 0.152.
 */
package com.neopixl.spitfire.request;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.android.volley.AuthFailureError;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.neopixl.spitfire.SpitfireManager;
import com.neopixl.spitfire.listener.RequestListener;
import com.neopixl.spitfire.model.RequestData;
import com.neopixl.spitfire.request.BaseRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultipartRequest<T>
extends BaseRequest<T> {
    private static final String JSON_KEY_DEFAULT = "jsonObject";
    private final String twoHyphens = "--";
    private final String lineEnd = "\r\n";
    private final String boundary = "bound-" + System.currentTimeMillis();
    @Nullable
    private final HashMap<String, List<RequestData>> multiPartData;
    @NonNull
    private String jsonKey = "jsonObject";

    private MultipartRequest(Builder<T> builder) {
        super(builder);
        this.multiPartData = ((Builder)builder).multiPartData;
        this.jsonKey = ((Builder)builder).jsonKey;
        if (builder.method == 0) {
            throw new IllegalArgumentException("Cannot use multipart with GET request");
        }
    }

    @Override
    @NonNull
    public String getBodyContentType() {
        return "multipart/form-data;boundary=" + this.boundary;
    }

    @Override
    @Nullable
    byte[] calculateBody() throws AuthFailureError {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            Object jsonBody = this.getJsonObject();
            if (jsonBody == null) {
                Map<String, String> params = this.getParams();
                if (params != null && params.size() > 0) {
                    this.textParse(dos, params, this.getParamsEncoding());
                }
            } else {
                this.jsonParse(dos, jsonBody);
            }
            HashMap<String, List<RequestData>> data = this.getMultiPartData();
            if (data != null && data.size() > 0) {
                this.dataParse(dos, data);
            }
            dos.writeBytes("--" + this.boundary + "--" + "\r\n");
            return bos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    void textParse(@NonNull DataOutputStream dataOutputStream, @Nullable Map<String, String> params, @NonNull String encoding) throws IOException {
        if (params == null) {
            return;
        }
        try {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                this.buildTextPart(dataOutputStream, entry.getKey(), entry.getValue());
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Encoding not supported: " + encoding, uee);
        }
    }

    void jsonParse(@NonNull DataOutputStream dataOutputStream, @NonNull Object jsonObject) throws IOException {
        try {
            String json = SpitfireManager.getObjectMapper().writeValueAsString(jsonObject);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("--" + this.boundary + "\r\n");
            stringBuilder.append("Content-Disposition: form-data; name=\"" + this.jsonKey + "\"" + "\r\n");
            stringBuilder.append("Content-Type: application/json\r\n");
            stringBuilder.append("\r\n");
            stringBuilder.append(json);
            stringBuilder.append("\r\n");
            dataOutputStream.writeBytes(stringBuilder.toString());
        }
        catch (JsonProcessingException e) {
            this.textParse(dataOutputStream, this.getParams(), this.getParamsEncoding());
        }
    }

    void dataParse(@NonNull DataOutputStream dataOutputStream, @NonNull Map<String, List<RequestData>> data) throws IOException {
        for (Map.Entry<String, List<RequestData>> entry : data.entrySet()) {
            for (RequestData datapart : entry.getValue()) {
                this.buildDataPart(dataOutputStream, datapart, entry.getKey());
            }
        }
    }

    void buildTextPart(@NonNull DataOutputStream dataOutputStream, @NonNull String parameterName, @NonNull String parameterValue) throws IOException {
        dataOutputStream.writeBytes("--" + this.boundary + "\r\n");
        dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"" + parameterName + "\"" + "\r\n");
        dataOutputStream.writeBytes("\r\n");
        dataOutputStream.writeBytes(parameterValue + "\r\n");
    }

    void buildDataPart(@NonNull DataOutputStream dataOutputStream, @NonNull RequestData dataFile, @NonNull String inputName) throws IOException {
        dataOutputStream.writeBytes("--" + this.boundary + "\r\n");
        dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"" + inputName + "\"; filename=\"" + dataFile.getFileName() + "\"" + "\r\n");
        if (dataFile.getType() != null && !dataFile.getType().trim().isEmpty()) {
            dataOutputStream.writeBytes("Content-Type: " + dataFile.getType() + "\r\n");
        }
        dataOutputStream.writeBytes("\r\n");
        ByteArrayInputStream fileInputStream = new ByteArrayInputStream(dataFile.getContent());
        int bytesAvailable = fileInputStream.available();
        int maxBufferSize = 0x100000;
        int bufferSize = Math.min(bytesAvailable, maxBufferSize);
        byte[] buffer = new byte[bufferSize];
        int bytesRead = fileInputStream.read(buffer, 0, bufferSize);
        while (bytesRead > 0) {
            dataOutputStream.write(buffer, 0, bufferSize);
            bytesAvailable = fileInputStream.available();
            bufferSize = Math.min(bytesAvailable, maxBufferSize);
            bytesRead = fileInputStream.read(buffer, 0, bufferSize);
        }
        dataOutputStream.writeBytes("\r\n");
    }

    @Nullable
    public HashMap<String, List<RequestData>> getMultiPartData() {
        return this.multiPartData;
    }

    @NonNull
    public String getJsonKey() {
        return this.jsonKey;
    }

    public static class Builder<T>
    extends BaseRequest.Builder<T> {
        @NonNull
        private final HashMap<String, List<RequestData>> multiPartData = new HashMap();
        @NonNull
        private String jsonKey = "jsonObject";

        public Builder(int method, @NonNull String url, @NonNull Class<T> classResponse) {
            super(method, url, classResponse);
        }

        @Override
        @NonNull
        public Builder<T> json(@Nullable Object jsonObject) {
            super.json(jsonObject);
            return this;
        }

        @NonNull
        public Builder<T> json(@NonNull String jsonKey, @Nullable Object jsonObject) {
            super.json(jsonObject);
            this.jsonKey = jsonKey;
            return this;
        }

        @Override
        @NonNull
        public Builder<T> parameters(@NonNull Map<String, String> parameters) {
            super.parameters(parameters);
            return this;
        }

        @Override
        @NonNull
        public Builder<T> listener(@Nullable RequestListener<T> listener) {
            super.listener((RequestListener)listener);
            return this;
        }

        @Override
        @NonNull
        public Builder<T> headers(@Nullable Map<String, String> headers) {
            super.headers((Map)headers);
            return this;
        }

        @NonNull
        public Builder<T> multiPartData(@NonNull HashMap<String, RequestData> multiPartData) {
            for (Map.Entry<String, RequestData> entry : multiPartData.entrySet()) {
                List<RequestData> currentAddedList = this.multiPartData.get(entry.getKey());
                if (currentAddedList == null) {
                    currentAddedList = new ArrayList<RequestData>();
                }
                currentAddedList.add(entry.getValue());
                this.multiPartData.put(entry.getKey(), currentAddedList);
            }
            return this;
        }

        @NonNull
        public Builder<T> multiPartDataList(@NonNull HashMap<String, List<RequestData>> multiPartData) {
            for (Map.Entry<String, List<RequestData>> entry : multiPartData.entrySet()) {
                List<RequestData> currentAddedList = this.multiPartData.get(entry.getKey());
                if (currentAddedList == null) {
                    currentAddedList = new ArrayList<RequestData>();
                }
                currentAddedList.addAll((Collection<RequestData>)entry.getValue());
                this.multiPartData.put(entry.getKey(), currentAddedList);
            }
            return this;
        }

        @NonNull
        public Builder<T> insertMultiPartData(@NonNull String key, @NonNull RequestData partData) {
            List<RequestData> currentAddedList = this.multiPartData.get(key);
            if (currentAddedList == null) {
                currentAddedList = new ArrayList<RequestData>();
            }
            currentAddedList.add(partData);
            this.multiPartData.put(key, currentAddedList);
            return this;
        }

        @Override
        @NonNull
        public MultipartRequest<T> build() {
            return new MultipartRequest(this);
        }
    }
}

