/*
 * Decompiled with CFR 0.152.
 */
package com.olekdia.sparsearray;

import com.olekdia.common.extensions.ArrayExt;
import com.olekdia.sparsearray.ArrayExtKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.jvm.internal.markers.KMutableMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0010\u001c\n\u0002\u0010&\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0016\n\u0002\u0010)\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\f\b\u0016\u0018\u0000 N*\u0004\b\u0000\u0010\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\u00010\u00022\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\u00010\u00050\u0004:\u0003NOPB\u000f\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001b\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00028\u0000\u00a2\u0006\u0002\u0010*J\b\u0010+\u001a\u00020'H\u0016J\u0010\u0010,\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u0003H\u0016J\u0015\u0010-\u001a\u00020\u00162\u0006\u0010)\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010.J\u000e\u0010/\u001a\u00020\u00072\u0006\u00100\u001a\u00020\u0007J\u0010\u00101\u001a\u00020\u00072\u0006\u00100\u001a\u00020\u0007H\u0002J\b\u00102\u001a\u00020'H\u0002J\u0018\u00103\u001a\u0004\u0018\u00018\u00002\u0006\u0010(\u001a\u00020\u0003H\u0096\u0002\u00a2\u0006\u0002\u00104J\u001e\u00103\u001a\u00028\u00002\u0006\u0010(\u001a\u00020\u00032\u0006\u00105\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u00106J\u001b\u00107\u001a\u00028\u00002\u0006\u0010(\u001a\u00020\u00032\u0006\u00105\u001a\u00028\u0000\u00a2\u0006\u0002\u00106J\u0013\u00108\u001a\u00020\u00072\u0006\u0010)\u001a\u00028\u0000\u00a2\u0006\u0002\u00109J\u000e\u0010:\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u0003J\u0013\u0010;\u001a\u00020\u00072\u0006\u0010)\u001a\u00028\u0000\u00a2\u0006\u0002\u00109J\b\u0010<\u001a\u00020\u0016H\u0016J\u001b\u0010=\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00000\u00050>H\u0096\u0002J\u0015\u0010?\u001a\u0004\u0018\u00010\u00032\u0006\u0010@\u001a\u00020\u0007\u00a2\u0006\u0002\u0010AJ\u001f\u0010B\u001a\u0004\u0018\u00018\u00002\u0006\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00106J\u001e\u0010C\u001a\u00020'2\u0014\u0010D\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00000EH\u0016J\u0017\u0010F\u001a\u0004\u0018\u00018\u00002\u0006\u0010(\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u00104J\u001b\u0010F\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u00032\u0006\u0010G\u001a\u00028\u0000\u00a2\u0006\u0002\u0010HJ\u000e\u0010I\u001a\u00020'2\u0006\u0010@\u001a\u00020\u0007J\u0016\u0010J\u001a\u00020'2\u0006\u0010@\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007J\u0016\u0010K\u001a\u00020\u00162\u0006\u0010@\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u0003J\u0015\u0010L\u001a\u0004\u0018\u00018\u00002\u0006\u0010@\u001a\u00020\u0007\u00a2\u0006\u0002\u0010MR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR&\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00000\u00120\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0014R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000\u001a8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001c\u00a8\u0006Q"}, d2={"Lcom/olekdia/sparsearray/LongSparseArray;", "E", "", "", "", "", "initialCapacity", "", "(I)V", "_keys", "", "_size", "_values", "", "", "[Ljava/lang/Object;", "entries", "", "", "getEntries", "()Ljava/util/Set;", "garbage", "", "keys", "getKeys", "keysIterator", "", "getKeysIterator", "()Ljava/util/Iterator;", "size", "getSize", "()I", "values", "", "getValues", "()Ljava/util/List;", "valuesIterator", "getValuesIterator", "append", "", "key", "value", "(JLjava/lang/Object;)V", "clear", "containsKey", "containsValue", "(Ljava/lang/Object;)Z", "ensureCapacity", "capacity", "expandToCapacity", "gc", "get", "(J)Ljava/lang/Object;", "defaultValue", "(JLjava/lang/Object;)Ljava/lang/Object;", "getOrDefault", "indexOfEqualValue", "(Ljava/lang/Object;)I", "indexOfKey", "indexOfSameValue", "isEmpty", "iterator", "", "keyAt", "index", "(I)Ljava/lang/Long;", "put", "putAll", "from", "", "remove", "valueToRemove", "(JLjava/lang/Object;)Z", "removeAt", "removeAtRange", "setKeyAt", "valueAt", "(I)Ljava/lang/Object;", "Companion", "Entry", "MutableEntry", "multiplatform-sparse-array"})
public class LongSparseArray<E>
implements Map<Long, E>,
Iterable<Map.Entry<? extends Long, ? extends E>>,
KMutableMap,
KMappedMarker {
    private boolean garbage;
    private long[] _keys;
    private Object[] _values;
    private int _size;
    private int initialCapacity;
    private static final Object DELETED;
    public static final Companion Companion;

    public int getSize() {
        if (this.garbage) {
            this.gc();
        }
        return this._size;
    }

    @Override
    public boolean isEmpty() {
        if (this.garbage) {
            this.gc();
        }
        return this.size() == 0;
    }

    public boolean containsKey(long key) {
        if (this.garbage) {
            this.gc();
        }
        return this.indexOfKey(key) >= 0;
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.garbage) {
            this.gc();
        }
        return this.indexOfEqualValue(value) >= 0;
    }

    @Nullable
    public E get(long key) {
        Object object;
        int n = ArrayExt.binarySearch$default((long[])this._keys, (long)key, (int)0, (int)this._size, (int)2, null);
        boolean bl = false;
        boolean bl2 = false;
        int i = n;
        boolean bl3 = false;
        if (i < 0) {
            object = null;
        } else {
            Object object2 = this._values[i];
            boolean bl4 = false;
            boolean bl5 = false;
            Object value = object2;
            boolean bl6 = false;
            if (value == DELETED) {
                object = null;
            } else {
                object = value;
                if (!(object instanceof Object)) {
                    object = null;
                }
            }
        }
        return (E)object;
    }

    public final E get(long key, E defaultValue) {
        return (E)this.getOrDefault((Object)key, (Object)defaultValue);
    }

    public final E getOrDefault(long key, E defaultValue) {
        Object object;
        int n = ArrayExt.binarySearch$default((long[])this._keys, (long)key, (int)0, (int)this._size, (int)2, null);
        boolean bl = false;
        boolean bl2 = false;
        int i = n;
        boolean bl3 = false;
        if (i < 0) {
            object = defaultValue;
        } else {
            Object object2 = this._values[i];
            boolean bl4 = false;
            boolean bl5 = false;
            Object value = object2;
            boolean bl6 = false;
            if (value == DELETED) {
                object = defaultValue;
            } else {
                Object object3 = value;
                if (!(object3 instanceof Object)) {
                    object3 = object = null;
                }
                if (object3 == null) {
                    object = defaultValue;
                }
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<Long> getKeys() {
        if (this.garbage) {
            this.gc();
        }
        LinkedHashSet<Long> linkedHashSet = new LinkedHashSet<Long>(this._size);
        boolean bl = false;
        boolean bl2 = false;
        LinkedHashSet<Long> it = linkedHashSet;
        boolean bl3 = false;
        int n = 0;
        int n2 = this._size;
        while (n < n2) {
            void i;
            it.add(this._keys[i]);
            ++i;
        }
        return linkedHashSet;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<E> getValues() {
        if (this.garbage) {
            this.gc();
        }
        int n = this._size;
        boolean bl = false;
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        boolean bl2 = false;
        int n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            void it;
            int n4 = n2++;
            boolean bl3 = false;
            int n5 = n4;
            ArrayList<Object> arrayList2 = arrayList;
            boolean bl4 = false;
            Object object = this._values[it];
            arrayList2.add(object);
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<Map.Entry<Long, E>> getEntries() {
        if (this.garbage) {
            this.gc();
        }
        LinkedHashSet<MutableEntry<Object>> linkedHashSet = new LinkedHashSet<MutableEntry<Object>>(this._size);
        boolean bl = false;
        boolean bl2 = false;
        LinkedHashSet<MutableEntry<Object>> it = linkedHashSet;
        boolean bl3 = false;
        int n = 0;
        int n2 = this._size;
        while (n < n2) {
            void i;
            it.add(new MutableEntry<Object>(this._keys[i], this._values[i]));
            ++i;
        }
        return linkedHashSet;
    }

    @Override
    @Nullable
    public E put(long key, E value) {
        int i = ArrayExt.binarySearch$default((long[])this._keys, (long)key, (int)0, (int)this._size, (int)2, null);
        if (i >= 0) {
            Object object = this._values[i];
            if (!(object instanceof Object)) {
                object = null;
            }
            Object oldValue = object;
            this._values[i] = value;
            return (E)oldValue;
        }
        if ((i ^= 0xFFFFFFFF) < this._size && this._values[i] == DELETED) {
            this._keys[i] = key;
            this._values[i] = value;
            return null;
        }
        if (this.garbage && this._size >= this._keys.length) {
            this.gc();
            i = ArrayExt.binarySearch$default((long[])this._keys, (long)key, (int)0, (int)this._size, (int)2, null);
        }
        if (this._size >= this._keys.length) {
            this.expandToCapacity(ArrayExtKt.idealIntArraySize(this._size + 1));
        }
        if (this._size - i != 0) {
            ArraysKt.copyInto((long[])this._keys, (long[])this._keys, (int)(i + 1), (int)i, (int)this._size);
            ArraysKt.copyInto((Object[])this._values, (Object[])this._values, (int)(i + 1), (int)i, (int)this._size);
        }
        this._keys[i] = key;
        this._values[i] = value;
        int n = this._size;
        this._size = n + 1;
        return null;
    }

    @Nullable
    public E remove(long key) {
        Object object;
        int n = ArrayExt.binarySearch$default((long[])this._keys, (long)key, (int)0, (int)this._size, (int)2, null);
        boolean bl = false;
        boolean bl2 = false;
        int i = n;
        boolean bl3 = false;
        if (i >= 0 && this._values[i] != DELETED) {
            Object object2 = this._values[i];
            if (!(object2 instanceof Object)) {
                object2 = null;
            }
            Object removedValue = object2;
            this._values[i] = DELETED;
            this.garbage = true;
            object = removedValue;
        } else {
            object = null;
        }
        return (E)object;
    }

    public final boolean remove(long key, E valueToRemove) {
        Object value;
        int i = ArrayExt.binarySearch$default((long[])this._keys, (long)key, (int)0, (int)this._size, (int)2, null);
        if (i >= 0 && (value = this._values[i]) != DELETED) {
            Object object = value;
            if (!(object instanceof Object)) {
                object = null;
            }
            if (Intrinsics.areEqual((Object)object, valueToRemove)) {
                this._values[i] = DELETED;
                this.garbage = true;
                return true;
            }
        }
        return false;
    }

    @Override
    public void putAll(@NotNull Map<? extends Long, ? extends E> from) {
        Intrinsics.checkParameterIsNotNull(from, (String)"from");
        Map<Long, E> map = from;
        boolean bl = false;
        for (Map.Entry<Long, E> item : map.entrySet()) {
            this.put(((Number)item.getKey()).longValue(), item.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void clear() {
        int n = 0;
        int n2 = this._size;
        while (n < n2) {
            void i;
            this._values[i] = null;
            ++i;
        }
        this._size = 0;
        this.garbage = false;
    }

    public final void removeAt(int index) {
        int n = index;
        if (0 <= n && this._size > n && this._values[index] != DELETED) {
            this._values[index] = DELETED;
            this.garbage = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void removeAtRange(int index, int size) {
        int n = index;
        if (0 <= n && this._size > n && size > 0) {
            int n2 = this._size;
            int n3 = index + size;
            boolean bl = false;
            int end = Math.min(n2, n3);
            n2 = index;
            n3 = end;
            while (n2 < n3) {
                void i;
                this.removeAt((int)i);
                ++i;
            }
        }
    }

    @Nullable
    public final Long keyAt(int index) {
        int n = index;
        return 0 <= n && this.size() > n ? Long.valueOf(this._keys[index]) : null;
    }

    @Nullable
    public final E valueAt(int index) {
        Object object;
        int n = index;
        if (0 <= n && this.size() > n) {
            object = this._values[index];
            if (!(object instanceof Object)) {
                object = null;
            }
        } else {
            object = null;
        }
        return (E)object;
    }

    public final boolean setKeyAt(int index, long key) {
        boolean bl;
        int n = index;
        if (0 <= n && this.size() > n) {
            this._keys[index] = key;
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final int indexOfKey(long key) {
        if (this.garbage) {
            this.gc();
        }
        return ArrayExt.binarySearch$default((long[])this._keys, (long)key, (int)0, (int)this._size, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final int indexOfSameValue(E value) {
        if (this.garbage) {
            this.gc();
        }
        int n = 0;
        int n2 = this._size;
        while (n < n2) {
            void i;
            if (this._values[i] == value) {
                return (int)i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public final int indexOfEqualValue(E value) {
        if (this.garbage) {
            this.gc();
        }
        if (value == null) {
            int n = 0;
            int n2 = this._size;
            while (n < n2) {
                void i;
                if (this._values[i] == null) {
                    return (int)i;
                }
                ++i;
            }
        } else {
            int n = this._size;
            for (int i = 0; i < n; ++i) {
                if (!Intrinsics.areEqual(value, (Object)this._values[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public final int ensureCapacity(int capacity) {
        if (this.garbage && this._size >= this._keys.length) {
            this.gc();
        }
        if (this._keys.length < capacity) {
            return this.expandToCapacity(capacity);
        }
        return -1;
    }

    private final int expandToCapacity(int capacity) {
        long[] newKeys = new long[capacity];
        Object[] newValues = new Object[capacity];
        ArraysKt.copyInto$default((long[])this._keys, (long[])newKeys, (int)0, (int)0, (int)0, (int)14, null);
        ArraysKt.copyInto$default((Object[])this._values, (Object[])newValues, (int)0, (int)0, (int)0, (int)14, null);
        this._keys = newKeys;
        this._values = newValues;
        return this._keys.length;
    }

    public final void append(long key, E value) {
        if (this._size != 0 && key <= this._keys[this._size - 1]) {
            this.put(key, value);
            return;
        }
        if (this.garbage && this._size >= this._keys.length) {
            this.gc();
        }
        if (this._size >= this._keys.length) {
            this.expandToCapacity(ArrayExtKt.idealIntArraySize(this._size + 1));
        }
        this._keys[this._size] = key;
        this._values[this._size] = value;
        int n = this._size;
        this._size = n + 1;
    }

    /*
     * WARNING - void declaration
     */
    private final void gc() {
        int o = 0;
        int n = 0;
        int n2 = this._size;
        while (n < n2) {
            void i;
            Object value = this._values[i];
            if (value != DELETED) {
                if (i != o) {
                    this._keys[o] = this._keys[i];
                    this._values[o] = value;
                    this._values[i] = null;
                }
                ++o;
            }
            ++i;
        }
        this.garbage = false;
        this._size = o;
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<Long, E>> iterator() {
        if (this.garbage) {
            this.gc();
        }
        return new Iterator<Map.Entry<? extends Long, ? extends E>>(this){
            private int i;
            final /* synthetic */ LongSparseArray this$0;

            public final int getI() {
                return this.i;
            }

            public final void setI(int n) {
                this.i = n;
            }

            public boolean hasNext() {
                return this.i < LongSparseArray.access$get_size$p(this.this$0);
            }

            @NotNull
            public Map.Entry<Long, E> next() {
                Entry<Object> entry = new Entry<Object>(LongSparseArray.access$get_keys$p(this.this$0)[this.i], LongSparseArray.access$get_values$p(this.this$0)[this.i]);
                int n = this.i;
                this.i = n + 1;
                return entry;
            }

            public void remove() {
                int pos = this.i - 1;
                this.this$0.removeAt(pos);
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    @NotNull
    public final Iterator<Long> getKeysIterator() {
        if (this.garbage) {
            this.gc();
        }
        return new Iterator<Long>(this){
            private int i;
            final /* synthetic */ LongSparseArray this$0;

            public final int getI() {
                return this.i;
            }

            public final void setI(int n) {
                this.i = n;
            }

            public boolean hasNext() {
                return this.i < LongSparseArray.access$get_size$p(this.this$0);
            }

            @NotNull
            public Long next() {
                long key = LongSparseArray.access$get_keys$p(this.this$0)[this.i];
                int n = this.i;
                this.i = n + 1;
                return key;
            }
            {
                this.this$0 = $outer;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    @NotNull
    public final Iterator<E> getValuesIterator() {
        if (this.garbage) {
            this.gc();
        }
        return new Iterator<E>(this){
            private int i;
            final /* synthetic */ LongSparseArray this$0;

            public final int getI() {
                return this.i;
            }

            public final void setI(int n) {
                this.i = n;
            }

            public boolean hasNext() {
                return this.i < LongSparseArray.access$get_size$p(this.this$0);
            }

            public E next() {
                Object value = LongSparseArray.access$get_values$p(this.this$0)[this.i];
                int n = this.i;
                this.i = n + 1;
                return (E)value;
            }
            {
                this.this$0 = $outer;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    public LongSparseArray(int initialCapacity) {
        this.initialCapacity = initialCapacity;
        if (this.initialCapacity == 0) {
            this._keys = new long[0];
            this._values = new Object[0];
        } else {
            this.initialCapacity = ArrayExtKt.idealIntArraySize(this.initialCapacity);
            this._keys = new long[this.initialCapacity];
            this._values = new Object[this.initialCapacity];
        }
        this._size = 0;
    }

    public /* synthetic */ LongSparseArray(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        this(n);
    }

    public LongSparseArray() {
        this(0, 1, null);
    }

    static {
        Companion = new Companion(null);
        DELETED = new Object();
    }

    public static final /* synthetic */ int access$get_size$p(LongSparseArray $this) {
        return $this._size;
    }

    public static final /* synthetic */ void access$set_size$p(LongSparseArray $this, int n) {
        $this._size = n;
    }

    public static final /* synthetic */ long[] access$get_keys$p(LongSparseArray $this) {
        return $this._keys;
    }

    public static final /* synthetic */ void access$set_keys$p(LongSparseArray $this, long[] lArray) {
        $this._keys = lArray;
    }

    public static final /* synthetic */ Object[] access$get_values$p(LongSparseArray $this) {
        return $this._values;
    }

    public static final /* synthetic */ void access$set_values$p(LongSparseArray $this, Object[] objectArray) {
        $this._values = objectArray;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010&\n\u0002\u0010\t\n\u0002\b\t\u0018\u0000*\u0004\b\u0001\u0010\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\u00010\u0002B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0005\u001a\u00028\u0001X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lcom/olekdia/sparsearray/LongSparseArray$Entry;", "E", "", "", "key", "value", "(JLjava/lang/Object;)V", "getKey", "()Ljava/lang/Long;", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "multiplatform-sparse-array"})
    public static final class Entry<E>
    implements Map.Entry<Long, E>,
    KMappedMarker {
        private final long key;
        private final E value;

        @Override
        @NotNull
        public Long getKey() {
            return this.key;
        }

        @Override
        public E getValue() {
            return this.value;
        }

        public Entry(long key, E value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public E setValue(E e) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010'\n\u0002\u0010\t\n\u0002\b\r\u0018\u0000*\u0004\b\u0001\u0010\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\u00010\u0002B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u000b\u001a\u00028\u00012\u0006\u0010\u000e\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\u0005\u001a\u00028\u0001X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lcom/olekdia/sparsearray/LongSparseArray$MutableEntry;", "E", "", "", "key", "value", "(JLjava/lang/Object;)V", "getKey", "()Ljava/lang/Long;", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "newValue", "(Ljava/lang/Object;)Ljava/lang/Object;", "multiplatform-sparse-array"})
    public static final class MutableEntry<E>
    implements Map.Entry<Long, E>,
    KMutableMap.Entry {
        private final long key;
        private E value;

        @Override
        public E setValue(E newValue) {
            E oldValue = this.getValue();
            this.setValue(newValue);
            return oldValue;
        }

        @Override
        @NotNull
        public Long getKey() {
            return this.key;
        }

        @Override
        public E getValue() {
            return this.value;
        }

        @Override
        public void setValue(E e) {
            this.value = e;
        }

        public MutableEntry(long key, E value) {
            this.key = key;
            this.value = value;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0004"}, d2={"Lcom/olekdia/sparsearray/LongSparseArray$Companion;", "", "()V", "DELETED", "multiplatform-sparse-array"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

