/*
 * Decompiled with CFR 0.152.
 */
package com.olekdia.sparsearray;

import com.olekdia.common.extensions.ArrayExt;
import com.olekdia.sparsearray.ArrayExtKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.jvm.internal.markers.KMutableMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0010\u001c\n\u0002\u0010&\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\u0005\n\u0002\u0010(\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010)\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\t\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00040\u0003:\u0002BCB\u000f\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\u0002J\b\u0010$\u001a\u00020!H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010\"\u001a\u00020\u0002H\u0016J\u0010\u0010'\u001a\u00020&2\u0006\u0010#\u001a\u00020\u0002H\u0016J\u000e\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u0006J\u0010\u0010*\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u0006H\u0002J\u0018\u0010+\u001a\u0004\u0018\u00010\u00022\u0006\u0010\"\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010,J\u0019\u0010+\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u00022\u0006\u0010-\u001a\u00020\u0002H\u0086\u0002J\u001b\u0010.\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u00022\u0006\u0010-\u001a\u00020\u0002\u00a2\u0006\u0002\u0010/J\u000e\u00100\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u0002J\u000e\u00101\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0002J\b\u00102\u001a\u00020&H\u0016J\u001b\u00103\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u000404H\u0096\u0002J\u0015\u00105\u001a\u0004\u0018\u00010\u00022\u0006\u00106\u001a\u00020\u0006\u00a2\u0006\u0002\u00107J\u001f\u00108\u001a\u0004\u0018\u00010\u00022\u0006\u0010\"\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010/J\u001e\u00109\u001a\u00020!2\u0014\u0010:\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020;H\u0016J\u0017\u0010<\u001a\u0004\u0018\u00010\u00022\u0006\u0010\"\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010,J\u0016\u0010<\u001a\u00020&2\u0006\u0010\"\u001a\u00020\u00022\u0006\u0010=\u001a\u00020\u0002J\u000e\u0010>\u001a\u00020!2\u0006\u00106\u001a\u00020\u0006J\u0016\u0010?\u001a\u00020!2\u0006\u00106\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006J\u0016\u0010@\u001a\u00020&2\u0006\u00106\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u0002J\u0015\u0010A\u001a\u0004\u0018\u00010\u00022\u0006\u00106\u001a\u00020\u0006\u00a2\u0006\u0002\u00107R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u000e0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0016\u00a8\u0006D"}, d2={"Lcom/olekdia/sparsearray/LongToLongSparseArray;", "", "", "", "", "initialCapacity", "", "(I)V", "_keys", "", "_size", "_values", "entries", "", "", "getEntries", "()Ljava/util/Set;", "keys", "getKeys", "keysIterator", "", "getKeysIterator", "()Ljava/util/Iterator;", "size", "getSize", "()I", "values", "", "getValues", "()Ljava/util/List;", "valuesIterator", "getValuesIterator", "append", "", "key", "value", "clear", "containsKey", "", "containsValue", "ensureCapacity", "capacity", "expandToCapacity", "get", "(J)Ljava/lang/Long;", "defaultValue", "getOrDefault", "(JJ)Ljava/lang/Long;", "indexOfKey", "indexOfValue", "isEmpty", "iterator", "", "keyAt", "index", "(I)Ljava/lang/Long;", "put", "putAll", "from", "", "remove", "valueToRemove", "removeAt", "removeAtRange", "setKeyAt", "valueAt", "Entry", "MutableEntry", "multiplatform-sparse-array"})
public final class LongToLongSparseArray
implements Map<Long, Long>,
Iterable<Map.Entry<? extends Long, ? extends Long>>,
KMutableMap,
KMappedMarker {
    private long[] _keys;
    private long[] _values;
    private int _size;
    private int initialCapacity;

    public int getSize() {
        return this._size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(long key) {
        return this.indexOfKey(key) >= 0;
    }

    public boolean containsValue(long value) {
        return this.indexOfValue(value) >= 0;
    }

    @Nullable
    public Long get(long key) {
        int n = ArrayExt.binarySearch$default((long[])this._keys, (long)key, (int)0, (int)this._size, (int)2, null);
        boolean bl = false;
        boolean bl2 = false;
        int i = n;
        boolean bl3 = false;
        return i < 0 ? null : Long.valueOf(this._values[i]);
    }

    public final long get(long key, long defaultValue) {
        return ((Number)this.getOrDefault((Object)key, (Object)defaultValue)).longValue();
    }

    @NotNull
    public final Long getOrDefault(long key, long defaultValue) {
        int n = ArrayExt.binarySearch$default((long[])this._keys, (long)key, (int)0, (int)this._size, (int)2, null);
        boolean bl = false;
        boolean bl2 = false;
        int i = n;
        boolean bl3 = false;
        return i < 0 ? defaultValue : this._values[i];
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<Long> getKeys() {
        LinkedHashSet<Long> linkedHashSet = new LinkedHashSet<Long>(this._size);
        boolean bl = false;
        boolean bl2 = false;
        LinkedHashSet<Long> it = linkedHashSet;
        boolean bl3 = false;
        int n = 0;
        int n2 = this._size;
        while (n < n2) {
            void i;
            it.add(this._keys[i]);
            ++i;
        }
        return linkedHashSet;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Long> getValues() {
        int n = this._size;
        boolean bl = false;
        ArrayList<Long> arrayList = new ArrayList<Long>(n);
        boolean bl2 = false;
        int n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            void it;
            int n4 = n2++;
            boolean bl3 = false;
            int n5 = n4;
            ArrayList<Long> arrayList2 = arrayList;
            boolean bl4 = false;
            Long l = this._values[it];
            arrayList2.add(l);
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<Map.Entry<Long, Long>> getEntries() {
        LinkedHashSet<MutableEntry> linkedHashSet = new LinkedHashSet<MutableEntry>(this._size);
        boolean bl = false;
        boolean bl2 = false;
        LinkedHashSet<MutableEntry> it = linkedHashSet;
        boolean bl3 = false;
        int n = 0;
        int n2 = this._size;
        while (n < n2) {
            void i;
            it.add(new MutableEntry(this._keys[i], this._values[i]));
            ++i;
        }
        return linkedHashSet;
    }

    @Override
    @Nullable
    public Long put(long key, long value) {
        int i = ArrayExt.binarySearch$default((long[])this._keys, (long)key, (int)0, (int)this._size, (int)2, null);
        if (i >= 0) {
            long oldValue = this._values[i];
            this._values[i] = value;
            return oldValue;
        }
        i ^= 0xFFFFFFFF;
        if (this._size >= this._keys.length) {
            this.expandToCapacity(ArrayExtKt.idealIntArraySize(this._size + 1));
        }
        if (this._size - i != 0) {
            ArraysKt.copyInto((long[])this._keys, (long[])this._keys, (int)(i + 1), (int)i, (int)this._size);
            ArraysKt.copyInto((long[])this._values, (long[])this._values, (int)(i + 1), (int)i, (int)this._size);
        }
        this._keys[i] = key;
        this._values[i] = value;
        int n = this._size;
        this._size = n + 1;
        return null;
    }

    @Nullable
    public Long remove(long key) {
        Long l;
        int n = ArrayExt.binarySearch$default((long[])this._keys, (long)key, (int)0, (int)this._size, (int)2, null);
        boolean bl = false;
        boolean bl2 = false;
        int i = n;
        boolean bl3 = false;
        if (i >= 0) {
            long removedValue = this._values[i];
            ArraysKt.copyInto((long[])this._keys, (long[])this._keys, (int)i, (int)(i + 1), (int)this._size);
            ArraysKt.copyInto((long[])this._values, (long[])this._values, (int)i, (int)(i + 1), (int)this._size);
            int n2 = this._size;
            this._size = n2 + -1;
            l = removedValue;
        } else {
            l = null;
        }
        return l;
    }

    public final boolean remove(long key, long valueToRemove) {
        boolean bl;
        int n = ArrayExt.binarySearch$default((long[])this._keys, (long)key, (int)0, (int)this._size, (int)2, null);
        boolean bl2 = false;
        boolean bl3 = false;
        int i = n;
        boolean bl4 = false;
        if (i >= 0 && this._values[i] == valueToRemove) {
            ArraysKt.copyInto((long[])this._keys, (long[])this._keys, (int)i, (int)(i + 1), (int)this._size);
            ArraysKt.copyInto((long[])this._values, (long[])this._values, (int)i, (int)(i + 1), (int)this._size);
            int n2 = this._size;
            this._size = n2 + -1;
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public void putAll(@NotNull Map<? extends Long, ? extends Long> from) {
        Intrinsics.checkNotNullParameter(from, (String)"from");
        Map<? extends Long, ? extends Long> map = from;
        boolean bl = false;
        for (Map.Entry<? extends Long, ? extends Long> item : map.entrySet()) {
            this.put(((Number)item.getKey()).longValue(), ((Number)item.getValue()).longValue());
        }
    }

    @Override
    public void clear() {
        this._size = 0;
    }

    public final void removeAt(int index) {
        int n = index;
        if (0 <= n && this._size > n) {
            ArraysKt.copyInto((long[])this._keys, (long[])this._keys, (int)index, (int)(index + 1), (int)this._size);
            ArraysKt.copyInto((long[])this._values, (long[])this._values, (int)index, (int)(index + 1), (int)this._size);
            n = this._size;
            this._size = n + -1;
        }
    }

    public final void removeAtRange(int index, int size) {
        int n = index;
        if (0 <= n && this._size > n && size > 0) {
            int n2 = this._size;
            int n3 = index + size;
            boolean bl = false;
            int end = Math.min(n2, n3);
            ArraysKt.copyInto((long[])this._keys, (long[])this._keys, (int)index, (int)end, (int)this._size);
            ArraysKt.copyInto((long[])this._values, (long[])this._values, (int)index, (int)end, (int)this._size);
            this._size -= end - index;
        }
    }

    @Nullable
    public final Long keyAt(int index) {
        int n = index;
        return 0 <= n && this._size > n ? Long.valueOf(this._keys[index]) : null;
    }

    @Nullable
    public final Long valueAt(int index) {
        int n = index;
        return 0 <= n && this._size > n ? Long.valueOf(this._values[index]) : null;
    }

    public final boolean setKeyAt(int index, long key) {
        boolean bl;
        int n = index;
        if (0 <= n && this._size > n) {
            this._keys[index] = key;
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final int indexOfKey(long key) {
        return ArrayExt.binarySearch$default((long[])this._keys, (long)key, (int)0, (int)this._size, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final int indexOfValue(long value) {
        int n = 0;
        int n2 = this._size;
        while (n < n2) {
            void i;
            if (this._values[i] == value) {
                return (int)i;
            }
            ++i;
        }
        return -1;
    }

    public final int ensureCapacity(int capacity) {
        if (this._keys.length < capacity) {
            return this.expandToCapacity(capacity);
        }
        return -1;
    }

    private final int expandToCapacity(int capacity) {
        long[] newKeys = new long[capacity];
        long[] newValues = new long[capacity];
        ArraysKt.copyInto$default((long[])this._keys, (long[])newKeys, (int)0, (int)0, (int)0, (int)14, null);
        ArraysKt.copyInto$default((long[])this._values, (long[])newValues, (int)0, (int)0, (int)0, (int)14, null);
        this._keys = newKeys;
        this._values = newValues;
        return this._keys.length;
    }

    public final void append(long key, long value) {
        if (this._size != 0 && key <= this._keys[this._size - 1]) {
            this.put(key, value);
            return;
        }
        if (this._size >= this._keys.length) {
            this.expandToCapacity(ArrayExtKt.idealIntArraySize(this._size + 1));
        }
        this._keys[this._size] = key;
        this._values[this._size] = value;
        int n = this._size;
        this._size = n + 1;
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<Long, Long>> iterator() {
        return new Iterator<Map.Entry<? extends Long, ? extends Long>>(this){
            private int i;
            final /* synthetic */ LongToLongSparseArray this$0;

            public final int getI() {
                return this.i;
            }

            public final void setI(int n) {
                this.i = n;
            }

            public boolean hasNext() {
                return this.i < LongToLongSparseArray.access$get_size$p(this.this$0);
            }

            @NotNull
            public Map.Entry<Long, Long> next() {
                Entry entry = new Entry(LongToLongSparseArray.access$get_keys$p(this.this$0)[this.i], LongToLongSparseArray.access$get_values$p(this.this$0)[this.i]);
                int n = this.i;
                this.i = n + 1;
                return entry;
            }

            public void remove() {
                int n = this.i;
                this.i = n + -1;
                this.this$0.removeAt(this.i);
            }
            {
                this.this$0 = this$0;
            }
        };
    }

    @NotNull
    public final Iterator<Long> getKeysIterator() {
        return new Iterator<Long>(this){
            private int i;
            final /* synthetic */ LongToLongSparseArray this$0;

            public final int getI() {
                return this.i;
            }

            public final void setI(int n) {
                this.i = n;
            }

            public boolean hasNext() {
                return this.i < LongToLongSparseArray.access$get_size$p(this.this$0);
            }

            @NotNull
            public Long next() {
                long key = LongToLongSparseArray.access$get_keys$p(this.this$0)[this.i];
                int n = this.i;
                this.i = n + 1;
                return key;
            }
            {
                this.this$0 = this$0;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    @NotNull
    public final Iterator<Long> getValuesIterator() {
        return new Iterator<Long>(this){
            private int i;
            final /* synthetic */ LongToLongSparseArray this$0;

            public final int getI() {
                return this.i;
            }

            public final void setI(int n) {
                this.i = n;
            }

            public boolean hasNext() {
                return this.i < LongToLongSparseArray.access$get_size$p(this.this$0);
            }

            @NotNull
            public Long next() {
                long value = LongToLongSparseArray.access$get_values$p(this.this$0)[this.i];
                int n = this.i;
                this.i = n + 1;
                return value;
            }
            {
                this.this$0 = this$0;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    public LongToLongSparseArray(int initialCapacity) {
        this.initialCapacity = initialCapacity;
        if (this.initialCapacity == 0) {
            this._keys = new long[0];
            this._values = new long[0];
        } else {
            this.initialCapacity = ArrayExtKt.idealIntArraySize(this.initialCapacity);
            this._keys = new long[this.initialCapacity];
            this._values = new long[this.initialCapacity];
        }
        this._size = 0;
    }

    public /* synthetic */ LongToLongSparseArray(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        this(n);
    }

    public LongToLongSparseArray() {
        this(0, 1, null);
    }

    public static final /* synthetic */ int access$get_size$p(LongToLongSparseArray $this) {
        return $this._size;
    }

    public static final /* synthetic */ void access$set_size$p(LongToLongSparseArray $this, int n) {
        $this._size = n;
    }

    public static final /* synthetic */ long[] access$get_keys$p(LongToLongSparseArray $this) {
        return $this._keys;
    }

    public static final /* synthetic */ void access$set_keys$p(LongToLongSparseArray $this, long[] lArray) {
        $this._keys = lArray;
    }

    public static final /* synthetic */ long[] access$get_values$p(LongToLongSparseArray $this) {
        return $this._values;
    }

    public static final /* synthetic */ void access$set_values$p(LongToLongSparseArray $this, long[] lArray) {
        $this._values = lArray;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010&\n\u0002\u0010\t\n\u0002\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0004\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"Lcom/olekdia/sparsearray/LongToLongSparseArray$Entry;", "", "", "key", "value", "(JJ)V", "getKey", "()Ljava/lang/Long;", "getValue", "multiplatform-sparse-array"})
    public static final class Entry
    implements Map.Entry<Long, Long>,
    KMappedMarker {
        private final long key;
        private final long value;

        @Override
        @NotNull
        public Long getKey() {
            return this.key;
        }

        @Override
        @NotNull
        public Long getValue() {
            return this.value;
        }

        public Entry(long key, long value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public Long setValue(long l) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public /* synthetic */ Object setValue(Object object) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010'\n\u0002\u0010\t\n\u0002\b\u000b\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\t\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\fR\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\u0004\u001a\u00020\u0002X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0007\"\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/olekdia/sparsearray/LongToLongSparseArray$MutableEntry;", "", "", "key", "value", "(JJ)V", "getKey", "()Ljava/lang/Long;", "getValue", "setValue", "(J)V", "newValue", "(J)Ljava/lang/Long;", "multiplatform-sparse-array"})
    public static final class MutableEntry
    implements Map.Entry<Long, Long>,
    KMutableMap.Entry {
        private final long key;
        private long value;

        @Override
        @NotNull
        public Long setValue(long newValue) {
            long oldValue = this.getValue();
            this.setValue(newValue);
            return oldValue;
        }

        @Override
        @NotNull
        public Long getKey() {
            return this.key;
        }

        @Override
        @NotNull
        public Long getValue() {
            return this.value;
        }

        @Override
        public void setValue(long l) {
            this.value = l;
        }

        public MutableEntry(long key, long value) {
            this.key = key;
            this.value = value;
        }
    }
}

