/*
 * Decompiled with CFR 0.152.
 */
package com.olekdia.sparsearray;

import com.olekdia.common.extensions.ArrayExt;
import com.olekdia.sparsearray.ArrayExtKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.jvm.internal.markers.KMutableMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010\u001c\n\u0002\u0010&\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\u0005\n\u0002\u0010(\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010)\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\t\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00040\u0003:\u0002@AB\u000f\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u0002J\b\u0010#\u001a\u00020 H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010!\u001a\u00020\u0002H\u0016J\u0010\u0010&\u001a\u00020%2\u0006\u0010\"\u001a\u00020\u0002H\u0016J\u000e\u0010'\u001a\u00020\u00022\u0006\u0010(\u001a\u00020\u0002J\u0010\u0010)\u001a\u00020\u00022\u0006\u0010(\u001a\u00020\u0002H\u0002J\u0018\u0010*\u001a\u0004\u0018\u00010\u00022\u0006\u0010!\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010+J\u0019\u0010*\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u00022\u0006\u0010,\u001a\u00020\u0002H\u0086\u0002J\u001b\u0010-\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u00022\u0006\u0010,\u001a\u00020\u0002\u00a2\u0006\u0002\u0010.J\u000e\u0010/\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u0002J\u000e\u00100\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u0002J\b\u00101\u001a\u00020%H\u0016J\u001b\u00102\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u000403H\u0096\u0002J\u0015\u00104\u001a\u0004\u0018\u00010\u00022\u0006\u00105\u001a\u00020\u0002\u00a2\u0006\u0002\u0010+J\u001f\u00106\u001a\u0004\u0018\u00010\u00022\u0006\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010.J\u001e\u00107\u001a\u00020 2\u0014\u00108\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000209H\u0016J\u0017\u0010:\u001a\u0004\u0018\u00010\u00022\u0006\u0010!\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010+J\u0016\u0010:\u001a\u00020%2\u0006\u0010!\u001a\u00020\u00022\u0006\u0010;\u001a\u00020\u0002J\u000e\u0010<\u001a\u00020 2\u0006\u00105\u001a\u00020\u0002J\u0016\u0010=\u001a\u00020 2\u0006\u00105\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0002J\u0016\u0010>\u001a\u00020%2\u0006\u00105\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u0002J\u0015\u0010?\u001a\u0004\u0018\u00010\u00022\u0006\u00105\u001a\u00020\u0002\u00a2\u0006\u0002\u0010+R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0015\u00a8\u0006B"}, d2={"Lcom/olekdia/sparsearray/IntToIntSparseArray;", "", "", "", "", "initialCapacity", "(I)V", "_keys", "", "_size", "_values", "entries", "", "", "getEntries", "()Ljava/util/Set;", "keys", "getKeys", "keysIterator", "", "getKeysIterator", "()Ljava/util/Iterator;", "size", "getSize", "()I", "values", "", "getValues", "()Ljava/util/List;", "valuesIterator", "getValuesIterator", "append", "", "key", "value", "clear", "containsKey", "", "containsValue", "ensureCapacity", "capacity", "expandToCapacity", "get", "(I)Ljava/lang/Integer;", "defaultValue", "getOrDefault", "(II)Ljava/lang/Integer;", "indexOfKey", "indexOfValue", "isEmpty", "iterator", "", "keyAt", "index", "put", "putAll", "from", "", "remove", "valueToRemove", "removeAt", "removeAtRange", "setKeyAt", "valueAt", "Entry", "MutableEntry", "multiplatform-sparse-array"})
public final class IntToIntSparseArray
implements Map<Integer, Integer>,
Iterable<Map.Entry<? extends Integer, ? extends Integer>>,
KMutableMap,
KMappedMarker {
    private int initialCapacity;
    @NotNull
    private int[] _keys;
    @NotNull
    private int[] _values;
    private int _size;

    public IntToIntSparseArray(int initialCapacity) {
        this.initialCapacity = initialCapacity;
        if (this.initialCapacity == 0) {
            this._keys = new int[0];
            this._values = new int[0];
        } else {
            this.initialCapacity = ArrayExtKt.idealIntArraySize(this.initialCapacity);
            this._keys = new int[this.initialCapacity];
            this._values = new int[this.initialCapacity];
        }
        this._size = 0;
    }

    public /* synthetic */ IntToIntSparseArray(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        this(n);
    }

    public int getSize() {
        return this._size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(int key) {
        return this.indexOfKey(key) >= 0;
    }

    public boolean containsValue(int value) {
        return this.indexOfValue(value) >= 0;
    }

    @Nullable
    public Integer get(int key) {
        int i = ArrayExt.binarySearch$default((int[])this._keys, (int)key, (int)0, (int)this._size, (int)2, null);
        boolean bl = false;
        return i < 0 ? null : Integer.valueOf(this._values[i]);
    }

    public final int get(int key, int defaultValue) {
        return ((Number)this.getOrDefault((Object)key, (Object)defaultValue)).intValue();
    }

    @NotNull
    public final Integer getOrDefault(int key, int defaultValue) {
        int i = ArrayExt.binarySearch$default((int[])this._keys, (int)key, (int)0, (int)this._size, (int)2, null);
        boolean bl = false;
        return i < 0 ? defaultValue : this._values[i];
    }

    @NotNull
    public Set<Integer> getKeys() {
        LinkedHashSet<Integer> linkedHashSet;
        LinkedHashSet<Integer> it = linkedHashSet = new LinkedHashSet<Integer>(this._size);
        boolean bl = false;
        int n = this._size;
        for (int i = 0; i < n; ++i) {
            it.add(this._keys[i]);
        }
        return linkedHashSet;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Integer> getValues() {
        int n = this._size;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
        int n2 = 0;
        while (n2 < n) {
            void it;
            int n3;
            int n4 = n3 = n2++;
            ArrayList<Integer> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(this._values[it]);
        }
        return arrayList;
    }

    @NotNull
    public Set<Map.Entry<Integer, Integer>> getEntries() {
        LinkedHashSet<MutableEntry> linkedHashSet;
        LinkedHashSet<MutableEntry> it = linkedHashSet = new LinkedHashSet<MutableEntry>(this._size);
        boolean bl = false;
        int n = this._size;
        for (int i = 0; i < n; ++i) {
            it.add(new MutableEntry(this._keys[i], this._values[i]));
        }
        return linkedHashSet;
    }

    @Override
    @Nullable
    public Integer put(int key, int value) {
        int i = ArrayExt.binarySearch$default((int[])this._keys, (int)key, (int)0, (int)this._size, (int)2, null);
        if (i >= 0) {
            int oldValue = this._values[i];
            this._values[i] = value;
            return oldValue;
        }
        i ^= 0xFFFFFFFF;
        if (this._size >= this._keys.length) {
            this.expandToCapacity(ArrayExtKt.idealIntArraySize(this._size + 1));
        }
        if (this._size - i != 0) {
            ArraysKt.copyInto((int[])this._keys, (int[])this._keys, (int)(i + 1), (int)i, (int)this._size);
            ArraysKt.copyInto((int[])this._values, (int[])this._values, (int)(i + 1), (int)i, (int)this._size);
        }
        this._keys[i] = key;
        this._values[i] = value;
        int n = this._size;
        this._size = n + 1;
        return null;
    }

    @Nullable
    public Integer remove(int key) {
        Integer n;
        int i = ArrayExt.binarySearch$default((int[])this._keys, (int)key, (int)0, (int)this._size, (int)2, null);
        boolean bl = false;
        if (i >= 0) {
            int removedValue = this._values[i];
            ArraysKt.copyInto((int[])this._keys, (int[])this._keys, (int)i, (int)(i + 1), (int)this._size);
            ArraysKt.copyInto((int[])this._values, (int[])this._values, (int)i, (int)(i + 1), (int)this._size);
            int n2 = this._size;
            this._size = n2 + -1;
            n = removedValue;
        } else {
            n = null;
        }
        return n;
    }

    public final boolean remove(int key, int valueToRemove) {
        boolean bl;
        int i = ArrayExt.binarySearch$default((int[])this._keys, (int)key, (int)0, (int)this._size, (int)2, null);
        boolean bl2 = false;
        if (i >= 0 && this._values[i] == valueToRemove) {
            ArraysKt.copyInto((int[])this._keys, (int[])this._keys, (int)i, (int)(i + 1), (int)this._size);
            ArraysKt.copyInto((int[])this._values, (int[])this._values, (int)i, (int)(i + 1), (int)this._size);
            int n = this._size;
            this._size = n + -1;
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public void putAll(@NotNull Map<? extends Integer, ? extends Integer> from) {
        Intrinsics.checkNotNullParameter(from, (String)"from");
        for (Map.Entry<? extends Integer, ? extends Integer> item : from.entrySet()) {
            this.put(((Number)item.getKey()).intValue(), ((Number)item.getValue()).intValue());
        }
    }

    @Override
    public void clear() {
        this._size = 0;
    }

    public final void removeAt(int index) {
        boolean bl = 0 <= index ? index < this._size : false;
        if (bl) {
            ArraysKt.copyInto((int[])this._keys, (int[])this._keys, (int)index, (int)(index + 1), (int)this._size);
            ArraysKt.copyInto((int[])this._values, (int[])this._values, (int)index, (int)(index + 1), (int)this._size);
            int n = this._size;
            this._size = n + -1;
        }
    }

    public final void removeAtRange(int index, int size) {
        boolean bl = 0 <= index ? index < this._size : false;
        if (bl && size > 0) {
            int end = Math.min(this._size, index + size);
            ArraysKt.copyInto((int[])this._keys, (int[])this._keys, (int)index, (int)end, (int)this._size);
            ArraysKt.copyInto((int[])this._values, (int[])this._values, (int)index, (int)end, (int)this._size);
            this._size -= end - index;
        }
    }

    @Nullable
    public final Integer keyAt(int index) {
        return (0 <= index ? index < this._size : false) ? Integer.valueOf(this._keys[index]) : null;
    }

    @Nullable
    public final Integer valueAt(int index) {
        return (0 <= index ? index < this._size : false) ? Integer.valueOf(this._values[index]) : null;
    }

    public final boolean setKeyAt(int index, int key) {
        boolean bl;
        boolean bl2 = 0 <= index ? index < this._size : false;
        if (bl2) {
            this._keys[index] = key;
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final int indexOfKey(int key) {
        return ArrayExt.binarySearch$default((int[])this._keys, (int)key, (int)0, (int)this._size, (int)2, null);
    }

    public final int indexOfValue(int value) {
        int n = this._size;
        for (int i = 0; i < n; ++i) {
            if (this._values[i] != value) continue;
            return i;
        }
        return -1;
    }

    public final int ensureCapacity(int capacity) {
        if (this._keys.length < capacity) {
            return this.expandToCapacity(capacity);
        }
        return -1;
    }

    private final int expandToCapacity(int capacity) {
        int[] newKeys = new int[capacity];
        int[] newValues = new int[capacity];
        ArraysKt.copyInto$default((int[])this._keys, (int[])newKeys, (int)0, (int)0, (int)0, (int)14, null);
        ArraysKt.copyInto$default((int[])this._values, (int[])newValues, (int)0, (int)0, (int)0, (int)14, null);
        this._keys = newKeys;
        this._values = newValues;
        return this._keys.length;
    }

    public final void append(int key, int value) {
        if (this._size != 0 && key <= this._keys[this._size - 1]) {
            this.put(key, value);
            return;
        }
        if (this._size >= this._keys.length) {
            this.expandToCapacity(ArrayExtKt.idealIntArraySize(this._size + 1));
        }
        this._keys[this._size] = key;
        this._values[this._size] = value;
        int n = this._size;
        this._size = n + 1;
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<Integer, Integer>> iterator() {
        return new Iterator<Map.Entry<? extends Integer, ? extends Integer>>(this){
            private int i;
            final /* synthetic */ IntToIntSparseArray this$0;
            {
                this.this$0 = $receiver;
            }

            public final int getI() {
                return this.i;
            }

            public final void setI(int n) {
                this.i = n;
            }

            public boolean hasNext() {
                return this.i < IntToIntSparseArray.access$get_size$p(this.this$0);
            }

            @NotNull
            public Map.Entry<Integer, Integer> next() {
                Entry entry = new Entry(IntToIntSparseArray.access$get_keys$p(this.this$0)[this.i], IntToIntSparseArray.access$get_values$p(this.this$0)[this.i]);
                int n = this.i;
                this.i = n + 1;
                return entry;
            }

            public void remove() {
                int n = this.i;
                this.i = n + -1;
                this.this$0.removeAt(this.i);
            }
        };
    }

    @NotNull
    public final Iterator<Integer> getKeysIterator() {
        return new Iterator<Integer>(this){
            private int i;
            final /* synthetic */ IntToIntSparseArray this$0;
            {
                this.this$0 = $receiver;
            }

            public final int getI() {
                return this.i;
            }

            public final void setI(int n) {
                this.i = n;
            }

            public boolean hasNext() {
                return this.i < IntToIntSparseArray.access$get_size$p(this.this$0);
            }

            @NotNull
            public Integer next() {
                int key = IntToIntSparseArray.access$get_keys$p(this.this$0)[this.i];
                int n = this.i;
                this.i = n + 1;
                return key;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    @NotNull
    public final Iterator<Integer> getValuesIterator() {
        return new Iterator<Integer>(this){
            private int i;
            final /* synthetic */ IntToIntSparseArray this$0;
            {
                this.this$0 = $receiver;
            }

            public final int getI() {
                return this.i;
            }

            public final void setI(int n) {
                this.i = n;
            }

            public boolean hasNext() {
                return this.i < IntToIntSparseArray.access$get_size$p(this.this$0);
            }

            @NotNull
            public Integer next() {
                int value = IntToIntSparseArray.access$get_values$p(this.this$0)[this.i];
                int n = this.i;
                this.i = n + 1;
                return value;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    public IntToIntSparseArray() {
        this(0, 1, null);
    }

    public static final /* synthetic */ int access$get_size$p(IntToIntSparseArray $this) {
        return $this._size;
    }

    public static final /* synthetic */ int[] access$get_keys$p(IntToIntSparseArray $this) {
        return $this._keys;
    }

    public static final /* synthetic */ int[] access$get_values$p(IntToIntSparseArray $this) {
        return $this._values;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010&\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0004\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"Lcom/olekdia/sparsearray/IntToIntSparseArray$Entry;", "", "", "key", "value", "(II)V", "getKey", "()Ljava/lang/Integer;", "getValue", "multiplatform-sparse-array"})
    public static final class Entry
    implements Map.Entry<Integer, Integer>,
    KMappedMarker {
        private final int key;
        private final int value;

        public Entry(int key, int value) {
            this.key = key;
            this.value = value;
        }

        @Override
        @NotNull
        public Integer getKey() {
            return this.key;
        }

        @Override
        @NotNull
        public Integer getValue() {
            return this.value;
        }

        @Override
        public Integer setValue(int newValue) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010'\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\t\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\fR\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\u0004\u001a\u00020\u0002X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0007\"\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/olekdia/sparsearray/IntToIntSparseArray$MutableEntry;", "", "", "key", "value", "(II)V", "getKey", "()Ljava/lang/Integer;", "getValue", "setValue", "(I)V", "newValue", "(I)Ljava/lang/Integer;", "multiplatform-sparse-array"})
    public static final class MutableEntry
    implements Map.Entry<Integer, Integer>,
    KMutableMap.Entry {
        private final int key;
        private int value;

        public MutableEntry(int key, int value) {
            this.key = key;
            this.value = value;
        }

        @Override
        @NotNull
        public Integer getKey() {
            return this.key;
        }

        @Override
        @NotNull
        public Integer getValue() {
            return this.value;
        }

        @Override
        public void setValue(int n) {
            this.value = n;
        }

        @Override
        @NotNull
        public Integer setValue(int newValue) {
            int oldValue = this.getValue();
            this.setValue(newValue);
            return oldValue;
        }
    }
}

