/*
 * Decompiled with CFR 0.152.
 */
package com.openle.all.core.compiler;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class IndentedPrintWriter
extends PrintWriter {
    public IndentedPrintWriter(Writer out) {
        super(new IndentedWriter(out));
    }

    public IndentedPrintWriter(Writer out, boolean autoFlush) {
        super((Writer)new IndentedWriter(out), autoFlush);
    }

    public void indent() {
        ((IndentedWriter)this.out).indent();
    }

    public void dedent() {
        ((IndentedWriter)this.out).dedent();
    }

    public static IndentedPrintWriter of(PrintWriter writer) {
        if (writer instanceof IndentedPrintWriter) {
            return (IndentedPrintWriter)writer;
        }
        return new IndentedPrintWriter(writer);
    }

    private static class IndentedWriter
    extends Writer {
        private static final char[] INDENT = "\t".toCharArray();
        private final Writer out;
        private int level;
        private boolean mustIndent;

        public IndentedWriter(Writer out) {
            this.out = out;
        }

        public void indent() {
            ++this.level;
        }

        public void dedent() {
            --this.level;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            int last = off;
            for (int i = off; i < off + len; ++i) {
                if (this.mustIndent) {
                    this.mustIndent = false;
                    if (cbuf[i] != '\n') {
                        this.writeIndent();
                    }
                }
                if (cbuf[i] != '\n') continue;
                this.mustIndent = true;
                this.out.write(cbuf, last, i - last + 1);
                last = i + 1;
            }
            int remaining = off + len - last;
            if (remaining > 0) {
                this.out.write(cbuf, last, remaining);
            }
        }

        private void writeIndent() throws IOException {
            for (int i = 0; i < this.level; ++i) {
                this.out.write(INDENT);
            }
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }
}

