/*
 * Decompiled with CFR 0.152.
 */
package com.openle.all.core.compiler;

import com.openle.all.core.compiler.IndentedPrintWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;

public class JavaCodeGenerator {
    private Scope scope;
    private final JavaCodeGenerator parent;

    public JavaCodeGenerator() {
        this.scope = new Scope();
        this.parent = null;
    }

    private JavaCodeGenerator(JavaCodeGenerator parent) {
        this.scope = new Scope(parent.scope);
        this.parent = parent;
    }

    public String unique(String name) {
        return this.scope.unique(name);
    }

    public JavaCodeGenerator parent() {
        return this.parent;
    }

    public void generateImport(Class<?> aClass) {
        this.printf("import %s;%n", aClass.getName());
    }

    public JavaCodeGenerator declare(String type, String name) {
        return this.declare(type, name, null, new Object[0]);
    }

    public JavaCodeGenerator declareExisting(String name) {
        this.scope.declare(name);
        return this;
    }

    public JavaCodeGenerator declare(String type, String name, String initialValue, Object ... args) {
        this.scope.delayed.add(JavaCodeGenerator.declareInternal(this.scope, type, name, initialValue == null ? null : String.format(initialValue, args)));
        return this;
    }

    public JavaCodeGenerator declareOnScope(String type, String name, String initialValue) {
        this.scope.declare(type, name, initialValue);
        return this;
    }

    public static String declareOnScope(Scope scope, String type, String name, String initialValue) {
        scope.delayed.add(scope.lastDeclaration++, JavaCodeGenerator.declareInternal(scope, type, name, initialValue));
        return scope.variable(name);
    }

    public JavaCodeGenerator printfOnScope(String format, Object ... args) {
        this.scope.delayed.add(this.scope.lastDeclaration++, this.printfInternal(format, args));
        return this;
    }

    private Consumer<IndentedPrintWriter> printfInternal(String format, Object[] args) {
        return pw -> pw.printf(format, args);
    }

    private static Consumer<IndentedPrintWriter> declareInternal(Scope scope, String type, String name, String initialValue) {
        scope.declare(name);
        String resolvedVariable = scope.variable(name);
        return pw -> {
            if (initialValue == null) {
                pw.printf("%s %s;%n", type, resolvedVariable);
            } else {
                pw.printf("%s %s = %s;%n", type, resolvedVariable, initialValue);
            }
        };
    }

    public JavaCodeGenerator boundedLoop(String indexVar, String lowerBound, String upperBound, Consumer<JavaCodeGenerator> body) {
        this.enterScope();
        this.scope.declare(indexVar);
        this.printf("for (int %1$s = %2$s; %1$s < %3$s; %1$s++) {%n", this.variable(indexVar), lowerBound, upperBound);
        this.indent();
        body.accept(this);
        this.dedent();
        this.println("}");
        this.leaveScope();
        return this;
    }

    public JavaCodeGenerator loop(Consumer<JavaCodeGenerator> body) {
        this.println("for (;;) {");
        this.enterScope();
        this.indent();
        body.accept(this);
        this.dedent();
        this.println("}");
        this.leaveScope();
        return this;
    }

    public JavaCodeGenerator forEach(String type, String elementVar, String collection, Consumer<JavaCodeGenerator> body) {
        this.enterScope();
        this.scope.declare(elementVar);
        this.printf("for (%1$s %2$s : %3$s) {%n", type, this.variable(elementVar), collection);
        this.indent();
        body.accept(this);
        this.dedent();
        this.println("}");
        this.leaveScope();
        return this;
    }

    public void comment(String s, Object ... args) {
        this.println("//" + String.format(s, args).replaceAll("\n", "\n//"));
    }

    public String variable(String name) {
        return this.scope.variable(name);
    }

    public JavaCodeGenerator printQuoted(String s) {
        if (s == null) {
            this.print("null");
        } else {
            this.print(Character.valueOf('\"'));
            this.print(this.escape(s));
            this.print(Character.valueOf('\"'));
        }
        return this;
    }

    public JavaCodeGenerator ifThen(String condition, Consumer<JavaCodeGenerator> accept) {
        return this.ifThen(this.literal(condition), accept);
    }

    public JavaCodeGenerator ifThen(Consumer<JavaCodeGenerator> condition, Consumer<JavaCodeGenerator> accept) {
        return this.ifElse(condition, accept, null);
    }

    public JavaCodeGenerator ifElse(String condition, Consumer<JavaCodeGenerator> accept, Consumer<JavaCodeGenerator> reject) {
        return this.ifElse(this.literal(condition), accept, reject);
    }

    public Scope getScope() {
        return this.scope;
    }

    public JavaCodeGenerator ifElse(Consumer<JavaCodeGenerator> condition, Consumer<JavaCodeGenerator> accept, Consumer<JavaCodeGenerator> reject) {
        this.print("if (");
        condition.accept(this);
        this.println(") {");
        this.enterScope();
        this.indent();
        accept.accept(this);
        this.dedent();
        this.leaveScope();
        if (reject != null) {
            this.println("} else {");
            this.enterScope();
            this.indent();
            reject.accept(this);
            this.dedent();
            this.leaveScope();
        }
        this.println("}");
        return this;
    }

    private Consumer<JavaCodeGenerator> literal(String condition) {
        return cg -> cg.print(condition);
    }

    public void generate(Writer out) {
        IndentedPrintWriter pw = new IndentedPrintWriter(out);
        this.leaveUntil(this.parent == null ? null : this.parent.scope);
        for (Consumer cmd : this.scope.delayed) {
            cmd.accept(pw);
        }
    }

    private void leaveUntil(Scope root) {
        while (this.scope.parent != root) {
            this.leaveScope();
        }
    }

    public JavaCodeGenerator beginBlock() {
        this.println("{");
        this.indent();
        this.enterScope();
        return this;
    }

    public JavaCodeGenerator endBlock() {
        this.leaveScope();
        this.dedent();
        this.println("}");
        return this;
    }

    private void enterScope() {
        this.scope = new Scope(this.scope);
    }

    private void leaveScope() {
        if (this.scope.parent == null) {
            throw new IllegalStateException("you must be in a scope to leave it");
        }
        this.scope.parent.delayed.addAll(this.scope.delayed);
        this.scope = this.scope.parent;
    }

    private String escape(String s) {
        int len = s.length();
        StringBuilder sb = new StringBuilder(len);
        block6: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block6;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block6;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block6;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public JavaCodeGenerator println() {
        this.scope.delayed.add(PrintWriter::println);
        return this;
    }

    public JavaCodeGenerator println(Object s) {
        this.scope.delayed.add(pw -> pw.println(s));
        return this;
    }

    public JavaCodeGenerator print(Object s) {
        this.scope.delayed.add(pw -> pw.print(s));
        return this;
    }

    public JavaCodeGenerator printf(String format, Object ... args) {
        this.scope.delayed.add(this.printfInternal(format, args));
        return this;
    }

    private void indent() {
        this.scope.delayed.add(IndentedPrintWriter::indent);
    }

    private void dedent() {
        this.scope.delayed.add(IndentedPrintWriter::dedent);
    }

    public ClassBuilder publicClass(String name) {
        return new ClassBuilder("public", name);
    }

    public MethodBuilder packageMethod(String returnType, String name) {
        return new MethodBuilder("", returnType, name);
    }

    public MethodBuilder privateMethod(String returnType, String name) {
        return new MethodBuilder("private ", returnType, name);
    }

    public MethodBuilder publicMethod(String returnType, String name) {
        return new MethodBuilder("public ", returnType, name);
    }

    public static class Scope {
        private final Scope parent;
        private final Set<String> variables = new HashSet<String>();
        private int lastDeclaration;
        private final List<Consumer<IndentedPrintWriter>> delayed = new ArrayList<Consumer<IndentedPrintWriter>>();
        private int varId;

        private Scope() {
            this.parent = null;
        }

        private Scope(Scope parent) {
            this.parent = parent;
        }

        private void declare(String name) {
            if (this.variables.contains(name)) {
                throw new IllegalArgumentException(String.format("variable '%s' already declared in this scope", name));
            }
            this.variables.add(name);
        }

        private String mangle(String name) {
            int level = -1;
            Scope scope = this;
            while (scope != null) {
                if (scope.variables.contains(name)) {
                    ++level;
                }
                scope = scope.parent;
            }
            return level > 0 ? name + "$" + level : name;
        }

        String variable(String name) {
            if (this.variables.contains(name)) {
                return this.mangle(name);
            }
            if (this.parent != null) {
                return this.parent.variable(name);
            }
            throw new IllegalArgumentException("Unknown variable: " + name);
        }

        private String unique(String name) {
            return name + "_" + ++this.varId;
        }

        public String declare(String type, String name, String initialValue) {
            this.delayed.add(this.lastDeclaration++, this.declareInternal(type, name, initialValue));
            return this.variable(name);
        }

        private Consumer<IndentedPrintWriter> declareInternal(String type, String name, String initialValue) {
            this.declare(name);
            String resolvedVariable = this.variable(name);
            return pw -> {
                if (initialValue == null) {
                    pw.printf("%s %s;%n", type, resolvedVariable);
                } else {
                    pw.printf("%s %s = %s;%n", type, resolvedVariable, initialValue);
                }
            };
        }

        public boolean isDefined(String variable) {
            return this.variables.contains(variable);
        }
    }

    public class MethodBuilder {
        private JavaCodeGenerator cg;
        private boolean hasArgs;

        private MethodBuilder(String visibility, String returnType, String name) {
            this.cg = new JavaCodeGenerator(JavaCodeGenerator.this);
            this.cg.printf("%s%s %s(", visibility, returnType, name);
        }

        public MethodBuilder arg(String type, String name) {
            this.cg.declareExisting(name);
            if (this.hasArgs) {
                this.cg.print(", ");
            }
            this.cg.printf("%s %s", type, name);
            this.hasArgs = true;
            return this;
        }

        public JavaCodeGenerator build(Consumer<JavaCodeGenerator> body) {
            this.cg.println(") {");
            this.cg.indent();
            JavaCodeGenerator bodyGen = new JavaCodeGenerator(this.cg);
            body.accept(bodyGen);
            bodyGen.leaveScope();
            this.cg.dedent();
            this.cg.println("}");
            this.cg.leaveScope();
            return JavaCodeGenerator.this;
        }
    }

    public class ClassBuilder {
        private ClassBuilder(String visibility, String name) {
            JavaCodeGenerator.this.declareExisting(name);
            if (visibility != null) {
                JavaCodeGenerator.this.printf("%s class %s", visibility, name);
            } else {
                JavaCodeGenerator.this.printf("class %s", name);
            }
        }

        public ClassBuilder extend(String aClass) {
            JavaCodeGenerator.this.printf(" extends %s", aClass);
            return this;
        }

        public ClassBuilder implement(String ... anInterface) {
            StringJoiner joiner = new StringJoiner(",");
            for (String s : anInterface) {
                joiner.add(s);
            }
            JavaCodeGenerator.this.printf(" implements %s", joiner);
            return this;
        }

        public JavaCodeGenerator build(Consumer<JavaCodeGenerator> body) {
            JavaCodeGenerator.this.println(" {");
            JavaCodeGenerator.this.enterScope();
            JavaCodeGenerator.this.indent();
            body.accept(JavaCodeGenerator.this);
            JavaCodeGenerator.this.dedent();
            JavaCodeGenerator.this.println("}");
            JavaCodeGenerator.this.leaveScope();
            return JavaCodeGenerator.this;
        }
    }
}

