/*
 * Decompiled with CFR 0.152.
 */
package com.openle.module.core;

import com.openle.module.core.OS;
import com.openle.module.core.io.IO;
import com.openle.module.core.tuple.Tuple;
import com.openle.module.core.tuple.Tuple3;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.function.Function;
import java.util.logging.Logger;

public class Shell {
    private static String commandsPath = "";

    public static void init() {
        String v2 = (String)Shell.runCommandAndReturn((String)"type busybox").v2;
        System.out.println("Shell init\uff1a" + v2);
        if (v2.contains("busybox is")) {
            commandsPath = "busybox";
        }
    }

    public static boolean isRootShell() {
        String r = (String)Shell.runCommandAndReturn((String)"id").v2;
        System.out.println("a:" + r);
        if (r.contains("uid=0(root)")) {
            System.out.println("you are root!");
            return true;
        }
        return false;
    }

    public static void setCommandsPath(String commandsPath) {
        Shell.commandsPath = commandsPath;
    }

    public static String getCommandsPath() {
        return commandsPath;
    }

    public static String full(String command) {
        return (commandsPath + " " + command).trim();
    }

    public static Integer runCommand(String command) {
        return Shell.runCommand(command, null);
    }

    public static Tuple3<Integer, String, String> runCommandAndReturn(String command) {
        return Shell.runCommandAndReturn(command, null);
    }

    public static Integer runRootCommand(String command) {
        return Shell.runRootCommand(command, null);
    }

    public static Tuple3<Integer, String, String> runRootCommandAndReturn(String command) {
        return Shell.runRootCommandAndReturn(command, null);
    }

    public static Integer runCommand(String command, Function<String, String> cb) {
        Tuple3<Integer, String, String> t3 = Shell.runCommand(command, false, false, "sh", cb);
        if (t3 == null || t3.v1 == null) {
            return -1;
        }
        return (Integer)t3.v1;
    }

    public static Tuple3<Integer, String, String> runCommandAndReturn(String command, Function<String, String> cb) {
        return Shell.runCommand(command, true, false, "sh", cb);
    }

    public static Integer runRootCommand(String command, Function<String, String> cb) {
        return (Integer)Shell.runCommand((String)command, (boolean)false, (boolean)false, (String)"su", cb).v1;
    }

    public static Tuple3<Integer, String, String> runRootCommandAndReturn(String command, Function<String, String> cb) {
        return Shell.runCommand(command, true, false, "su", cb);
    }

    public static Tuple3<Integer, String, String> runCommand(String command, boolean isNeedResult, boolean isPure, String shOrSuPath, Function<String, String> cb) {
        boolean isWindowsAndPure;
        System.out.println("runCommand:command=" + command + "|isNeedResult=" + isNeedResult + "|isPure=" + isPure + "|suPath=" + shOrSuPath);
        Process process = null;
        BufferedReader stdOut = null;
        Tuple3<Integer, String, String> t = Tuple.tuple(-1, "", "Shell Default Info!");
        StringBuilder output = new StringBuilder();
        StringBuilder error = new StringBuilder();
        try {
            if (OS.isWindows()) {
                if (isPure) {
                    process = Runtime.getRuntime().exec(command);
                } else {
                    String[] commands = new String[]{"sh", "-c", command};
                    if (OS.isWindows()) {
                        commands = new String[]{"cmd", "/C", "chcp 65001 & " + command};
                    }
                    process = Runtime.getRuntime().exec(commands);
                }
            } else {
                process = Runtime.getRuntime().exec(shOrSuPath);
                DataOutputStream os = new DataOutputStream(process.getOutputStream());
                os.writeBytes(command + "\n");
                os.writeBytes("exit\n");
                os.flush();
            }
        }
        catch (IOException e) {
            System.err.println("Shell IOException:");
            System.err.println(e);
        }
        if (process == null) {
            System.err.println("Shell Process is null!");
            return t;
        }
        boolean bl = isWindowsAndPure = OS.isWindows() && !isPure;
        if (isNeedResult) {
            try {
                stdOut = new BufferedReader(new InputStreamReader(process.getInputStream(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                Logger.getGlobal().severe(e.toString());
            }
            if (stdOut != null) {
                try {
                    String line;
                    while ((line = stdOut.readLine()) != null) {
                        if (isWindowsAndPure) {
                            isWindowsAndPure = false;
                            continue;
                        }
                        if (cb != null) {
                            cb.apply(line);
                            continue;
                        }
                        output.append(line).append('\n');
                    }
                }
                catch (IOException e) {
                    Logger.getGlobal().severe(e.toString());
                }
            }
            error.append(IO.inputStreamToString(process.getErrorStream()));
        }
        try {
            int exitValue = process.waitFor();
            if (0 != exitValue) {
                System.err.println("call shell failed. error code is :" + exitValue);
            }
        }
        catch (InterruptedException e) {
            Logger.getGlobal().severe(e.toString());
        }
        t = Tuple.tuple(process.exitValue(), output.toString().trim(), error.toString().trim());
        if (((String)t.v3).length() > 0) {
            System.out.println(t);
        }
        System.out.println("shell over.");
        return t;
    }
}

