/*
 * Decompiled with CFR 0.152.
 */
package com.openle.module.core.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class IO {
    public static String newLine = System.lineSeparator();

    public static void deleteIfExistsWithNotEmpty(Path dir) throws IOException {
        try {
            Files.deleteIfExists(dir);
        }
        catch (DirectoryNotEmptyException e) {
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return super.postVisitDirectory(dir, exc);
                }
            });
        }
    }

    public static String readText(String path) {
        String result = null;
        File f = new File(path);
        if (f.exists()) {
            try {
                InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8");
                BufferedReader br = new BufferedReader(isr);
                String data = null;
                while ((data = br.readLine()) != null) {
                    if (result == null) {
                        result = "";
                    }
                    result = result + data + newLine;
                }
                isr.close();
                br.close();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }
        return result != null ? result.trim() : null;
    }

    public static void writeText(String path, String content) {
        File f = new File(path);
        try {
            if (!f.exists()) {
                f.createNewFile();
            }
            OutputStreamWriter write = new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8");
            BufferedWriter bw = new BufferedWriter(write);
            bw.write(content);
            bw.close();
            write.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public static boolean deleteFile(String fileName) {
        File file = new File(fileName);
        return file.delete();
    }

    public static String inputStreamToString(InputStream is) {
        if (is != null) {
            System.err.println("inputStreamToString() InputStream is null!");
            return null;
        }
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            BufferedReader buf = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            while ((line = buf.readLine()) != null) {
                sb.append(line).append(newLine);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static String fileSizeFormat(long size) {
        long kb = 1024L;
        long mb = kb * 1024L;
        long gb = mb * 1024L;
        if (size >= gb) {
            return String.format("%.1f GB", Float.valueOf((float)size / (float)gb));
        }
        if (size >= mb) {
            float f = (float)size / (float)mb;
            return String.format(f > 100.0f ? "%.0f MB" : "%.1f MB", Float.valueOf(f));
        }
        if (size >= kb) {
            float f = (float)size / (float)kb;
            return String.format(f > 100.0f ? "%.0f KB" : "%.1f KB", Float.valueOf(f));
        }
        return String.format("%d B", size);
    }
}

