/*
 * Decompiled with CFR 0.152.
 */
package com.openle.module.core.lambda;

import java.io.Serializable;
import java.lang.invoke.MethodType;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public class Lambda {
    public static void main(String[] args) {
        String mt = Lambda.extractConsumer(t -> t.toString()).get().getInstantiatedMethodType();
        System.out.println(mt);
        System.out.println(MethodType.fromMethodDescriptorString(mt, Thread.currentThread().getContextClassLoader()).parameterType(0));
    }

    public static Optional<SerializedLambda> extractConsumer(Consumer<?> lambda) {
        return Lambda.getSerializedLambda((Serializable)((Object)lambda));
    }

    public static <T, R> Optional<SerializedLambda> extractFunction(Function<T, R> lambda) {
        return Lambda.getSerializedLambda((Serializable)((Object)lambda));
    }

    public static Optional<SerializedLambda> getSerializedLambda(Serializable lambda) {
        for (Class<?> cl = lambda.getClass(); cl != null; cl = cl.getSuperclass()) {
            try {
                Method m = cl.getDeclaredMethod("writeReplace", new Class[0]);
                m.setAccessible(true);
                Object replacement = m.invoke((Object)lambda, new Object[0]);
                if (replacement instanceof SerializedLambda) {
                    SerializedLambda l = (SerializedLambda)replacement;
                    return Optional.of(l);
                }
                break;
            }
            catch (NoSuchMethodException m) {
                continue;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                break;
            }
        }
        return Optional.empty();
    }
}

