/*
 * Decompiled with CFR 0.152.
 */
package com.openle.module.core.lambda;

import com.openle.module.core.converter.HexConverter;
import com.openle.module.core.lambda.Lambda;
import com.openle.module.core.lambda.SerializedFunction;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.function.Function;
import java.util.function.Supplier;

public class LambdaFactory {
    public static void main(String[] args) {
        Function f = LambdaFactory.newSerializedMethodReferences("abc");
        System.out.println(f);
        System.out.println(f instanceof SerializedFunction);
        SerializedLambda sl = Lambda.getSerializedLambda((Serializable)((Object)f)).get();
        System.out.println(sl.getImplMethodName());
        String s = LambdaFactory.getMethodReferencesName(f);
        System.out.println(s);
    }

    public static Function newMethodReferences(String methodName) {
        return LambdaFactory.newMethodReferences(methodName, false);
    }

    public static Function newSerializedMethodReferences(String methodName) {
        return LambdaFactory.newMethodReferences(methodName, true);
    }

    private static Function newMethodReferences(String methodName, boolean isSerializable) {
        methodName = HexConverter.bytesToHexString(methodName.getBytes());
        try {
            MethodHandles.Lookup caller = MethodHandles.lookup();
            MethodType getter = MethodType.methodType(String.class);
            MethodHandle target = LambdaFactory.getMethodHandle(Object.class, methodName, getter);
            MethodType invokedType = MethodType.methodType(Function.class);
            CallSite site = isSerializable ? LambdaMetafactory.altMetafactory(caller, "apply", invokedType, target.type().generic(), target, target.type(), 1) : LambdaMetafactory.metafactory(caller, "apply", invokedType, target.type().generic(), target, target.type());
            Object obj = site.getTarget().invoke();
            Function f = (Function)obj;
            return f;
        }
        catch (Throwable ex) {
            System.err.println(ex);
            return null;
        }
    }

    private static MethodHandle getMethodHandle(Class<?> c, String methodName, MethodType getter) throws ReflectiveOperationException {
        int REF_invokeVirtual = 5;
        int REF_invokeInterface = 9;
        byte refKind = c.isInterface() ? (byte)9 : 5;
        Class<?> memberNameClass = Class.forName("java.lang.invoke.MemberName");
        Constructor<?> con = memberNameClass.getConstructor(Class.class, String.class, MethodType.class, Byte.TYPE);
        con.setAccessible(true);
        Object memberName = con.newInstance(c, methodName, getter, refKind);
        con.setAccessible(false);
        Field field = memberNameClass.getDeclaredField("resolution");
        field.setAccessible(true);
        field.set(memberName, null);
        field.setAccessible(false);
        Method m = memberNameClass.getDeclaredMethod("flagsMods", Integer.TYPE, Integer.TYPE, Byte.TYPE);
        m.setAccessible(true);
        int flags = (Integer)m.invoke(memberName, 65536, con.getModifiers(), (byte)5);
        m.setAccessible(false);
        field = memberNameClass.getDeclaredField("flags");
        field.setAccessible(true);
        field.set(memberName, flags);
        field.setAccessible(false);
        Class<?> directMethodHandleClass = Class.forName("java.lang.invoke.DirectMethodHandle");
        m = directMethodHandleClass.getDeclaredMethod("make", Byte.TYPE, Class.class, memberNameClass);
        m.setAccessible(true);
        MethodHandle target = (MethodHandle)m.invoke(null, refKind, c, memberName);
        m.setAccessible(false);
        return target;
    }

    public static <T> String getMethodReferencesName(Function<T, ?> getter) {
        SerializedLambda sl = Lambda.extractFunction(getter).get();
        String name = new String(HexConverter.hexStringToBytes(sl.getImplMethodName()));
        return name;
    }

    private static void createSupplier() throws Throwable {
        MethodHandles.Lookup caller = MethodHandles.lookup();
        MethodType methodType = MethodType.methodType(Object.class);
        MethodType actualMethodType = MethodType.methodType(String.class);
        MethodType invokedType = MethodType.methodType(Supplier.class);
        CallSite site = LambdaMetafactory.metafactory(caller, "get", invokedType, methodType, caller.findStatic(LambdaFactory.class, "print", actualMethodType), methodType);
        MethodHandle factory = site.getTarget();
        Supplier r = factory.invoke();
        System.out.println((String)r.get());
    }
}

