/*
 * Decompiled with CFR 0.152.
 */
package com.openle.module.core.network;

import java.net.InetAddress;

public class IPv4Common {
    private static final int INADDRSZ = 4;

    public static byte[] ipToBytesByInet(String ipAddr) {
        try {
            return InetAddress.getByName(ipAddr).getAddress();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(ipAddr + " is invalid IP");
        }
    }

    public static byte[] ipToBytesByReg(String ipAddr) {
        byte[] ret = new byte[4];
        try {
            String[] ipArr = ipAddr.split("\\.");
            ret[0] = (byte)(Integer.parseInt(ipArr[0]) & 0xFF);
            ret[1] = (byte)(Integer.parseInt(ipArr[1]) & 0xFF);
            ret[2] = (byte)(Integer.parseInt(ipArr[2]) & 0xFF);
            ret[3] = (byte)(Integer.parseInt(ipArr[3]) & 0xFF);
            return ret;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(ipAddr + " is invalid IP");
        }
    }

    public static String bytesToIp(byte[] bytes) {
        return new StringBuffer().append(bytes[0] & 0xFF).append('.').append(bytes[1] & 0xFF).append('.').append(bytes[2] & 0xFF).append('.').append(bytes[3] & 0xFF).toString();
    }

    public static int bytesToInt(byte[] bytes) {
        int addr = bytes[3] & 0xFF;
        addr |= bytes[2] << 8 & 0xFF00;
        addr |= bytes[1] << 16 & 0xFF0000;
        return addr |= bytes[0] << 24 & 0xFF000000;
    }

    public static int ipToInt(String ipAddr) {
        try {
            return IPv4Common.bytesToInt(IPv4Common.ipToBytesByInet(ipAddr));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(ipAddr + " is invalid IP");
        }
    }

    public static byte[] intToBytes(int ipInt) {
        byte[] ipAddr = new byte[]{(byte)(ipInt >>> 24 & 0xFF), (byte)(ipInt >>> 16 & 0xFF), (byte)(ipInt >>> 8 & 0xFF), (byte)(ipInt & 0xFF)};
        return ipAddr;
    }

    public static String intToIp(int ipInt) {
        return "" + (ipInt >> 24 & 0xFF) + '.' + (ipInt >> 16 & 0xFF) + '.' + (ipInt >> 8 & 0xFF) + '.' + (ipInt & 0xFF);
    }

    public static int[] getIPIntScope(String ipAndMask) {
        String[] ipArr = ipAndMask.split("/");
        if (ipArr.length != 2) {
            throw new IllegalArgumentException("invalid ipAndMask with: " + ipAndMask);
        }
        int netMask = Integer.valueOf(ipArr[1].trim());
        if (netMask < 0 || netMask > 31) {
            throw new IllegalArgumentException("invalid ipAndMask with: " + ipAndMask);
        }
        int ipInt = IPv4Common.ipToInt(ipArr[0]);
        int netIP = ipInt & -1 << 32 - netMask;
        int hostScope = -1 >>> netMask;
        return new int[]{netIP, netIP + hostScope};
    }

    public static String[] getIPAddrScope(String ipAndMask) {
        int[] ipIntArr = IPv4Common.getIPIntScope(ipAndMask);
        return new String[]{IPv4Common.intToIp(ipIntArr[0]), IPv4Common.intToIp(ipIntArr[0])};
    }

    public static int[] getIPIntScope(String ipAddr, String mask) {
        int netMaskInt = 0;
        int ipcount = 0;
        try {
            int ipInt = IPv4Common.ipToInt(ipAddr);
            if (null == mask || "".equals(mask)) {
                return new int[]{ipInt, ipInt};
            }
            netMaskInt = IPv4Common.ipToInt(mask);
            ipcount = IPv4Common.ipToInt("255.255.255.255") - netMaskInt;
            int netIP = ipInt & netMaskInt;
            int hostScope = netIP + ipcount;
            return new int[]{netIP, hostScope};
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid ip scope express  ip:" + ipAddr + "  mask:" + mask);
        }
    }

    public static String[] getIPStrScope(String ipAddr, String mask) {
        int[] ipIntArr = IPv4Common.getIPIntScope(ipAddr, mask);
        return new String[]{IPv4Common.intToIp(ipIntArr[0]), IPv4Common.intToIp(ipIntArr[0])};
    }

    public static void main(String[] args) throws Exception {
        String ipAddr = "192.168.8.1";
        ipAddr = "0.0.255.255";
        byte[] bytearr = IPv4Common.ipToBytesByInet(ipAddr);
        StringBuffer byteStr = new StringBuffer();
        for (byte b : bytearr) {
            if (byteStr.length() == 0) {
                byteStr.append(b);
                continue;
            }
            byteStr.append("," + b);
        }
        System.out.println("IP: " + ipAddr + " ByInet --> byte[]: [ " + byteStr + " ]");
        bytearr = IPv4Common.ipToBytesByReg(ipAddr);
        byteStr = new StringBuffer();
        for (byte b : bytearr) {
            if (byteStr.length() == 0) {
                byteStr.append(b);
                continue;
            }
            byteStr.append("," + b);
        }
        System.out.println("IP: " + ipAddr + " ByReg  --> byte[]: [ " + byteStr + " ]");
        System.out.println("byte[]: " + byteStr + " --> IP: " + IPv4Common.bytesToIp(bytearr));
        int ipInt = IPv4Common.ipToInt(ipAddr);
        System.out.println("IP: " + ipAddr + "  --> int: " + ipInt);
        System.out.println("int: " + ipInt + " --> IP: " + IPv4Common.intToIp(ipInt));
        String ipAndMask = "192.168.1.1/24";
        int[] ipscope = IPv4Common.getIPIntScope(ipAndMask);
        System.out.println(ipAndMask + " --> int\u5730\u5740\u6bb5\uff1a[ " + ipscope[0] + "," + ipscope[1] + " ]");
        System.out.println(ipAndMask + " --> IP \u5730\u5740\u6bb5\uff1a[ " + IPv4Common.intToIp(ipscope[0]) + "," + IPv4Common.intToIp(ipscope[1]) + " ]");
        String ipAddr1 = "192.168.1.1";
        String ipMask1 = "255.255.255.0";
        int[] ipscope1 = IPv4Common.getIPIntScope(ipAddr1, ipMask1);
        System.out.println(ipAddr1 + " , " + ipMask1 + "  --> int\u5730\u5740\u6bb5 \uff1a[ " + ipscope1[0] + "," + ipscope1[1] + " ]");
        System.out.println(ipAddr1 + " , " + ipMask1 + "  --> IP\u5730\u5740\u6bb5 \uff1a[ " + IPv4Common.intToIp(ipscope1[0]) + "," + IPv4Common.intToIp(ipscope1[1]) + " ]");
    }
}

