/*
 * Decompiled with CFR 0.152.
 */
package com.openle.module.core.network;

import com.openle.module.core.OS;
import com.openle.module.core.network.ParameterParser;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class NetCommon {
    public static List<NetworkInterface> getAllNetworkInterfaces() {
        try {
            return Collections.list(NetworkInterface.getNetworkInterfaces());
        }
        catch (SocketException ex) {
            Logger.getLogger(NetCommon.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static List<NetworkInterface> getNetworkInterfacesWithMAC() {
        List<NetworkInterface> niList = NetCommon.getAllNetworkInterfaces().stream().filter(ni -> {
            try {
                return ni.getHardwareAddress() != null;
            }
            catch (SocketException ex) {
                Logger.getLogger(NetCommon.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
        }).collect(Collectors.toList());
        return niList;
    }

    public static NetworkInterface getEthernetNetworkInterface() {
        NetworkInterface ni = null;
        try {
            ni = NetworkInterface.getByInetAddress(InetAddress.getLocalHost());
            if (ni.isLoopback() && !OS.isWindows()) {
                System.out.println("NetworkInterface.getByName(eth0)");
                ni = NetworkInterface.getByName("eth0");
            }
        }
        catch (SocketException | UnknownHostException ex) {
            Logger.getLogger(NetCommon.class.getName()).log(Level.SEVERE, null, ex);
        }
        return ni;
    }

    public static String getEthernetMAC() {
        String mac = null;
        NetworkInterface ni = NetCommon.getEthernetNetworkInterface();
        try {
            if (ni != null) {
                mac = NetCommon.macBytesToString(ni.getHardwareAddress());
            }
        }
        catch (SocketException ex) {
            Logger.getLogger(NetCommon.class.getName()).log(Level.SEVERE, null, ex);
        }
        return mac;
    }

    public static String getHostAddress(NetworkInterface ni) {
        List ipList;
        String ip = null;
        if (ni != null && (ipList = Collections.list(ni.getInetAddresses()).stream().filter(ia -> !ia.isLoopbackAddress() && !ia.isLinkLocalAddress() && ia instanceof Inet4Address).collect(Collectors.toList())).size() > 0) {
            return ((InetAddress)ipList.get(0)).getHostAddress();
        }
        return ip;
    }

    public static String getHostAddress() {
        List ipList = NetCommon.getAllNetworkInterfaces().stream().filter(ni -> NetCommon.getHostAddress(ni) != null).collect(Collectors.toList());
        if (ipList.size() > 0) {
            return NetCommon.getHostAddress((NetworkInterface)ipList.get(0));
        }
        return null;
    }

    public static String macBytesToString(byte[] mac) {
        StringBuffer sb = null;
        if (mac != null) {
            sb = new StringBuffer();
            for (int i = 0; i < mac.length; ++i) {
                String s;
                if (i != 0) {
                    sb.append("-");
                }
                sb.append((s = Integer.toHexString(mac[i] & 0xFF)).length() == 1 ? 0 + s : s);
            }
        }
        return sb != null ? sb.toString().toUpperCase() : null;
    }

    public static String getFileName(String cd) {
        String cdl;
        String fileName = null;
        if (cd != null && ((cdl = cd.toLowerCase(Locale.ENGLISH)).startsWith("form-data") || cdl.startsWith("attachment"))) {
            ParameterParser paramParser = new ParameterParser();
            paramParser.setLowerCaseNames(true);
            Map params = paramParser.parse(cd, ';');
            if (params.containsKey("filename")) {
                fileName = (String)params.get("filename");
                fileName = fileName != null ? fileName.trim() : "";
            }
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpGet(String url) {
        String content = null;
        ByteArrayOutputStream baoStream = null;
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, new TrustManager[]{new MyTrustManager()}, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
            URL urlObj = new URL(url);
            HttpURLConnection httpConn = (HttpURLConnection)urlObj.openConnection();
            httpConn.setDoInput(true);
            httpConn.setDoOutput(true);
            httpConn.setRequestMethod("GET");
            httpConn.setUseCaches(false);
            httpConn.connect();
            String encoding = httpConn.getContentEncoding();
            InputStream is = httpConn.getInputStream();
            int read = -1;
            baoStream = new ByteArrayOutputStream();
            while ((read = is.read()) != -1) {
                baoStream.write(read);
            }
            byte[] data = baoStream.toByteArray();
            baoStream.close();
            content = encoding != null ? new String(data, encoding) : new String(data);
        }
        catch (IOException e) {
            System.out.println("\u53d1\u9001GET\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01" + e);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            System.out.println(e);
        }
        finally {
            try {
                if (baoStream != null) {
                    baoStream.close();
                }
            }
            catch (IOException ex) {
                System.out.println("\u53d1\u9001GET\u8bf7\u6c42finally\u51fa\u73b0\u5f02\u5e38\uff01" + ex);
            }
        }
        return content;
    }

    public static ReturnStringAndError requestWithoutCA(String urlString) {
        ReturnStringAndError r = new ReturnStringAndError();
        String html = "";
        try {
            String lines;
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, new TrustManager[]{new MyTrustManager()}, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
            URL url = new URL(urlString);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            InputStream in = urlConnection.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            System.out.println("Contents of get request");
            while ((lines = reader.readLine()) != null) {
                html = html + lines;
            }
            reader.close();
            urlConnection.disconnect();
            r.setString(html);
            System.out.println("Contents of get request ends");
        }
        catch (MalformedURLException e) {
            r.setError(e.getMessage());
        }
        catch (IOException e) {
            r.setError(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            r.setError(e.getMessage());
        }
        catch (KeyManagementException e) {
            r.setError(e.getMessage());
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPost(String url, String params) {
        String content = null;
        ByteArrayOutputStream baoStream = null;
        FilterOutputStream dos = null;
        try {
            URL urlObj = new URL(url);
            HttpURLConnection httpConn = (HttpURLConnection)urlObj.openConnection();
            httpConn.setDoInput(true);
            httpConn.setDoOutput(true);
            httpConn.setRequestMethod("POST");
            httpConn.setUseCaches(false);
            httpConn.connect();
            dos = new DataOutputStream(httpConn.getOutputStream());
            dos.write(params.getBytes());
            ((DataOutputStream)dos).flush();
            String encoding = httpConn.getContentEncoding();
            InputStream is = httpConn.getInputStream();
            int read = -1;
            baoStream = new ByteArrayOutputStream();
            while ((read = is.read()) != -1) {
                baoStream.write(read);
            }
            byte[] data = baoStream.toByteArray();
            content = encoding != null ? new String(data, encoding) : new String(data);
        }
        catch (IOException e) {
            System.out.println("\u53d1\u9001POST\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01" + e);
        }
        finally {
            try {
                if (dos != null) {
                    dos.close();
                }
                if (baoStream != null) {
                    baoStream.close();
                }
            }
            catch (IOException ex) {
                System.out.println("\u53d1\u9001POST\u8bf7\u6c42finally\u51fa\u73b0\u5f02\u5e38\uff01" + ex);
            }
        }
        return content;
    }

    private static class MyTrustManager
    implements X509TrustManager {
        private MyTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }

    private static class MyHostnameVerifier
    implements HostnameVerifier {
        private MyHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    public static class ReturnStringAndError {
        private String string;
        private String error;

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getString() {
            return this.string;
        }

        public void setString(String string) {
            this.string = string;
        }
    }
}

