/*
 * Decompiled with CFR 0.152.
 */
package com.openle.p.core.network;

import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class MulticastHelper
implements Closeable {
    private final String multicastHost;
    private final int multicastPort;
    private InetAddress receiveInetAddress;
    private MulticastSocket receiveMulticastSocket;
    private MulticastCallback callback;
    private final ExecutorService service = Executors.newFixedThreadPool(1);
    private Future future;

    public MulticastHelper(String multicastHost, int multicastPort) {
        this.multicastHost = multicastHost;
        this.multicastPort = multicastPort;
    }

    public static void sendMulticast(String multicastHost, int multicastPort, byte[] multicastData) throws IOException {
        InetAddress group = InetAddress.getByName(multicastHost);
        try (MulticastSocket socket = new MulticastSocket();){
            socket.send(new DatagramPacket(multicastData, multicastData.length, group, multicastPort));
        }
    }

    public void sendMulticast(byte[] multicastData) throws IOException {
        MulticastHelper.sendMulticast(this.multicastHost, this.multicastPort, multicastData);
    }

    public void setCallback(MulticastCallback callback) {
        this.callback = callback;
    }

    public void receiveMulticast() throws IOException {
        if (this.future != null) {
            this.future.cancel(true);
            this.future = null;
            this.close();
        }
        this.receiveInetAddress = InetAddress.getByName(this.multicastHost);
        this.receiveMulticastSocket = new MulticastSocket(this.multicastPort);
        this.receiveMulticastSocket.joinGroup(this.receiveInetAddress);
        this.future = this.service.submit(() -> {
            byte[] buf = new byte[2048];
            while (true) {
                DatagramPacket msgPacket = new DatagramPacket(buf, buf.length);
                this.receiveMulticastSocket.receive(msgPacket);
                if (this.callback == null) continue;
                this.callback.received(msgPacket.getAddress().getHostAddress(), msgPacket.getPort(), msgPacket.getData(), msgPacket);
            }
        });
    }

    public void receiveMulticast(NetworkInterface networkInterface) throws IOException {
        if (this.future != null) {
            this.future.cancel(true);
            this.future = null;
            this.close();
        }
        this.receiveInetAddress = InetAddress.getByName(this.multicastHost);
        this.receiveMulticastSocket = new MulticastSocket(this.multicastPort);
        this.receiveMulticastSocket.joinGroup(new InetSocketAddress(this.receiveInetAddress, this.multicastPort), networkInterface);
        this.future = this.service.submit(() -> {
            byte[] buf = new byte[10240];
            while (true) {
                DatagramPacket msgPacket = new DatagramPacket(buf, buf.length);
                this.receiveMulticastSocket.receive(msgPacket);
                if (this.callback == null) continue;
                this.callback.received(msgPacket.getAddress().getHostAddress(), msgPacket.getPort(), msgPacket.getData(), msgPacket);
            }
        });
    }

    @Override
    public void close() throws IOException {
        if (this.receiveMulticastSocket != null && this.receiveInetAddress != null) {
            this.receiveMulticastSocket.leaveGroup(this.receiveInetAddress);
        }
    }

    public static interface MulticastCallback {
        public void received(String var1, int var2, byte[] var3, DatagramPacket var4);
    }
}

