/*
 * Decompiled with CFR 0.152.
 */
package core.parser.processor.string;

import core.parser.processor.IProcessor;

public class PunctuationProcessor
implements IProcessor<String> {
    private String replaceWithSpaceRegex = ",;=\\-\\+*/.";
    private String replaceWithBlankRegex = "^\\w\\s";

    public PunctuationProcessor(String[] allowed) {
        if (allowed != null) {
            for (String matcher : allowed) {
                this.replaceWithSpaceRegex = this.replaceWithSpaceRegex.replaceAll(matcher, "");
                this.replaceWithBlankRegex = this.replaceWithBlankRegex + matcher;
            }
        }
    }

    @Override
    public String process(String in) {
        return in.replaceAll(String.format("[%s]+", this.replaceWithSpaceRegex), " ").replaceAll(String.format("[%s]+", this.replaceWithBlankRegex), "");
    }
}

