/*
 * Decompiled with CFR 0.152.
 */
package core.query.node;

import core.query.Query;
import core.search.zones.textzone.positionalindex.IPositionalIndex;
import core.search.zones.textzone.positionalindex.Posting;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class And
extends Query {
    public static final Character TOKEN_AND = Character.valueOf(' ');

    public And(Query left, Query right) {
        super(left, right);
    }

    @Override
    public List<Posting> match(IPositionalIndex positionalIndex) {
        return this.intersect(this.getLeft().match(positionalIndex), this.getRight().match(positionalIndex));
    }

    public String toString() {
        return String.format("%s%s%s", this.getLeft(), TOKEN_AND, this.getRight());
    }

    private List<Posting> intersect(List<Posting> left, List<Posting> right) {
        boolean hasItems;
        Iterator<Posting> itLeft = left.iterator();
        Iterator<Posting> itRight = right.iterator();
        ArrayList<Posting> intersect = new ArrayList<Posting>();
        boolean bl = hasItems = itLeft.hasNext() && itRight.hasNext();
        if (!hasItems) {
            return intersect;
        }
        Posting postingLeft = itLeft.next();
        Posting postingRight = itRight.next();
        while (hasItems) {
            if (postingLeft.equals(postingRight)) {
                intersect.add(postingLeft);
                if (itLeft.hasNext() && itRight.hasNext()) {
                    postingLeft = itLeft.next();
                    postingRight = itRight.next();
                    continue;
                }
                hasItems = false;
                continue;
            }
            if (postingLeft.compareTo(postingRight) < 0) {
                if (itLeft.hasNext()) {
                    postingLeft = itLeft.next();
                    continue;
                }
                hasItems = false;
                continue;
            }
            if (itRight.hasNext()) {
                postingRight = itRight.next();
                continue;
            }
            hasItems = false;
        }
        return intersect;
    }
}

