/*
 * Decompiled with CFR 0.152.
 */
package core.query.node;

import core.query.Query;
import core.search.zones.textzone.positionalindex.IPositionalIndex;
import core.search.zones.textzone.positionalindex.Posting;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class Phrase
extends Query {
    public static final Character TOKEN_PHRASE = Character.valueOf('+');

    public Phrase(Query left, Query right) {
        super(left, right);
    }

    @Override
    public List<Posting> match(IPositionalIndex positionalIndex) {
        return this.orderedUnion(this.getLeft().match(positionalIndex), this.getRight().match(positionalIndex));
    }

    public String toString() {
        return String.format("%s%s%s", this.getLeft(), TOKEN_PHRASE, this.getRight());
    }

    private List<Posting> orderedUnion(List<Posting> left, List<Posting> right) {
        HashSet<Posting> orderedUnion = new HashSet<Posting>();
        for (Posting postingLeft : left) {
            Integer[] integerArray = postingLeft.getPositions();
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int positionLeft = integerArray[i];
                for (Posting postingRight : right) {
                    if (!postingLeft.getDocId().equals(postingRight.getDocId())) continue;
                    Integer[] integerArray2 = postingRight.getPositions();
                    int n2 = integerArray2.length;
                    for (int j = 0; j < n2; ++j) {
                        int positionRight = integerArray2[j];
                        if (positionRight - positionLeft != 1) continue;
                        orderedUnion.add(postingLeft);
                        orderedUnion.add(postingRight);
                    }
                }
            }
        }
        return new ArrayList<Posting>(orderedUnion);
    }
}

