/*
 * Decompiled with CFR 0.152.
 */
package core.query.parser;

import core.parser.Parser;
import core.parser.processor.IProcessor;
import core.parser.processor.string.DigitFilter;
import core.parser.processor.string.Lowercaser;
import core.parser.processor.string.PunctuationProcessor;
import core.parser.processor.string.Stemmer;
import core.parser.processor.string.StopWordFilter;
import core.query.Query;
import core.query.node.And;
import core.query.node.Leaf;
import core.query.node.Or;
import core.query.node.Phrase;
import core.query.parser.StandardQueryTokenizer;
import java.util.regex.Pattern;

public class StandardQueryParser
extends Parser<String, Query> {
    private static final String[] ALLOWED_TOKENS = new String[]{Pattern.quote(And.TOKEN_AND.toString()), Pattern.quote(Or.TOKEN_OR.toString()), Pattern.quote(Phrase.TOKEN_PHRASE.toString())};

    public StandardQueryParser() {
        super(new IProcessor[]{new PunctuationProcessor(ALLOWED_TOKENS), new Lowercaser()}, new StandardQueryTokenizer(), new IProcessor[]{new PostProcessor()});
    }

    private static class PostProcessor
    implements IProcessor<Query> {
        IProcessor[] processors = new IProcessor[]{new DigitFilter(), new StopWordFilter(), new Stemmer()};

        private PostProcessor() {
        }

        @Override
        public Query process(Query in) {
            if (in instanceof Leaf) {
                String term = in.getTerm();
                for (IProcessor postProcessor : this.processors) {
                    term = postProcessor.process(term);
                }
                return new Leaf(term);
            }
            if (in instanceof And) {
                return new And(this.process(in.getLeft()), this.process(in.getRight()));
            }
            if (in instanceof Or) {
                return new Or(this.process(in.getLeft()), this.process(in.getRight()));
            }
            if (in instanceof Phrase) {
                return new Phrase(this.process(in.getLeft()), this.process(in.getRight()));
            }
            return in;
        }
    }
}

