/*
 * Decompiled with CFR 0.152.
 */
package core.search;

import core.search.Record;
import core.search.Zone;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Indexer {
    private final Map<String, Zone> zonesByName = new HashMap<String, Zone>();

    private Indexer(Set<Zone> zones) {
        for (Zone zone : zones) {
            this.zonesByName.put(zone.getName(), zone);
        }
    }

    public void add(Record record) {
        Map<String, Object> recordData = record.getDataByZoneName();
        for (String zoneName : recordData.keySet()) {
            if (!this.zonesByName.containsKey(zoneName)) continue;
            this.zonesByName.get(zoneName).index(recordData.get(zoneName), record.getDocId());
        }
    }

    public Set<Zone> getZones() {
        return new HashSet<Zone>(this.zonesByName.values());
    }

    public static class Builder {
        private Set<Zone> zones = new HashSet<Zone>();

        public Builder addZone(Zone zone) {
            this.zones.add(zone);
            return this;
        }

        public Indexer build() {
            return new Indexer(this.zones);
        }
    }
}

