/*
 * Decompiled with CFR 0.152.
 */
package core.search.zones.textzone;

import core.DocId;
import core.parser.Parser;
import core.query.Query;
import core.search.Zone;
import core.search.zones.textzone.positionalindex.IPositionalIndex;
import core.search.zones.textzone.positionalindex.Posting;
import core.vectorizer.TfIdfVectorizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kotlin.Pair;

public class TextZone
extends Zone<String> {
    private final IPositionalIndex positionalIndex;
    private final Parser<String, Query> queryParser;
    private final Parser<String, String> textParser;
    private final TfIdfVectorizer vectorizer;

    public TextZone(String name, IPositionalIndex positionalIndex, Parser<String, Query> queryParser, Parser<String, String> textParser) {
        super(name);
        this.positionalIndex = positionalIndex;
        this.queryParser = queryParser;
        this.textParser = textParser;
        this.vectorizer = new TfIdfVectorizer();
    }

    @Override
    public void index(String data, DocId docId) {
        List<String> parsed = this.textParser.parse(data);
        for (int i = 0; i < parsed.size(); ++i) {
            this.positionalIndex.add(parsed.get(i), i, docId);
        }
    }

    @Override
    public List<Pair<DocId, Double>> match(String query) {
        List<Query> parsed = this.queryParser.parse(query);
        List<Posting> postingList = parsed.get(0).match(this.positionalIndex);
        List<String> terms = this.textParser.parse(query);
        String[] termsArray = new String[terms.size()];
        terms.toArray(termsArray);
        Double[] queryVector = this.vectorizer.vectorize(termsArray, this.positionalIndex);
        ArrayList<Pair<DocId, Double>> matches = new ArrayList<Pair<DocId, Double>>();
        for (Posting posting : postingList) {
            Double[] docVector = this.vectorizer.vectorize(posting.getDocId(), this.positionalIndex);
            double score = this.getCosineAngle(queryVector, docVector);
            matches.add((Pair<DocId, Double>)new Pair((Object)posting.getDocId(), (Object)score));
        }
        Collections.sort(matches, new Comparator<Pair<DocId, Double>>(){

            @Override
            public int compare(Pair<DocId, Double> o1, Pair<DocId, Double> o2) {
                return ((Double)o2.getSecond()).compareTo((Double)o1.getSecond());
            }
        });
        return matches;
    }

    private double getCosineAngle(Double[] vecA, Double[] vecB) {
        int vecLength = vecA.length;
        double dotProduct = 0.0;
        for (int i = 0; i < vecLength; ++i) {
            dotProduct += vecA[i] * vecB[i];
        }
        return dotProduct;
    }
}

