/*
 * Decompiled with CFR 0.152.
 */
package core.search.zones.textzone.positionalindex;

import core.DocId;
import core.search.zones.textzone.positionalindex.IPositionalIndex;
import core.search.zones.textzone.positionalindex.Posting;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;

public class InMemoryPositionalIndex
implements IPositionalIndex {
    private final Map<String, PriorityQueue<Posting>> index = new LinkedHashMap<String, PriorityQueue<Posting>>();
    private final Set<DocId> docIdSet = new HashSet<DocId>();

    @Override
    public void add(String key, int position, DocId docId) {
        if (!this.index.containsKey(key)) {
            this.index.put(key, new PriorityQueue());
        }
        PriorityQueue<Posting> postings = this.index.get(key);
        Iterator<Posting> iterator = postings.iterator();
        this.docIdSet.add(docId);
        boolean found = false;
        while (iterator.hasNext()) {
            Posting posting = iterator.next();
            if (!posting.getDocId().equals(docId)) continue;
            if (Arrays.binarySearch((Object[])posting.getPositions(), (Object)position) < 0) {
                posting.addPosition(position);
            }
            found = true;
            break;
        }
        if (!found) {
            PriorityQueue<Integer> positions = new PriorityQueue<Integer>();
            positions.add(position);
            postings.add(new Posting(docId, positions));
        }
    }

    @Override
    public Posting[] get(String key) {
        PriorityQueue<Posting> postings = this.index.get(key);
        if (postings == null) {
            return new Posting[0];
        }
        Posting[] postingArr = new Posting[postings.size()];
        int ndx = 0;
        while (!postings.isEmpty()) {
            postingArr[ndx] = postings.poll();
            ++ndx;
        }
        for (Posting posting : postingArr) {
            postings.add(posting);
        }
        return postingArr;
    }

    @Override
    public int getNumDocuments() {
        return this.docIdSet.size();
    }

    @Override
    public String[] getKeys() {
        String[] keys = new String[this.index.size()];
        Set<String> keySet = this.index.keySet();
        int ndx = 0;
        Iterator<String> iterator = keySet.iterator();
        while (iterator.hasNext()) {
            keys[ndx] = iterator.next();
            ++ndx;
        }
        return keys;
    }
}

