/*
 * Decompiled with CFR 0.152.
 */
package example;

import core.DocId;
import core.query.parser.StandardQueryParser;
import core.search.Indexer;
import core.search.Record;
import core.search.Search;
import core.search.zones.textzone.StandardTextParser;
import core.search.zones.textzone.TextZone;
import core.search.zones.textzone.positionalindex.InMemoryPositionalIndex;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Pair;

public class WikipediaSearchExample {
    private static final String CORPUS_SOURCE = "https://corpus.byu.edu/wikitext-samples/text.zip";
    private static final String ZIPPED_FILE_NAME = "text.zip";
    private static final String UNZIPPED_FILE_NAME = "text.txt";

    public static void main(String[] args) throws IOException {
        File zippedFile = new File(ZIPPED_FILE_NAME);
        File unzippedFile = new File(UNZIPPED_FILE_NAME);
        if (!zippedFile.exists()) {
            WikipediaSearchExample.downloadCorpus(zippedFile);
        }
        if (!unzippedFile.exists()) {
            WikipediaSearchExample.unzipCorpus(zippedFile, unzippedFile);
        }
        System.out.printf("Building index...\n\n", new Object[0]);
        Indexer indexer = new Indexer.Builder().addZone(new TextZone("content", new InMemoryPositionalIndex(), new StandardQueryParser(), new StandardTextParser())).build();
        Scanner scanner = new Scanner(new File(UNZIPPED_FILE_NAME));
        scanner.nextLine();
        scanner.nextLine();
        scanner.nextLine();
        HashMap<DocId, String> contentToDocId = new HashMap<DocId, String>();
        DocId docId = null;
        while (scanner.hasNextLine()) {
            String content = scanner.nextLine();
            if (!content.startsWith("@@")) continue;
            if (docId != null) {
                HashMap<String, String> recordData = new HashMap<String, String>();
                recordData.put("content", content);
                Record record = new Record(docId, recordData);
                indexer.add(record);
                contentToDocId.put(docId, content);
            }
            docId = new DocId(Integer.parseInt(content.substring(2, content.indexOf(" "))));
        }
        Scanner stdin = new Scanner(System.in);
        Search search = Search.Companion.fromIndexer(indexer);
        block1: while (true) {
            System.out.printf("? ", new Object[0]);
            String terms = stdin.nextLine();
            HashMap<String, String> query = new HashMap<String, String>();
            query.put("content", terms);
            List<Pair<DocId, Double>> docIds = search.search(query, 3);
            Iterator<Pair<DocId, Double>> iterator = docIds.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block1;
                Pair<DocId, Double> result = iterator.next();
                System.out.printf("[%s - %f]\n%s\n---------------------\n\n", ((DocId)result.getFirst()).getId(), (double)((Double)result.getSecond()), contentToDocId.get(result.getFirst()));
            }
            break;
        }
    }

    private static void downloadCorpus(File out) throws IOException {
        System.out.printf("Downloading corpus from %s...\n", CORPUS_SOURCE);
        out.createNewFile();
        URL source = new URL(CORPUS_SOURCE);
        ReadableByteChannel rbc = Channels.newChannel(source.openStream());
        FileOutputStream fileOutputStream = new FileOutputStream(out);
        fileOutputStream.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
    }

    private static void unzipCorpus(File in, File out) throws IOException {
        System.out.printf("Unzipping corpus...\n", CORPUS_SOURCE);
        out.createNewFile();
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(in));
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        byte[] buffer = new byte[1024];
        while (zipEntry != null) {
            int len;
            FileOutputStream fileOutputStream = new FileOutputStream(out);
            while ((len = zipInputStream.read(buffer)) > 0) {
                fileOutputStream.write(buffer, 0, len);
            }
            fileOutputStream.close();
            zipEntry = zipInputStream.getNextEntry();
        }
        zipInputStream.closeEntry();
        zipInputStream.close();
    }
}

