/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard;

import com.pinterest.ktlint.core.IndentConfig;
import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.api.DefaultEditorConfigProperties;
import com.pinterest.ktlint.core.api.UsesEditorConfigProperties;
import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.ec4j.core.model.Property;
import org.ec4j.core.model.PropertyType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\f\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\r\u001a\u00020\u000e2\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fj\u0002`\u0012H\u0016Je\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172K\u0010\u0018\u001aG\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u000e0\u0019H\u0016J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002Jm\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u00152K\u0010\u0018\u001aG\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u000e0\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\f\u0010#\u001a\u00020\u0017*\u00020\u0015H\u0002J\f\u0010$\u001a\u00020\f*\u00020\u0015H\u0002J\f\u0010%\u001a\u00020\u0017*\u00020\u0015H\u0002J\f\u0010&\u001a\u00020\u0017*\u00020\u0015H\u0002J\f\u0010'\u001a\u00020\u0017*\u00020\u0015H\u0002J\u000e\u0010(\u001a\u0004\u0018\u00010\u0015*\u00020\u0015H\u0002J\u0014\u0010)\u001a\u00020\u0017*\u00020\u00152\u0006\u0010*\u001a\u00020+H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/ArgumentListWrappingRule;", "Lcom/pinterest/ktlint/core/Rule;", "Lcom/pinterest/ktlint/core/api/UsesEditorConfigProperties;", "()V", "editorConfigIndent", "Lcom/pinterest/ktlint/core/IndentConfig;", "editorConfigProperties", "", "Lcom/pinterest/ktlint/core/api/UsesEditorConfigProperties$EditorConfigProperty;", "getEditorConfigProperties", "()Ljava/util/List;", "maxLineLength", "", "beforeFirstNode", "", "", "", "Lorg/ec4j/core/model/Property;", "Lcom/pinterest/ktlint/core/api/EditorConfigProperties;", "beforeVisitChildNodes", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "offset", "errorMessage", "canBeAutoCorrected", "needToWrapArgumentList", "wrapArgumentInList", "newIndentLevel", "child", "exceedsMaxLineLength", "getNewIndentLevel", "hasTypeArgumentListInFront", "isOnSameLineAsControlFlowKeyword", "isPartOfDotQualifiedAssignmentExpression", "prevWhiteSpaceWithNewLine", "textContainsIgnoringLambda", "char", "", "ktlint-ruleset-standard"})
public final class ArgumentListWrappingRule
extends Rule
implements UsesEditorConfigProperties {
    @NotNull
    private final List<UsesEditorConfigProperties.EditorConfigProperty<?>> editorConfigProperties;
    @NotNull
    private IndentConfig editorConfigIndent;
    private int maxLineLength;

    public ArgumentListWrappingRule() {
        super("argument-list-wrapping", null, 2, null);
        Object[] objectArray = new UsesEditorConfigProperties.EditorConfigProperty[]{DefaultEditorConfigProperties.INSTANCE.getIndentSizeProperty(), DefaultEditorConfigProperties.INSTANCE.getIndentStyleProperty(), DefaultEditorConfigProperties.INSTANCE.getMaxLineLengthProperty()};
        this.editorConfigProperties = CollectionsKt.listOf((Object[])objectArray);
        this.editorConfigIndent = IndentConfig.Companion.getDEFAULT_INDENT_CONFIG();
        this.maxLineLength = -1;
    }

    @NotNull
    public List<UsesEditorConfigProperties.EditorConfigProperty<?>> getEditorConfigProperties() {
        return this.editorConfigProperties;
    }

    public void beforeFirstNode(@NotNull Map<String, ? extends Property> editorConfigProperties) {
        Intrinsics.checkNotNullParameter(editorConfigProperties, (String)"editorConfigProperties");
        this.editorConfigIndent = new IndentConfig((PropertyType.IndentStyleValue)this.getEditorConfigValue(editorConfigProperties, DefaultEditorConfigProperties.INSTANCE.getIndentStyleProperty()), ((Number)this.getEditorConfigValue(editorConfigProperties, DefaultEditorConfigProperties.INSTANCE.getIndentSizeProperty())).intValue());
        this.maxLineLength = ((Number)this.getEditorConfigValue(editorConfigProperties, DefaultEditorConfigProperties.INSTANCE.getMaxLineLengthProperty())).intValue();
    }

    /*
     * WARNING - void declaration
     */
    public void beforeVisitChildNodes(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        if (this.editorConfigIndent.getDisabled()) {
            return;
        }
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getVALUE_ARGUMENT_LIST()) && this.needToWrapArgumentList(node)) {
            void $this$forEach$iv;
            int newIndentLevel = this.getNewIndentLevel(node);
            Sequence sequence = PsiUtilsKt.children((ASTNode)node);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ASTNode child = (ASTNode)element$iv;
                boolean bl = false;
                this.wrapArgumentInList(newIndentLevel, child, emit, autoCorrect);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean needToWrapArgumentList(ASTNode node) {
        ASTNode aSTNode = node.getFirstChildNode();
        if (Intrinsics.areEqual((Object)(aSTNode != null && (aSTNode = aSTNode.getTreeNext()) != null ? aSTNode.getElementType() : null), (Object)ElementType.INSTANCE.getRPAR())) return false;
        ASTNode aSTNode2 = node.getTreeParent();
        if (Intrinsics.areEqual((Object)(aSTNode2 != null ? aSTNode2.getElementType() : null), (Object)ElementType.INSTANCE.getFUNCTION_LITERAL())) return false;
        Sequence $this$count$iv = PsiUtilsKt.children((ASTNode)node);
        boolean $i$f$count = false;
        int count$iv = 0;
        for (Object element$iv : $this$count$iv) {
            ASTNode it = (ASTNode)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getVALUE_ARGUMENT()) || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        if (count$iv > 8) return false;
        if (this.textContainsIgnoringLambda(node, '\n')) return true;
        if (!this.exceedsMaxLineLength(node)) return false;
        return true;
    }

    private final boolean exceedsMaxLineLength(ASTNode $this$exceedsMaxLineLength) {
        return this.maxLineLength > -1 && PackageKt.getColumn((ASTNode)$this$exceedsMaxLineLength) - 1 + $this$exceedsMaxLineLength.getTextLength() > this.maxLineLength && !$this$exceedsMaxLineLength.textContains('\n');
    }

    private final int getNewIndentLevel(ASTNode $this$getNewIndentLevel) {
        int currentIndentLevel = this.editorConfigIndent.indentLevelFrom(PackageKt.lineIndent((ASTNode)$this$getNewIndentLevel));
        int it = currentIndentLevel > 0 && this.hasTypeArgumentListInFront($this$getNewIndentLevel) ? currentIndentLevel - 1 : (currentIndentLevel > 0 && this.isPartOfDotQualifiedAssignmentExpression($this$getNewIndentLevel) ? currentIndentLevel - 1 : currentIndentLevel);
        boolean bl = false;
        return this.isOnSameLineAsControlFlowKeyword($this$getNewIndentLevel) ? it + 1 : it;
    }

    private final void wrapArgumentInList(int newIndentLevel, ASTNode child, Function3<? super Integer, ? super String, ? super Boolean, Unit> emit, boolean autoCorrect) {
        String indent = '\n' + StringsKt.repeat((CharSequence)this.editorConfigIndent.getIndent(), (int)newIndentLevel);
        IElementType iElementType = child.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getLPAR())) {
            ASTNode prevLeaf2 = PackageKt.prevLeaf$default((ASTNode)child, (boolean)false, (int)1, null);
            if (prevLeaf2 instanceof PsiWhiteSpace && prevLeaf2.textContains('\n')) {
                emit.invoke((Object)child.getStartOffset(), (Object)this.errorMessage(child), (Object)true);
                if (autoCorrect) {
                    ((PsiWhiteSpace)prevLeaf2).delete();
                }
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getVALUE_ARGUMENT()) ? true : Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getRPAR())) {
            ASTNode prevLeaf3;
            String intendedIndent = Intrinsics.areEqual((Object)child.getElementType(), (Object)ElementType.INSTANCE.getVALUE_ARGUMENT()) ? indent + this.editorConfigIndent.getIndent() : indent;
            ASTNode aSTNode = this.prevWhiteSpaceWithNewLine(child);
            if (aSTNode == null) {
                aSTNode = PackageKt.prevLeaf$default((ASTNode)child, (boolean)false, (int)1, null);
            }
            if ((prevLeaf3 = aSTNode) instanceof PsiWhiteSpace) {
                String string = prevLeaf3.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"prevLeaf.getText()");
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null)) {
                    return;
                }
                emit.invoke((Object)child.getStartOffset(), (Object)this.errorMessage(child), (Object)true);
                if (autoCorrect) {
                    ((LeafPsiElement)prevLeaf3).rawReplaceWithText(intendedIndent);
                }
            } else {
                emit.invoke((Object)child.getStartOffset(), (Object)this.errorMessage(child), (Object)true);
                if (autoCorrect) {
                    child.getTreeParent().addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)intendedIndent), child);
                }
            }
        }
    }

    private final String errorMessage(ASTNode node) {
        String string;
        IElementType iElementType = node.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getLPAR())) {
            string = "Unnecessary newline before \"(\"";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getVALUE_ARGUMENT())) {
            string = "Argument should be on a separate line (unless all arguments can fit a single line)";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getRPAR())) {
            string = "Missing newline before \")\"";
        } else {
            throw new UnsupportedOperationException();
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean textContainsIgnoringLambda(ASTNode $this$textContainsIgnoringLambda, char c) {
        boolean bl;
        Sequence $this$any$iv = PsiUtilsKt.children((ASTNode)$this$textContainsIgnoringLambda);
        boolean $i$f$any = false;
        Iterator iterator = $this$any$iv.iterator();
        do {
            IElementType elementType;
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            ASTNode child = (ASTNode)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)child.getElementType(), (String)"child.elementType");
            if (Intrinsics.areEqual((Object)elementType, (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                if (child.textContains(c)) return true;
            }
            if (Intrinsics.areEqual((Object)elementType, (Object)ElementType.INSTANCE.getCOLLECTION_LITERAL_EXPRESSION())) {
                if (child.textContains(c)) return true;
            }
            if (Intrinsics.areEqual((Object)elementType, (Object)ElementType.INSTANCE.getVALUE_ARGUMENT())) {
                Sequence $this$any$iv2 = PsiUtilsKt.children((ASTNode)child);
                boolean $i$f$any2 = false;
                for (Object element$iv2 : $this$any$iv2) {
                    ASTNode it = (ASTNode)element$iv2;
                    boolean bl3 = false;
                    if (!this.textContainsIgnoringLambda(it, c)) continue;
                    return true;
                }
                boolean bl4 = false;
                if (bl4) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasTypeArgumentListInFront(ASTNode $this$hasTypeArgumentListInFront) {
        boolean bl;
        Sequence sequence;
        Object v1;
        block4: {
            ASTNode aSTNode = $this$hasTypeArgumentListInFront.getTreeParent();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"treeParent");
            Sequence $this$firstOrNull$iv = PsiUtilsKt.children((ASTNode)aSTNode);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getTYPE_ARGUMENT_LIST())) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        ASTNode aSTNode = v1;
        if (aSTNode != null && (sequence = PsiUtilsKt.children((ASTNode)aSTNode)) != null) {
            boolean bl3;
            block5: {
                void $this$any$iv;
                Sequence $i$f$firstOrNull = sequence;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    ASTNode it = (ASTNode)element$iv;
                    boolean bl4 = false;
                    if (!PackageKt.isWhiteSpaceWithNewline((ASTNode)it)) continue;
                    bl3 = true;
                    break block5;
                }
                bl3 = false;
            }
            bl = bl3;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPartOfDotQualifiedAssignmentExpression(ASTNode $this$isPartOfDotQualifiedAssignmentExpression) {
        Object v5;
        block1: {
            ASTNode aSTNode = $this$isPartOfDotQualifiedAssignmentExpression.getTreeParent();
            if (!Intrinsics.areEqual((Object)(aSTNode != null && (aSTNode = aSTNode.getTreeParent()) != null ? aSTNode.getElementType() : null), (Object)ElementType.INSTANCE.getBINARY_EXPRESSION())) return false;
            ASTNode aSTNode2 = $this$isPartOfDotQualifiedAssignmentExpression.getTreeParent();
            ASTNode aSTNode3 = aSTNode2;
            if (aSTNode2 == null) return false;
            ASTNode aSTNode4 = aSTNode3.getTreeParent();
            aSTNode3 = aSTNode4;
            if (aSTNode4 == null) return false;
            Sequence sequence = PsiUtilsKt.children((ASTNode)aSTNode3);
            aSTNode3 = sequence;
            if (sequence == null) return false;
            ASTNode aSTNode5 = aSTNode3;
            for (Object e : aSTNode5) {
                ASTNode it = (ASTNode)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getDOT_QUALIFIED_EXPRESSION())) continue;
                v5 = e;
                break block1;
            }
            v5 = null;
        }
        ASTNode aSTNode = v5;
        if (aSTNode == null) return false;
        return true;
    }

    private final ASTNode prevWhiteSpaceWithNewLine(ASTNode $this$prevWhiteSpaceWithNewLine) {
        ASTNode prev = PackageKt.prevLeaf$default((ASTNode)$this$prevWhiteSpaceWithNewLine, (boolean)false, (int)1, null);
        while (prev != null && (PackageKt.isWhiteSpace((ASTNode)prev) || PackageKt.isPartOfComment((ASTNode)prev))) {
            if (PackageKt.isWhiteSpaceWithNewline((ASTNode)prev)) {
                return prev;
            }
            prev = PackageKt.prevLeaf$default((ASTNode)prev, (boolean)false, (int)1, null);
        }
        return null;
    }

    private final boolean isOnSameLineAsControlFlowKeyword(ASTNode $this$isOnSameLineAsControlFlowKeyword) {
        Object object;
        PsiElement psiElement = $this$isOnSameLineAsControlFlowKeyword.getPsi();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"psi");
        PsiElement $this$getStrictParentOfType$iv = psiElement;
        boolean $i$f$getStrictParentOfType = false;
        KtContainerNode ktContainerNode = (KtContainerNode)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtContainerNode.class, (boolean)true);
        if (ktContainerNode == null) {
            return false;
        }
        KtContainerNode containerNode = ktContainerNode;
        if (Intrinsics.areEqual((Object)containerNode.getNode().getElementType(), (Object)ElementType.INSTANCE.getELSE())) {
            return false;
        }
        PsiElement parent = containerNode.getParent();
        if (parent instanceof KtIfExpression) {
            object = ((KtIfExpression)parent).getIfKeyword().getNode();
        } else if (parent instanceof KtWhileExpression) {
            object = ((KtWhileExpression)parent).getFirstChild().getNode();
        } else if (parent instanceof KtDoWhileExpression) {
            PsiElement psiElement2 = ((KtDoWhileExpression)parent).getWhileKeyword();
            object = psiElement2 != null ? psiElement2.getNode() : null;
        } else {
            object = null;
        }
        if (object == null) {
            return false;
        }
        ASTNode controlFlowKeyword = object;
        ASTNode aSTNode = PackageKt.prevLeaf$default((ASTNode)$this$isOnSameLineAsControlFlowKeyword, (boolean)false, (int)1, null);
        if (aSTNode == null) {
            return false;
        }
        ASTNode prevLeaf2 = aSTNode;
        while (!Intrinsics.areEqual((Object)prevLeaf2, (Object)controlFlowKeyword)) {
            if (PackageKt.isWhiteSpaceWithNewline((ASTNode)prevLeaf2)) {
                return false;
            }
            if (PackageKt.prevLeaf$default((ASTNode)prevLeaf2, (boolean)false, (int)1, null) != null) continue;
            return false;
        }
        return true;
    }

    public <T> T getEditorConfigValue(@NotNull Map<String, ? extends Property> $this$getEditorConfigValue, @NotNull UsesEditorConfigProperties.EditorConfigProperty<T> editorConfigProperty) {
        return (T)UsesEditorConfigProperties.DefaultImpls.getEditorConfigValue((UsesEditorConfigProperties)this, $this$getEditorConfigValue, editorConfigProperty);
    }

    @Deprecated(message="Marked for deletion in Ktlint 0.48. EditorConfigProperties are now supplied to Rule via call on method beforeFirstNode")
    public <T> T getEditorConfigValue(@NotNull ASTNode $this$getEditorConfigValue, @NotNull UsesEditorConfigProperties.EditorConfigProperty<T> editorConfigProperty) {
        return (T)UsesEditorConfigProperties.DefaultImpls.getEditorConfigValue((UsesEditorConfigProperties)this, (ASTNode)$this$getEditorConfigValue, editorConfigProperty);
    }

    @NotNull
    public <T> String writeEditorConfigProperty(@NotNull Map<String, ? extends Property> $this$writeEditorConfigProperty, @NotNull UsesEditorConfigProperties.EditorConfigProperty<T> editorConfigProperty, @NotNull DefaultEditorConfigProperties.CodeStyleValue codeStyleValue) {
        return UsesEditorConfigProperties.DefaultImpls.writeEditorConfigProperty((UsesEditorConfigProperties)this, $this$writeEditorConfigProperty, editorConfigProperty, (DefaultEditorConfigProperties.CodeStyleValue)codeStyleValue);
    }
}

