/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard;

import com.pinterest.ktlint.core.KtLintKLoggerInitializerKt;
import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import com.pinterest.ktlint.ruleset.standard.IndentationRuleKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\f\u0010\u0002\u001a\u00020\u0003*\u00020\u0003H\u0002\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0003H\u0002\u001a\f\u0010\u0006\u001a\u00020\u0005*\u00020\u0003H\u0002\u001a\u0014\u0010\u0007\u001a\u00020\u0005*\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\f\u0010\u000b\u001a\u00020\u0005*\u00020\bH\u0002\u001a\f\u0010\f\u001a\u00020\u0005*\u00020\bH\u0002\u001a\f\u0010\r\u001a\u00020\u0005*\u00020\u0003H\u0002\u001a\f\u0010\u000e\u001a\u00020\u0005*\u00020\u0003H\u0002\u001a\f\u0010\u000f\u001a\u00020\u0005*\u00020\u0003H\u0002\u001a\f\u0010\u0010\u001a\u00020\u0005*\u00020\u0003H\u0002\u001a\f\u0010\u0011\u001a\u00020\u0005*\u00020\u0003H\u0002\u001a\f\u0010\u0012\u001a\u00020\u0005*\u00020\nH\u0002\u001a \u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0014*\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"logger", "Lmu/KLogger;", "getFirstElementOnSameLine", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "isClosingQuote", "", "isFirstNonBlankElementOnLine", "isFollowedBy", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "callExpressionName", "", "isFollowedByTrimIndent", "isFollowedByTrimMargin", "isIndentBeforeClosingQuote", "isKDocIndent", "isLiteralStringTemplateEntry", "isPartOfForLoopConditionWithMultilineExpression", "isVariableStringTemplateEntry", "isWhitespace", "splitIndentAt", "Lkotlin/Pair;", "index", "", "ktlint-ruleset-standard"})
public final class IndentationRuleKt {
    @NotNull
    private static final KLogger logger = KtLintKLoggerInitializerKt.initKtLintKLogger((KLogger)KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE));

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isKDocIndent(ASTNode $this$isKDocIndent) {
        String string = $this$isKDocIndent.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
        Character c = StringsKt.lastOrNull((CharSequence)string);
        char c2 = ' ';
        if (c == null) return false;
        if (c.charValue() != c2) return false;
        ASTNode aSTNode = PackageKt.nextLeaf$default((ASTNode)$this$isKDocIndent, (boolean)false, (boolean)false, (int)3, null);
        if (Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)ElementType.INSTANCE.getKDOC_LEADING_ASTERISK())) return true;
        ASTNode aSTNode2 = PackageKt.nextLeaf$default((ASTNode)$this$isKDocIndent, (boolean)false, (boolean)false, (int)3, null);
        if (!Intrinsics.areEqual((Object)(aSTNode2 != null ? aSTNode2.getElementType() : null), (Object)ElementType.INSTANCE.getKDOC_END())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isIndentBeforeClosingQuote(ASTNode $this$isIndentBeforeClosingQuote) {
        if (Intrinsics.areEqual((Object)$this$isIndentBeforeClosingQuote.getElementType(), (Object)ElementType.INSTANCE.getCLOSING_QUOTE())) return true;
        String string = $this$isIndentBeforeClosingQuote.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
        if (!StringsKt.isBlank((CharSequence)string)) return false;
        ASTNode aSTNode = PackageKt.nextCodeSibling((ASTNode)$this$isIndentBeforeClosingQuote);
        if (!Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)ElementType.INSTANCE.getCLOSING_QUOTE())) return false;
        return true;
    }

    private static final boolean isLiteralStringTemplateEntry(ASTNode $this$isLiteralStringTemplateEntry) {
        return Intrinsics.areEqual((Object)$this$isLiteralStringTemplateEntry.getElementType(), (Object)ElementType.INSTANCE.getLITERAL_STRING_TEMPLATE_ENTRY()) && !Intrinsics.areEqual((Object)$this$isLiteralStringTemplateEntry.getText(), (Object)"\n");
    }

    private static final boolean isVariableStringTemplateEntry(ASTNode $this$isVariableStringTemplateEntry) {
        return Intrinsics.areEqual((Object)$this$isVariableStringTemplateEntry.getElementType(), (Object)ElementType.INSTANCE.getLONG_STRING_TEMPLATE_ENTRY()) || Intrinsics.areEqual((Object)$this$isVariableStringTemplateEntry.getElementType(), (Object)ElementType.INSTANCE.getSHORT_STRING_TEMPLATE_ENTRY());
    }

    private static final boolean isClosingQuote(ASTNode $this$isClosingQuote) {
        return Intrinsics.areEqual((Object)$this$isClosingQuote.getElementType(), (Object)ElementType.INSTANCE.getCLOSING_QUOTE());
    }

    private static final boolean isFirstNonBlankElementOnLine(ASTNode $this$isFirstNonBlankElementOnLine) {
        ASTNode node = IndentationRuleKt.getFirstElementOnSameLine($this$isFirstNonBlankElementOnLine);
        while (node != null && !Intrinsics.areEqual((Object)node, (Object)$this$isFirstNonBlankElementOnLine)) {
            String string = node.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.text");
            if (!IndentationRuleKt.isWhitespace(string)) break;
            node = PackageKt.nextLeaf$default((ASTNode)node, (boolean)false, (boolean)false, (int)3, null);
        }
        return !Intrinsics.areEqual((Object)node, (Object)$this$isFirstNonBlankElementOnLine);
    }

    private static final boolean isWhitespace(String $this$isWhitespace) {
        boolean bl;
        block1: {
            CharSequence $this$none$iv = $this$isWhitespace;
            boolean $i$f$none = false;
            for (int i = 0; i < $this$none$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$none$iv.charAt(i);
                boolean bl2 = false;
                if (!(!CharsKt.isWhitespace((char)it))) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    private static final ASTNode getFirstElementOnSameLine(ASTNode $this$getFirstElementOnSameLine) {
        ASTNode aSTNode;
        ASTNode firstLeafOnLine2 = PackageKt.prevLeaf((ASTNode)$this$getFirstElementOnSameLine, (Function1)getFirstElementOnSameLine.firstLeafOnLine.1.INSTANCE);
        if (firstLeafOnLine2 == null) {
            aSTNode = $this$getFirstElementOnSameLine;
        } else {
            aSTNode = PackageKt.nextLeaf$default((ASTNode)firstLeafOnLine2, (boolean)true, (boolean)false, (int)2, null);
            if (aSTNode == null) {
                aSTNode = $this$getFirstElementOnSameLine;
            }
        }
        return aSTNode;
    }

    private static final Pair<String, String> splitIndentAt(String $this$splitIndentAt, int index) {
        int n;
        block2: {
            boolean bl;
            boolean bl2 = bl = index >= 0;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            CharSequence $this$indexOfFirst$iv = $this$splitIndentAt;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl3 = false;
                if (!(!CharsKt.isWhitespace((char)it))) continue;
                n = index$iv;
                break block2;
            }
            n = -1;
        }
        int it = n;
        boolean bl = false;
        int firstNonWhitespaceIndex = it == -1 ? $this$splitIndentAt.length() : it;
        int safeIndex = Math.min(firstNonWhitespaceIndex, index);
        String string = StringsKt.take((String)$this$splitIndentAt, (int)safeIndex);
        String string2 = $this$splitIndentAt.substring(safeIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        return new Pair((Object)string, (Object)string2);
    }

    private static final boolean isFollowedByTrimIndent(KtStringTemplateExpression $this$isFollowedByTrimIndent) {
        return IndentationRuleKt.isFollowedBy($this$isFollowedByTrimIndent, "trimIndent()");
    }

    private static final boolean isFollowedByTrimMargin(KtStringTemplateExpression $this$isFollowedByTrimMargin) {
        return IndentationRuleKt.isFollowedBy($this$isFollowedByTrimMargin, "trimMargin()");
    }

    private static final boolean isFollowedBy(KtStringTemplateExpression $this$isFollowedBy, String callExpressionName) {
        ASTNode aSTNode;
        block1: {
            ASTNode aSTNode2 = $this$isFollowedBy.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"this.node");
            ASTNode $this$nextSibling$iv = aSTNode2;
            boolean $i$f$nextSibling = false;
            for (ASTNode n$iv = $this$nextSibling$iv.getTreeNext(); n$iv != null; n$iv = n$iv.getTreeNext()) {
                ASTNode it = n$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getDOT()))) continue;
                aSTNode = n$iv;
                break block1;
            }
            aSTNode = null;
        }
        ASTNode it = aSTNode;
        boolean bl = false;
        ASTNode aSTNode3 = it;
        return Intrinsics.areEqual((Object)(aSTNode3 != null ? aSTNode3.getElementType() : null), (Object)ElementType.INSTANCE.getCALL_EXPRESSION()) && Intrinsics.areEqual((Object)it.getText(), (Object)callExpressionName);
    }

    private static final boolean isPartOfForLoopConditionWithMultilineExpression(ASTNode $this$isPartOfForLoopConditionWithMultilineExpression) {
        if (!Intrinsics.areEqual((Object)$this$isPartOfForLoopConditionWithMultilineExpression.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getFOR())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)$this$isPartOfForLoopConditionWithMultilineExpression.getElementType(), (Object)ElementType.INSTANCE.getLPAR())) {
            ASTNode aSTNode = $this$isPartOfForLoopConditionWithMultilineExpression.getTreeParent().findChildByType(ElementType.INSTANCE.getLPAR());
            Intrinsics.checkNotNull((Object)aSTNode);
            return IndentationRuleKt.isPartOfForLoopConditionWithMultilineExpression(aSTNode);
        }
        if (!Intrinsics.areEqual((Object)$this$isPartOfForLoopConditionWithMultilineExpression.getElementType(), (Object)ElementType.INSTANCE.getLPAR())) {
            boolean $i$a$-require-IndentationRuleKt$isPartOfForLoopConditionWithMultilineExpression$22 = false;
            String $i$a$-require-IndentationRuleKt$isPartOfForLoopConditionWithMultilineExpression$22 = "Node should be the LPAR of the FOR loop";
            throw new IllegalArgumentException($i$a$-require-IndentationRuleKt$isPartOfForLoopConditionWithMultilineExpression$22.toString());
        }
        ASTNode node = $this$isPartOfForLoopConditionWithMultilineExpression;
        while (node != null && !Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getRPAR())) {
            ASTNode aSTNode;
            block6: {
                if (PackageKt.isWhiteSpaceWithNewline((ASTNode)node)) {
                    return true;
                }
                ASTNode $this$nextSibling$iv = node;
                boolean $i$f$nextSibling = false;
                for (ASTNode n$iv = $this$nextSibling$iv.getTreeNext(); n$iv != null; n$iv = n$iv.getTreeNext()) {
                    ASTNode it = n$iv;
                    boolean bl = false;
                    if (!true) continue;
                    aSTNode = n$iv;
                    break block6;
                }
                aSTNode = null;
            }
            node = aSTNode;
        }
        return false;
    }

    public static final /* synthetic */ KLogger access$getLogger$p() {
        return logger;
    }

    public static final /* synthetic */ boolean access$isPartOfForLoopConditionWithMultilineExpression(ASTNode $receiver) {
        return IndentationRuleKt.isPartOfForLoopConditionWithMultilineExpression($receiver);
    }

    public static final /* synthetic */ boolean access$isKDocIndent(ASTNode $receiver) {
        return IndentationRuleKt.isKDocIndent($receiver);
    }

    public static final /* synthetic */ Pair access$splitIndentAt(String $receiver, int index) {
        return IndentationRuleKt.splitIndentAt($receiver, index);
    }

    public static final /* synthetic */ boolean access$isFollowedByTrimIndent(KtStringTemplateExpression $receiver) {
        return IndentationRuleKt.isFollowedByTrimIndent($receiver);
    }

    public static final /* synthetic */ boolean access$isFollowedByTrimMargin(KtStringTemplateExpression $receiver) {
        return IndentationRuleKt.isFollowedByTrimMargin($receiver);
    }

    public static final /* synthetic */ boolean access$isIndentBeforeClosingQuote(ASTNode $receiver) {
        return IndentationRuleKt.isIndentBeforeClosingQuote($receiver);
    }

    public static final /* synthetic */ boolean access$isLiteralStringTemplateEntry(ASTNode $receiver) {
        return IndentationRuleKt.isLiteralStringTemplateEntry($receiver);
    }

    public static final /* synthetic */ boolean access$isVariableStringTemplateEntry(ASTNode $receiver) {
        return IndentationRuleKt.isVariableStringTemplateEntry($receiver);
    }

    public static final /* synthetic */ boolean access$isClosingQuote(ASTNode $receiver) {
        return IndentationRuleKt.isClosingQuote($receiver);
    }

    public static final /* synthetic */ boolean access$isFirstNonBlankElementOnLine(ASTNode $receiver) {
        return IndentationRuleKt.isFirstNonBlankElementOnLine($receiver);
    }

    public static final /* synthetic */ ASTNode access$getFirstElementOnSameLine(ASTNode $receiver) {
        return IndentationRuleKt.getFirstElementOnSameLine($receiver);
    }
}

