/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur;

import com.simsilica.lemur.Action;
import com.simsilica.lemur.Button;
import com.simsilica.lemur.Command;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;

public class ActionButton
extends Button {
    private Action action;
    private VersionedReference<Action> actionRef;

    public ActionButton(Action action) {
        this(action, new ElementId("button"), null);
    }

    public ActionButton(Action action, String style) {
        this(action, new ElementId("button"), style);
    }

    public ActionButton(Action action, ElementId elementId) {
        this(action, elementId, null);
    }

    public ActionButton(Action action, ElementId elementId, String style) {
        super(action.getName(), elementId, style);
        this.setAction(action);
        this.addClickCommands(new Command[]{new ClickCommand()});
    }

    public final void setAction(Action action) {
        if (this.action == action) {
            return;
        }
        this.action = action;
        this.actionRef = action == null ? null : action.createReference();
        this.updateButton();
    }

    public Action getAction() {
        return this.action;
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        if (this.actionRef != null && this.actionRef.update()) {
            this.updateButton();
        }
    }

    protected void updateButton() {
        this.updateText();
        this.updateEnabled();
        this.updateIcon();
    }

    protected void updateText() {
        this.setText(this.action != null ? this.action.getName() : null);
    }

    protected void updateEnabled() {
        this.setEnabled(this.action != null ? this.action.isEnabled() : false);
    }

    protected void updateIcon() {
        this.setIcon(this.action != null ? this.action.getLargeIcon() : null);
    }

    private class ClickCommand
    implements Command<Button> {
        private ClickCommand() {
        }

        public void execute(Button source) {
            if (ActionButton.this.action != null) {
                ActionButton.this.action.execute(source);
            }
        }
    }
}

