/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur;

import com.jme3.scene.Node;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.grid.GridModel;
import com.simsilica.lemur.style.Attributes;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.style.StyleDefaults;
import com.simsilica.lemur.style.Styles;

public class GridPanel
extends Panel {
    public static final String ELEMENT_ID = "grid";
    private GridModel<Panel> model;
    private VersionedReference<GridModel<Panel>> modelRef;
    private SpringGridLayout layout = new SpringGridLayout(Axis.Y, Axis.X, FillMode.ForcedEven, FillMode.ForcedEven);
    private int visibleRows = 5;
    private int visibleColumns = 5;
    private int row = 0;
    private int column = 0;
    private Float alpha;

    public GridPanel(GridModel<Panel> model) {
        this(true, model, new ElementId(ELEMENT_ID), null);
    }

    public GridPanel(GridModel<Panel> model, String style) {
        this(true, model, new ElementId(ELEMENT_ID), style);
    }

    public GridPanel(GridModel<Panel> model, ElementId elementId, String style) {
        this(true, model, elementId, style);
    }

    protected GridPanel(boolean applyStyles, GridModel<Panel> model, ElementId elementId, String style) {
        super(false, elementId, style);
        ((GuiControl)this.getControl(GuiControl.class)).setLayout((GuiLayout)this.layout);
        if (applyStyles) {
            Styles styles = GuiGlobals.getInstance().getStyles();
            styles.applyStyles((Object)this, elementId.getId(), style);
        }
        this.setModel(model);
    }

    @StyleDefaults(value="grid")
    public static void initializeDefaultStyles(Attributes attrs) {
    }

    public void setModel(GridModel<Panel> model) {
        if (this.model == model) {
            return;
        }
        if (this.model != null) {
            ((GuiControl)this.getControl(GuiControl.class)).getLayout().clearChildren();
            this.modelRef = null;
        }
        this.model = model;
        if (this.model != null) {
            this.modelRef = model.createReference();
            this.refreshGrid();
        }
    }

    public GridModel<Panel> getModel() {
        return this.model;
    }

    public void setRow(int row) {
        this.setLocation(row, this.column);
    }

    public int getRow() {
        return this.row;
    }

    public void setColumn(int column) {
        this.setLocation(this.row, column);
    }

    public int getColumn() {
        return this.column;
    }

    public Panel getCell(int r, int c) {
        if ((r -= this.row) < 0 || (c -= this.column) < 0 || r >= this.visibleRows || c >= this.visibleColumns) {
            return null;
        }
        return (Panel)this.layout.getChild(r, c);
    }

    public void setLocation(int row, int column) {
        if (this.row == row && this.column == column) {
            return;
        }
        this.row = row;
        this.column = column;
        this.refreshGrid();
    }

    public void setVisibleSize(int rows, int columns) {
        this.visibleRows = rows;
        this.visibleColumns = columns;
        ((GuiControl)this.getControl(GuiControl.class)).getLayout().clearChildren();
        this.refreshGrid();
    }

    public void setVisibleRows(int rows) {
        this.setVisibleSize(rows, this.visibleColumns);
    }

    public int getVisibleRows() {
        return this.visibleRows;
    }

    public void setVisibleColumns(int columns) {
        this.setVisibleSize(this.visibleRows, columns);
    }

    public int getVisibleColumns() {
        return this.visibleColumns;
    }

    public void setAlpha(float alpha, boolean recursive) {
        this.alpha = Float.valueOf(alpha);
        super.setAlpha(alpha, recursive);
    }

    protected void refreshGrid() {
        if (this.model == null) {
            ((GuiControl)this.getControl(GuiControl.class)).getLayout().clearChildren();
            return;
        }
        for (int r = this.row; r < this.row + this.visibleRows; ++r) {
            for (int c = this.column; c < this.column + this.visibleColumns; ++c) {
                Node existing = this.layout.getChild(r - this.row, c - this.column);
                if (r < 0 || r >= this.model.getRowCount() || c < 0 || c >= this.model.getColumnCount()) {
                    this.layout.addChild(null, new Object[]{r - this.row, c - this.column});
                    continue;
                }
                Panel child = this.model.getCell(r, c, (Panel)existing);
                if (child == existing) continue;
                if (this.alpha != null && this.alpha.floatValue() != 1.0f) {
                    child.setAlpha(this.alpha.floatValue());
                }
                this.layout.addChild((Node)child, new Object[]{r - this.row, c - this.column});
            }
        }
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        if (this.modelRef.update()) {
            this.refreshGrid();
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "[elementId=" + this.getElementId() + "]";
    }
}

