/*
 * Decompiled with CFR 0.152.
 */
package com.sloydev.gallego;

import com.chernobyl.Chernobyl;
import com.sloydev.gallego.Function;
import com.sloydev.gallego.Optional;
import com.sloydev.gallego.Supplier;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;

final class Absent<T>
extends Optional<T> {
    static final Absent<Object> INSTANCE = new Absent();
    private static final long serialVersionUID = 0L;

    private Absent() {
    }

    static <T> Optional<T> withType() {
        return INSTANCE;
    }

    @Override
    public boolean isPresent() {
        return false;
    }

    @Override
    public T get() {
        throw new IllegalStateException("Optional.get() cannot be called on an absent value");
    }

    @Override
    public T or(T defaultValue) {
        return (T)Chernobyl.checkNotNull(defaultValue, (Object)"use Optional.orNull() instead of Optional.or(null)");
    }

    @Override
    public Optional<T> or(Optional<? extends T> secondChoice) {
        return (Optional)Chernobyl.checkNotNull(secondChoice);
    }

    @Override
    public T or(Supplier<? extends T> supplier) {
        return (T)Chernobyl.checkNotNull(supplier.get(), (Object)"use Optional.orNull() instead of a Supplier that returns null");
    }

    @Override
    @Nullable
    public T orNull() {
        return null;
    }

    @Override
    public Set<T> asSet() {
        return Collections.emptySet();
    }

    @Override
    public <V> Optional<V> transform(Function<? super T, V> function) {
        Chernobyl.checkNotNull(function);
        return Optional.absent();
    }

    @Override
    public boolean equals(@Nullable Object object) {
        return object == this;
    }

    @Override
    public int hashCode() {
        return 2040732332;
    }

    @Override
    public String toString() {
        return "Optional.absent()";
    }

    private Object readResolve() {
        return INSTANCE;
    }
}

