/*
 * Decompiled with CFR 0.152.
 */
package com.tunjid.androidbootstrap.functions.collections;

import com.tunjid.androidbootstrap.functions.Function;
import com.tunjid.androidbootstrap.functions.collections.Mask;
import com.tunjid.androidbootstrap.functions.collections.TransformingSequentialList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.Nullable;

public class Lists {
    public static <T> void replace(Collection<T> dest, Collection<T> src) {
        dest.clear();
        dest.addAll(src);
    }

    public static <F, T> List<T> transform(List<F> fromList, Function<? super F, ? extends T> fromFunction) {
        return Lists.transform(fromList, fromFunction, null);
    }

    public static <F, T> List<T> transform(List<F> fromList, Function<? super F, ? extends T> fromFunction, Function<? super T, ? extends F> toFunction) {
        return new TransformingSequentialList<F, T>(fromList, fromFunction, toFunction);
    }

    @Nullable
    public static <T> T findFirst(List<?> list, Class<T> typeClass) {
        for (Object item : list) {
            if (!typeClass.isAssignableFrom(item.getClass())) continue;
            return (T)item;
        }
        return null;
    }

    @Nullable
    public static <T> T findLast(List<?> list, Class<T> typeClass) {
        ListIterator<?> li = list.listIterator(list.size());
        while (li.hasPrevious()) {
            Object item = li.previous();
            if (!typeClass.isAssignableFrom(item.getClass())) continue;
            return (T)item;
        }
        return null;
    }

    public static <T, R> List<T> union(List<T> source, List<T> additions, Function<T, R> mappingFunction) {
        Function<Object, Mask> maskFunction = item -> new Mask(item, mappingFunction);
        HashSet<Mask> set = new HashSet<Mask>(Lists.transform(additions, maskFunction));
        set.addAll(Lists.transform(source, maskFunction));
        return Lists.transform(new ArrayList<Mask>(set), Mask::getItem);
    }
}

