/*
 * Decompiled with CFR 0.152.
 */
package com.tunjid.androidbootstrap.functions.collections;

import com.tunjid.androidbootstrap.functions.Function;

class Mask<T, R> {
    private final T item;
    private final Function<T, R> mappingFunction;

    Mask(T item, Function<T, R> mappingFunction) {
        this.item = item;
        this.mappingFunction = mappingFunction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Mask other = (Mask)o;
        if (!this.item.getClass().equals(other.item.getClass())) {
            return false;
        }
        R otherUnMasked = this.mappingFunction.apply(other.item);
        R unMasked = this.mappingFunction.apply(this.item);
        return unMasked.equals(otherUnMasked);
    }

    public int hashCode() {
        return this.mappingFunction.apply(this.item).hashCode();
    }

    T getItem() {
        return this.item;
    }
}

