/*
 * Decompiled with CFR 0.152.
 */
package com.tunjid.androidbootstrap.functions.collections;

import com.tunjid.androidbootstrap.functions.Function;
import java.util.AbstractSequentialList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

final class TransformingSequentialList<F, T>
extends AbstractSequentialList<T> {
    private final List<F> fromList;
    private final Function<? super T, ? extends F> toFunction;
    private final Function<? super F, ? extends T> fromFunction;

    TransformingSequentialList(List<F> fromList, Function<? super F, ? extends T> fromFunction, Function<? super T, ? extends F> toFunction) {
        this.fromList = fromList;
        this.toFunction = toFunction;
        this.fromFunction = fromFunction;
    }

    @Override
    public void clear() {
        this.fromList.clear();
    }

    @Override
    public int size() {
        return this.fromList.size();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        final ListIterator<F> fromListIterator = this.fromList.listIterator(index);
        return new TransformedListIterator<F, T>(fromListIterator){

            @Override
            T transform(F from) {
                return TransformingSequentialList.this.fromFunction.apply(from);
            }

            @Override
            public void set(T element) {
                if (TransformingSequentialList.this.toFunction == null) {
                    throw new UnsupportedOperationException();
                }
                fromListIterator.set(TransformingSequentialList.this.toFunction.apply(element));
            }

            @Override
            public void add(T element) {
                if (TransformingSequentialList.this.toFunction == null) {
                    throw new UnsupportedOperationException();
                }
                fromListIterator.add(TransformingSequentialList.this.toFunction.apply(element));
            }
        };
    }

    static abstract class TransformedIterator<F, T>
    implements Iterator<T> {
        final Iterator<? extends F> backingIterator;

        TransformedIterator(Iterator<? extends F> backingIterator) {
            this.backingIterator = backingIterator;
        }

        abstract T transform(F var1);

        @Override
        public final boolean hasNext() {
            return this.backingIterator.hasNext();
        }

        @Override
        public final T next() {
            return this.transform(this.backingIterator.next());
        }

        @Override
        public final void remove() {
            this.backingIterator.remove();
        }
    }

    static abstract class TransformedListIterator<F, T>
    extends TransformedIterator<F, T>
    implements ListIterator<T> {
        TransformedListIterator(ListIterator<? extends F> backingIterator) {
            super(backingIterator);
        }

        private ListIterator<? extends F> backingIterator() {
            return TransformedListIterator.cast(this.backingIterator);
        }

        @Override
        public final boolean hasPrevious() {
            return this.backingIterator().hasPrevious();
        }

        @Override
        public final T previous() {
            return this.transform(this.backingIterator().previous());
        }

        @Override
        public final int nextIndex() {
            return this.backingIterator().nextIndex();
        }

        @Override
        public final int previousIndex() {
            return this.backingIterator().previousIndex();
        }

        @Override
        public void set(T element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(T element) {
            throw new UnsupportedOperationException();
        }

        private static <T> ListIterator<T> cast(Iterator<T> iterator) {
            return (ListIterator)iterator;
        }
    }
}

