/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.theme.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.tuya.smart.theme.config.IThemeConfig;
import com.tuya.smart.theme.config.bean.ColorAlphaBean;
import com.tuya.smart.theme.config.bean.ColorBean;
import com.tuya.smart.theme.config.bean.CornerBean;
import com.tuya.smart.theme.config.bean.FontBean;
import com.tuya.smart.theme.config.bean.ThemeBean;
import com.tuya.smart.theme.config.core.DimenTransformer;
import com.tuya.smart.theme.config.core.FontTransformer;
import com.tuya.smart.theme.config.core.ThemeColorTransformer;
import com.tuya.smart.theme.config.core.ThemeForegroundColorTransformer;
import com.tuya.smart.theme.config.type.CornerType;
import com.tuya.smart.theme.config.type.ThemeType;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0016J\b\u0010\u0006\u001a\u00020\u0004H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\u0004H\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nH\u0016J \u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\bH\u0016J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/tuya/smart/theme/config/ThemeConfig;", "Lcom/tuya/smart/theme/config/IThemeConfig;", "()V", "themeBean", "Lcom/tuya/smart/theme/config/bean/ThemeBean;", "getDefaultDarkThemeBean", "getDefaultLightThemeBean", "getDimen", "", "type", "Lcom/tuya/smart/theme/config/type/ThemeType;", "getFont", "", "getThemeBean", "getThemeColor", "getThemeForegroundColor", "foregroundThemeType", "backgroundThemeType", "bgColor", "loadTheme", "", "configJson", "IConfigDataFetcher", "theme-config"})
public final class ThemeConfig
implements IThemeConfig {
    private static ThemeBean themeBean;
    public static final ThemeConfig INSTANCE;

    @Override
    public void loadTheme(@Nullable String configJson) {
        ThemeBean themeBean;
        CharSequence charSequence = configJson;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            themeBean = this.getDefaultLightThemeBean();
        } else {
            Object object = JSON.parseObject((String)configJson, ThemeBean.class, (Feature[])new Feature[]{Feature.DisableSpecialKeyDetect});
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"JSON.parseObject(configJ\u2026.DisableSpecialKeyDetect)");
            themeBean = (ThemeBean)object;
        }
        ThemeConfig.themeBean = themeBean;
    }

    @Override
    @NotNull
    public ThemeBean getThemeBean() {
        ThemeBean themeBean = ThemeConfig.themeBean;
        if (themeBean == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"themeBean");
        }
        return themeBean;
    }

    @Override
    @NotNull
    public ThemeBean getDefaultLightThemeBean() {
        String string;
        ColorBean colorBean = new ColorBean("#F8F8F8", "#FFFFFF", "#FFFFFF", "#FFFFFF", "#FFFFFF", "", "#FF5A28", "#FF4444", "#00CC99", "#1989FA", "#FF5A28");
        FontBean fontBean = new FontBean("", "");
        ColorAlphaBean colorAlphaBean = new ColorAlphaBean(Float.valueOf(0.9f), Float.valueOf(0.7f), Float.valueOf(0.5f), Float.valueOf(0.3f), Float.valueOf(0.7f), Float.valueOf(0.2f), Float.valueOf(0.1f), Float.valueOf(0.4f));
        String string2 = CornerType.ANGLE.name();
        Locale locale = Locale.getDefault();
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.getDefault()");
        Locale locale2 = locale;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase(locale2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
        String string5 = string4;
        string2 = CornerType.ANGLE.name();
        Locale locale3 = Locale.getDefault();
        Intrinsics.checkExpressionValueIsNotNull((Object)locale3, (String)"Locale.getDefault()");
        locale2 = locale3;
        bl = false;
        String string6 = string2;
        if (string6 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string7 = string6.toLowerCase(locale2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).toLowerCase(locale)");
        String string8 = string7;
        string2 = CornerType.ANGLE.name();
        Locale locale4 = Locale.getDefault();
        Intrinsics.checkExpressionValueIsNotNull((Object)locale4, (String)"Locale.getDefault()");
        locale2 = locale4;
        bl = false;
        String string9 = string2;
        if (string9 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string10 = string9.toLowerCase(locale2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"(this as java.lang.String).toLowerCase(locale)");
        String string11 = string = string10;
        String string12 = string8;
        String string13 = string5;
        CornerBean cornerBean = new CornerBean(string13, string12, string11);
        return new ThemeBean(colorBean, fontBean, colorAlphaBean, cornerBean);
    }

    @Override
    @NotNull
    public ThemeBean getDefaultDarkThemeBean() {
        String string;
        ColorBean colorBean = new ColorBean("#000000", "#1A1A1A", "#1A1A1A", "#1A1A1A", "#1A1A1A", "", "#FF5A28", "#FF4444", "#00CC99", "#1989FA", "#FF5A28");
        FontBean fontBean = new FontBean("", "");
        ColorAlphaBean colorAlphaBean = new ColorAlphaBean(Float.valueOf(1.0f), Float.valueOf(0.7f), Float.valueOf(0.5f), Float.valueOf(0.3f), Float.valueOf(1.0f), Float.valueOf(0.2f), Float.valueOf(0.1f), Float.valueOf(0.7f));
        String string2 = CornerType.ANGLE.name();
        Locale locale = Locale.getDefault();
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.getDefault()");
        Locale locale2 = locale;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase(locale2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
        String string5 = string4;
        string2 = CornerType.ANGLE.name();
        Locale locale3 = Locale.getDefault();
        Intrinsics.checkExpressionValueIsNotNull((Object)locale3, (String)"Locale.getDefault()");
        locale2 = locale3;
        bl = false;
        String string6 = string2;
        if (string6 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string7 = string6.toLowerCase(locale2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).toLowerCase(locale)");
        String string8 = string7;
        string2 = CornerType.ANGLE.name();
        Locale locale4 = Locale.getDefault();
        Intrinsics.checkExpressionValueIsNotNull((Object)locale4, (String)"Locale.getDefault()");
        locale2 = locale4;
        bl = false;
        String string9 = string2;
        if (string9 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string10 = string9.toLowerCase(locale2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"(this as java.lang.String).toLowerCase(locale)");
        String string11 = string = string10;
        String string12 = string8;
        String string13 = string5;
        CornerBean cornerBean = new CornerBean(string13, string12, string11);
        return new ThemeBean(colorBean, fontBean, colorAlphaBean, cornerBean);
    }

    @Override
    public int getThemeColor(@NotNull ThemeType type) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        ThemeBean themeBean = ThemeConfig.themeBean;
        if (themeBean == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"themeBean");
        }
        return ThemeColorTransformer.INSTANCE.getColor(type, themeBean);
    }

    @Override
    public int getThemeColor(@NotNull ThemeType type, @NotNull ThemeBean themeBean) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)themeBean, (String)"themeBean");
        return ThemeColorTransformer.INSTANCE.getColor(type, themeBean);
    }

    @Override
    public int getThemeForegroundColor(@NotNull ThemeType foregroundThemeType, @NotNull ThemeType backgroundThemeType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)foregroundThemeType), (String)"foregroundThemeType");
        Intrinsics.checkParameterIsNotNull((Object)((Object)backgroundThemeType), (String)"backgroundThemeType");
        ThemeBean themeBean = ThemeConfig.themeBean;
        if (themeBean == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"themeBean");
        }
        return ThemeForegroundColorTransformer.INSTANCE.getColor(foregroundThemeType, backgroundThemeType, themeBean);
    }

    @Override
    public int getThemeForegroundColor(@NotNull ThemeType foregroundThemeType, int bgColor) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)foregroundThemeType), (String)"foregroundThemeType");
        ThemeBean themeBean = ThemeConfig.themeBean;
        if (themeBean == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"themeBean");
        }
        return ThemeForegroundColorTransformer.INSTANCE.getColor(foregroundThemeType, bgColor, themeBean);
    }

    @Override
    public int getThemeForegroundColor(@NotNull ThemeType foregroundThemeType, @NotNull ThemeType backgroundThemeType, @NotNull ThemeBean themeBean) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)foregroundThemeType), (String)"foregroundThemeType");
        Intrinsics.checkParameterIsNotNull((Object)((Object)backgroundThemeType), (String)"backgroundThemeType");
        Intrinsics.checkParameterIsNotNull((Object)themeBean, (String)"themeBean");
        return ThemeForegroundColorTransformer.INSTANCE.getColor(foregroundThemeType, backgroundThemeType, themeBean);
    }

    @Override
    @NotNull
    public String getFont(@NotNull ThemeType type) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        ThemeBean themeBean = ThemeConfig.themeBean;
        if (themeBean == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"themeBean");
        }
        return FontTransformer.INSTANCE.getFont(type, themeBean);
    }

    @Override
    public int getDimen(@NotNull ThemeType type) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        ThemeBean themeBean = ThemeConfig.themeBean;
        if (themeBean == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"themeBean");
        }
        return DimenTransformer.INSTANCE.getDimen(type, themeBean);
    }

    private ThemeConfig() {
    }

    static {
        ThemeConfig themeConfig;
        INSTANCE = themeConfig = new ThemeConfig();
        themeConfig.loadTheme(null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/tuya/smart/theme/config/ThemeConfig$IConfigDataFetcher;", "", "load", "", "theme-config"})
    public static interface IConfigDataFetcher {
        @NotNull
        public String load();
    }
}

