/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.theme.config.core;

import com.tuya.smart.theme.config.bean.CornerBean;
import com.tuya.smart.theme.config.bean.ThemeBean;
import com.tuya.smart.theme.config.core.DimenTransformer$WhenMappings;
import com.tuya.smart.theme.config.exception.UnsupportedConfigException;
import com.tuya.smart.theme.config.type.CornerType;
import com.tuya.smart.theme.config.type.ThemeType;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u000e\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/tuya/smart/theme/config/core/DimenTransformer;", "", "()V", "angleKeyPrefix", "", "cornerConfig", "", "", "straightKeyPrefix", "getConfigKey", "type", "Lcom/tuya/smart/theme/config/type/ThemeType;", "isStraight", "", "getDimen", "themeBean", "Lcom/tuya/smart/theme/config/bean/ThemeBean;", "configValue", "theme-config"})
public final class DimenTransformer {
    private static final String straightKeyPrefix = "straight";
    private static final String angleKeyPrefix = "angle";
    private static final Map<String, Integer> cornerConfig;
    public static final DimenTransformer INSTANCE;

    public final int getDimen(@NotNull ThemeType type, @NotNull ThemeBean themeBean) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)themeBean, (String)"themeBean");
        switch (DimenTransformer$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                CornerBean cornerBean = themeBean.getCorner();
                Intrinsics.checkExpressionValueIsNotNull((Object)cornerBean, (String)"themeBean.corner");
                string = cornerBean.getButtonCornerType();
                break;
            }
            case 5: {
                CornerBean cornerBean = themeBean.getCorner();
                Intrinsics.checkExpressionValueIsNotNull((Object)cornerBean, (String)"themeBean.corner");
                string = cornerBean.getAlertCornerType();
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                CornerBean cornerBean = themeBean.getCorner();
                Intrinsics.checkExpressionValueIsNotNull((Object)cornerBean, (String)"themeBean.corner");
                string = cornerBean.getCardCornerType();
                break;
            }
            default: {
                throw (Throwable)new UnsupportedConfigException("Unsupported config type: " + type.name());
            }
        }
        String cornerConfigValue = string;
        String key = this.getConfigKey(type, this.isStraight(cornerConfigValue));
        Integer n = cornerConfig.get(key);
        return n != null ? n : 0;
    }

    private final String getConfigKey(ThemeType type, boolean isStraight) {
        return isStraight ? "straight_" + type.name() : "angle_" + type.name();
    }

    private final boolean isStraight(String configValue) {
        if (configValue == null) {
            return false;
        }
        String string = configValue;
        Locale locale = Locale.getDefault();
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.getDefault()");
        Locale locale2 = locale;
        boolean bl = false;
        String string2 = string.toLowerCase(locale2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase(locale)");
        string = CornerType.STRAIGHT.name();
        Locale locale3 = Locale.getDefault();
        Intrinsics.checkExpressionValueIsNotNull((Object)locale3, (String)"Locale.getDefault()");
        locale2 = locale3;
        String string3 = string2;
        bl = false;
        String string4 = string;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toLowerCase(locale2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
        String string6 = string5;
        return Intrinsics.areEqual((Object)string3, (Object)string6);
    }

    private DimenTransformer() {
    }

    static {
        DimenTransformer dimenTransformer;
        INSTANCE = dimenTransformer = new DimenTransformer();
        boolean bl = false;
        cornerConfig = new LinkedHashMap();
        cornerConfig.put(dimenTransformer.getConfigKey(ThemeType.C1, true), 4);
        cornerConfig.put(dimenTransformer.getConfigKey(ThemeType.C1, false), 32);
        cornerConfig.put(dimenTransformer.getConfigKey(ThemeType.C1_1, true), 4);
        cornerConfig.put(dimenTransformer.getConfigKey(ThemeType.C1_1, false), 24);
        cornerConfig.put(dimenTransformer.getConfigKey(ThemeType.C1_2, true), 4);
        cornerConfig.put(dimenTransformer.getConfigKey(ThemeType.C1_2, false), 20);
        cornerConfig.put(dimenTransformer.getConfigKey(ThemeType.C1_3, true), 4);
        cornerConfig.put(dimenTransformer.getConfigKey(ThemeType.C1_3, false), 15);
        cornerConfig.put(dimenTransformer.getConfigKey(ThemeType.C2, true), 4);
        cornerConfig.put(dimenTransformer.getConfigKey(ThemeType.C2, false), 16);
        cornerConfig.put(dimenTransformer.getConfigKey(ThemeType.C3_1, true), 4);
        cornerConfig.put(dimenTransformer.getConfigKey(ThemeType.C3_1, false), 16);
        cornerConfig.put(dimenTransformer.getConfigKey(ThemeType.C3_2, true), 4);
        cornerConfig.put(dimenTransformer.getConfigKey(ThemeType.C3_2, false), 12);
        cornerConfig.put(dimenTransformer.getConfigKey(ThemeType.C3_3, true), 4);
        cornerConfig.put(dimenTransformer.getConfigKey(ThemeType.C3_3, false), 8);
        cornerConfig.put(dimenTransformer.getConfigKey(ThemeType.C3_4, true), 4);
        cornerConfig.put(dimenTransformer.getConfigKey(ThemeType.C3_4, false), 4);
    }
}

