/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.theme.config.core;

import com.tuya.smart.theme.config.bean.ColorBean;
import com.tuya.smart.theme.config.bean.ThemeBean;
import com.tuya.smart.theme.config.core.ThemeColorTransformer$WhenMappings;
import com.tuya.smart.theme.config.exception.UnsupportedConfigException;
import com.tuya.smart.theme.config.type.ThemeType;
import com.tuya.smart.theme.config.util.ColorUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u001a\u0010\u000e\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0002J\"\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/tuya/smart/theme/config/core/ThemeColorTransformer;", "", "()V", "getBackgroundColor", "", "themeType", "Lcom/tuya/smart/theme/config/type/ThemeType;", "colorConfigValue", "", "appBgColor", "getColor", "type", "themeBean", "Lcom/tuya/smart/theme/config/bean/ThemeBean;", "getCommonBgColor", "getListBgColor", "getMainColor", "getPressColor", "color", "theme-config"})
public final class ThemeColorTransformer {
    public static final ThemeColorTransformer INSTANCE;

    public final int getColor(@NotNull ThemeType type, @NotNull ThemeBean themeBean) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)themeBean, (String)"themeBean");
        ColorBean colorBean = themeBean.getColors();
        Intrinsics.checkExpressionValueIsNotNull((Object)colorBean, (String)"themeBean.colors");
        String string = colorBean.getB1();
        if (string == null) {
            string = "#F8F8F8";
        }
        int appBgColor = ColorUtil.INSTANCE.parseColor(string);
        switch (ThemeColorTransformer$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: 
            case 2: {
                ColorBean colorBean2 = themeBean.getColors();
                Intrinsics.checkExpressionValueIsNotNull((Object)colorBean2, (String)"themeBean.colors");
                n = this.getBackgroundColor(type, colorBean2.getB1(), appBgColor);
                break;
            }
            case 3: 
            case 4: {
                ColorBean colorBean3 = themeBean.getColors();
                Intrinsics.checkExpressionValueIsNotNull((Object)colorBean3, (String)"themeBean.colors");
                n = this.getBackgroundColor(type, colorBean3.getB2(), appBgColor);
                break;
            }
            case 5: 
            case 6: {
                ColorBean colorBean4 = themeBean.getColors();
                Intrinsics.checkExpressionValueIsNotNull((Object)colorBean4, (String)"themeBean.colors");
                n = this.getBackgroundColor(type, colorBean4.getB3(), appBgColor);
                break;
            }
            case 7: 
            case 8: {
                ColorBean colorBean5 = themeBean.getColors();
                Intrinsics.checkExpressionValueIsNotNull((Object)colorBean5, (String)"themeBean.colors");
                n = this.getBackgroundColor(type, colorBean5.getB4(), appBgColor);
                break;
            }
            case 9: 
            case 10: {
                ColorBean colorBean6 = themeBean.getColors();
                Intrinsics.checkExpressionValueIsNotNull((Object)colorBean6, (String)"themeBean.colors");
                n = this.getBackgroundColor(type, colorBean6.getB5(), appBgColor);
                break;
            }
            case 11: 
            case 12: {
                n = this.getBackgroundColor(type, "", appBgColor);
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                ColorBean colorBean7 = themeBean.getColors();
                Intrinsics.checkExpressionValueIsNotNull((Object)colorBean7, (String)"themeBean.colors");
                n = this.getMainColor(type, colorBean7.getM1(), themeBean);
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                ColorBean colorBean8 = themeBean.getColors();
                Intrinsics.checkExpressionValueIsNotNull((Object)colorBean8, (String)"themeBean.colors");
                n = this.getMainColor(type, colorBean8.getM2(), themeBean);
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                ColorBean colorBean9 = themeBean.getColors();
                Intrinsics.checkExpressionValueIsNotNull((Object)colorBean9, (String)"themeBean.colors");
                n = this.getMainColor(type, colorBean9.getM3(), themeBean);
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                ColorBean colorBean10 = themeBean.getColors();
                Intrinsics.checkExpressionValueIsNotNull((Object)colorBean10, (String)"themeBean.colors");
                n = this.getMainColor(type, colorBean10.getM4(), themeBean);
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                ColorBean colorBean11 = themeBean.getColors();
                Intrinsics.checkExpressionValueIsNotNull((Object)colorBean11, (String)"themeBean.colors");
                n = this.getMainColor(type, colorBean11.getM5(), themeBean);
                break;
            }
            default: {
                throw (Throwable)new UnsupportedConfigException("Unsupported config type: " + type.name());
            }
        }
        return n;
    }

    private final int getBackgroundColor(ThemeType themeType, String colorConfigValue, int appBgColor) {
        int n;
        switch (ThemeColorTransformer$WhenMappings.$EnumSwitchMapping$1[themeType.ordinal()]) {
            case 1: {
                n = appBgColor;
                break;
            }
            case 2: {
                n = this.getPressColor(appBgColor);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n = this.getCommonBgColor(colorConfigValue, appBgColor);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n = this.getPressColor(this.getCommonBgColor(colorConfigValue, appBgColor));
                break;
            }
            case 11: {
                n = this.getListBgColor(appBgColor);
                break;
            }
            case 12: {
                n = this.getPressColor(this.getListBgColor(appBgColor));
                break;
            }
            default: {
                throw (Throwable)new UnsupportedConfigException("Unsupported config type: " + themeType.name());
            }
        }
        return n;
    }

    private final int getMainColor(ThemeType themeType, String colorConfigValue, ThemeBean themeBean) {
        int n;
        String alphaChannelPercent20 = ColorUtil.INSTANCE.floatToString(0.2f);
        String colorConfigValueNew = colorConfigValue;
        CharSequence charSequence = colorConfigValueNew;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            CharSequence charSequence2;
            switch (ThemeColorTransformer$WhenMappings.$EnumSwitchMapping$2[themeType.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    charSequence2 = "#FF5A28";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    charSequence2 = "#FF4444";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    charSequence2 = "#00CC99";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    charSequence2 = "#1989FA";
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    ColorBean colorBean = themeBean.getColors();
                    Intrinsics.checkExpressionValueIsNotNull((Object)colorBean, (String)"themeBean.colors");
                    if (colorBean.getM1() != null) {
                        ColorBean colorBean2 = themeBean.getColors();
                        Intrinsics.checkExpressionValueIsNotNull((Object)colorBean2, (String)"themeBean.colors");
                        if (Intrinsics.areEqual((Object)colorBean2.getM1(), (Object)"") ^ true) {
                            ColorBean colorBean3 = themeBean.getColors();
                            Intrinsics.checkExpressionValueIsNotNull((Object)colorBean3, (String)"themeBean.colors");
                            charSequence = colorBean3.getM1();
                            bl = false;
                            charSequence2 = charSequence;
                            if (charSequence2 != null) break;
                            charSequence2 = "";
                            break;
                        }
                    }
                    charSequence2 = "#FF5A28";
                    break;
                }
                default: {
                    charSequence2 = "#FF5A28";
                }
            }
            colorConfigValueNew = charSequence2;
        }
        switch (ThemeColorTransformer$WhenMappings.$EnumSwitchMapping$3[themeType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n = ColorUtil.INSTANCE.parseColor(colorConfigValueNew);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n = ColorUtil.INSTANCE.parseColor(ColorUtil.INSTANCE.appendAlphaChannel(colorConfigValueNew, alphaChannelPercent20));
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n = this.getPressColor(ColorUtil.INSTANCE.parseColor(colorConfigValueNew));
                break;
            }
            default: {
                n = ColorUtil.INSTANCE.parseColor(colorConfigValueNew);
            }
        }
        return n;
    }

    private final int getPressColor(int color) {
        int alphaColor = ColorUtil.INSTANCE.isLightColor(color) ? ColorUtil.INSTANCE.argb(0.1f, 0.0f, 0.0f, 0.0f) : ColorUtil.INSTANCE.argb(0.1f, 1.0f, 1.0f, 1.0f);
        return ColorUtil.INSTANCE.blendARGB(alphaColor, color);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int getCommonBgColor(String colorConfigValue, int appBgColor) {
        int n;
        boolean isLight = ColorUtil.INSTANCE.isLightColor(appBgColor);
        int lightColor = ColorUtil.INSTANCE.parseColor("#FFFFFF");
        int darkColor = ColorUtil.INSTANCE.blendARGB(ColorUtil.INSTANCE.argb(0.1f, 1.0f, 1.0f, 1.0f), appBgColor);
        String string = colorConfigValue;
        if (string != null) {
            CharSequence charSequence = string;
            boolean bl = false;
            if (charSequence.length() > 0) {
                n = ColorUtil.INSTANCE.parseColor(colorConfigValue);
                return n;
            }
        }
        n = isLight ? lightColor : darkColor;
        return n;
    }

    private final int getListBgColor(int appBgColor) {
        boolean isLight = ColorUtil.INSTANCE.isLightColor(appBgColor);
        int lightColor = ColorUtil.INSTANCE.argb(1.0f, 1.0f, 1.0f, 1.0f);
        int darkColor = ColorUtil.INSTANCE.blendARGB(ColorUtil.INSTANCE.argb(0.1f, 1.0f, 1.0f, 1.0f), appBgColor);
        return isLight ? lightColor : darkColor;
    }

    private ThemeColorTransformer() {
    }

    static {
        ThemeColorTransformer themeColorTransformer;
        INSTANCE = themeColorTransformer = new ThemeColorTransformer();
    }
}

