/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.theme.config.core;

import com.tuya.smart.theme.config.bean.ColorAlphaBean;
import com.tuya.smart.theme.config.bean.ThemeBean;
import com.tuya.smart.theme.config.core.ThemeColorTransformer;
import com.tuya.smart.theme.config.core.ThemeForegroundColorTransformer$WhenMappings;
import com.tuya.smart.theme.config.exception.UnsupportedConfigException;
import com.tuya.smart.theme.config.type.ThemeType;
import com.tuya.smart.theme.config.util.ColorUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u001f\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u000eJ/\u0010\u000f\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/tuya/smart/theme/config/core/ThemeForegroundColorTransformer;", "", "()V", "getColor", "", "foregroundThemeType", "Lcom/tuya/smart/theme/config/type/ThemeType;", "backgroundThemeType", "themeBean", "Lcom/tuya/smart/theme/config/bean/ThemeBean;", "bgColor", "getN8Color", "colorConfigValue", "", "(Ljava/lang/Float;I)I", "getTextColor", "lightDefValue", "darkDefValue", "(Ljava/lang/Float;IFF)I", "theme-config"})
public final class ThemeForegroundColorTransformer {
    public static final ThemeForegroundColorTransformer INSTANCE;

    public final int getColor(@NotNull ThemeType foregroundThemeType, @NotNull ThemeType backgroundThemeType, @NotNull ThemeBean themeBean) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)foregroundThemeType), (String)"foregroundThemeType");
        Intrinsics.checkParameterIsNotNull((Object)((Object)backgroundThemeType), (String)"backgroundThemeType");
        Intrinsics.checkParameterIsNotNull((Object)themeBean, (String)"themeBean");
        if (backgroundThemeType == ThemeType.M1 || backgroundThemeType == ThemeType.M1_1 || backgroundThemeType == ThemeType.M1_2 || backgroundThemeType == ThemeType.M2 || backgroundThemeType == ThemeType.M2_1 || backgroundThemeType == ThemeType.M2_2 || backgroundThemeType == ThemeType.M3 || backgroundThemeType == ThemeType.M3_1 || backgroundThemeType == ThemeType.M3_2 || backgroundThemeType == ThemeType.M4 || backgroundThemeType == ThemeType.M4_1 || backgroundThemeType == ThemeType.M4_2) {
            return ColorUtil.INSTANCE.argb(1.0f, 1.0f, 1.0f, 1.0f);
        }
        int bgColor = ThemeColorTransformer.INSTANCE.getColor(backgroundThemeType, themeBean);
        return this.getColor(foregroundThemeType, bgColor, themeBean);
    }

    public final int getColor(@NotNull ThemeType foregroundThemeType, int bgColor, @NotNull ThemeBean themeBean) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)((Object)foregroundThemeType), (String)"foregroundThemeType");
        Intrinsics.checkParameterIsNotNull((Object)themeBean, (String)"themeBean");
        switch (ThemeForegroundColorTransformer$WhenMappings.$EnumSwitchMapping$0[foregroundThemeType.ordinal()]) {
            case 1: {
                ColorAlphaBean colorAlphaBean = themeBean.getColorAlpha();
                Intrinsics.checkExpressionValueIsNotNull((Object)colorAlphaBean, (String)"themeBean.colorAlpha");
                n = this.getTextColor(colorAlphaBean.getN1(), bgColor, 0.9f, 1.0f);
                break;
            }
            case 2: {
                ColorAlphaBean colorAlphaBean = themeBean.getColorAlpha();
                Intrinsics.checkExpressionValueIsNotNull((Object)colorAlphaBean, (String)"themeBean.colorAlpha");
                n = this.getTextColor(colorAlphaBean.getN2(), bgColor, 0.7f, 0.7f);
                break;
            }
            case 3: {
                ColorAlphaBean colorAlphaBean = themeBean.getColorAlpha();
                Intrinsics.checkExpressionValueIsNotNull((Object)colorAlphaBean, (String)"themeBean.colorAlpha");
                n = this.getTextColor(colorAlphaBean.getN3(), bgColor, 0.5f, 0.5f);
                break;
            }
            case 4: {
                ColorAlphaBean colorAlphaBean = themeBean.getColorAlpha();
                Intrinsics.checkExpressionValueIsNotNull((Object)colorAlphaBean, (String)"themeBean.colorAlpha");
                n = this.getTextColor(colorAlphaBean.getN4(), bgColor, 0.3f, 0.3f);
                break;
            }
            case 5: {
                ColorAlphaBean colorAlphaBean = themeBean.getColorAlpha();
                Intrinsics.checkExpressionValueIsNotNull((Object)colorAlphaBean, (String)"themeBean.colorAlpha");
                n = this.getTextColor(colorAlphaBean.getN5(), bgColor, 0.7f, 1.0f);
                break;
            }
            case 6: {
                ColorAlphaBean colorAlphaBean = themeBean.getColorAlpha();
                Intrinsics.checkExpressionValueIsNotNull((Object)colorAlphaBean, (String)"themeBean.colorAlpha");
                n = this.getTextColor(colorAlphaBean.getN6(), bgColor, 0.2f, 0.2f);
                break;
            }
            case 7: {
                ColorAlphaBean colorAlphaBean = themeBean.getColorAlpha();
                Intrinsics.checkExpressionValueIsNotNull((Object)colorAlphaBean, (String)"themeBean.colorAlpha");
                n = this.getTextColor(colorAlphaBean.getN7(), bgColor, 0.1f, 0.1f);
                break;
            }
            case 8: {
                ColorAlphaBean colorAlphaBean = themeBean.getColorAlpha();
                Intrinsics.checkExpressionValueIsNotNull((Object)colorAlphaBean, (String)"themeBean.colorAlpha");
                n = this.getN8Color(colorAlphaBean.getN8(), bgColor);
                break;
            }
            default: {
                throw (Throwable)new UnsupportedConfigException("Unsupported type: " + foregroundThemeType.name());
            }
        }
        return n;
    }

    private final int getTextColor(Float colorConfigValue, int bgColor, float lightDefValue, float darkDefValue) {
        boolean isLight = ColorUtil.INSTANCE.isLightColor(bgColor);
        Float f = colorConfigValue;
        float alpha = f != null ? f.floatValue() : (isLight ? lightDefValue : darkDefValue);
        String color = isLight ? "#000000" : "#FFFFFF";
        return ColorUtil.INSTANCE.parseColor(ColorUtil.INSTANCE.appendAlphaChannel(color, ColorUtil.INSTANCE.floatToString(alpha)));
    }

    private final int getN8Color(Float colorConfigValue, int bgColor) {
        boolean isLight = ColorUtil.INSTANCE.isLightColor(bgColor);
        Float f = colorConfigValue;
        float alpha = f != null ? f.floatValue() : (isLight ? 0.4f : 0.7f);
        return ColorUtil.INSTANCE.parseColor(ColorUtil.INSTANCE.appendAlphaChannel("#000000", ColorUtil.INSTANCE.floatToString(alpha)));
    }

    private ThemeForegroundColorTransformer() {
    }

    static {
        ThemeForegroundColorTransformer themeForegroundColorTransformer;
        INSTANCE = themeForegroundColorTransformer = new ThemeForegroundColorTransformer();
    }
}

