/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.theme.config.util;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rJ&\u0010\u0010\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011J\u0016\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006J\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006J\u0016\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0011J\u000e\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0011J\u000e\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u0011J\u000e\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u0006J\u000e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u0006J\u000e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u0006J\u000e\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\rJ\u000e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006J\u000e\u0010\"\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0006\u00a8\u0006#"}, d2={"Lcom/tuya/smart/theme/config/util/ColorUtil;", "", "()V", "RGBtoHSB", "", "r", "", "g", "b", "hsbvals", "alpha", "color", "appendAlphaChannel", "", "colorRGB", "alphaHex", "argb", "", "red", "green", "blue", "blendARGB", "color1", "color2", "colorWithAlpha", "floatToInt", "channel", "floatToString", "formatChannelDigit", "isDarkColor", "", "isLightColor", "parseColor", "colorString", "valueOf", "theme-config"})
public final class ColorUtil {
    public static final ColorUtil INSTANCE;

    public final boolean isLightColor(int colorRGB) {
        float[] hsv = ColorUtil.RGBtoHSB$default(this, this.red(colorRGB), this.green(colorRGB), this.blue(colorRGB), null, 8, null);
        if (hsv == null || hsv.length != 3) {
            return false;
        }
        double d = hsv[1];
        return d >= 0.0 && d <= 0.4 && (d = (double)hsv[2]) >= 0.6 && d <= 1.0;
    }

    public final boolean isDarkColor(int colorRGB) {
        return !this.isLightColor(colorRGB);
    }

    public final int colorWithAlpha(int color, float alpha) {
        float red = (float)this.red(color) / 255.0f;
        float green = (float)this.green(color) / 255.0f;
        float blue = (float)this.blue(color) / 255.0f;
        return this.argb(alpha, red, green, blue);
    }

    public final int blendARGB(int color1, int color2) {
        float alpha1 = (float)this.alpha(color1) / 255.0f;
        float red1 = (float)this.red(color1) / 255.0f;
        float green1 = (float)this.green(color1) / 255.0f;
        float blue1 = (float)this.blue(color1) / 255.0f;
        float alpha2 = (float)this.alpha(color2) / 255.0f;
        float red2 = (float)this.red(color2) / 255.0f;
        float green2 = (float)this.green(color2) / 255.0f;
        float blue2 = (float)this.blue(color2) / 255.0f;
        float alpha = 1.0f - (1.0f - alpha1) * (1.0f - alpha2);
        float red = (alpha1 * red1 + (1.0f - alpha1) * red2 * alpha2) / alpha;
        float green = (alpha1 * green1 + (1.0f - alpha1) * green2 * alpha2) / alpha;
        float blue = (alpha1 * blue1 + (1.0f - alpha1) * blue2 * alpha2) / alpha;
        return this.argb(alpha, red, green, blue);
    }

    public final int parseColor(@NotNull String colorString) {
        Intrinsics.checkParameterIsNotNull((Object)colorString, (String)"colorString");
        if (colorString.charAt(0) == '#') {
            String string = colorString;
            int n = 1;
            boolean bl = false;
            String string2 = string.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            string = string2;
            n = 16;
            bl = false;
            long color = Long.parseLong(string, CharsKt.checkRadix((int)n));
            if (colorString.length() == 7) {
                color |= 0xFF000000L;
            } else if (colorString.length() != 9) {
                throw (Throwable)new IllegalArgumentException("Unknown color");
            }
            return (int)color;
        }
        throw (Throwable)new IllegalArgumentException("Unknown color");
    }

    @NotNull
    public final String valueOf(int color) {
        int r = this.red(color);
        int g = this.green(color);
        int b = this.blue(color);
        int a = this.alpha(color);
        return '#' + this.formatChannelDigit(a) + this.formatChannelDigit(r) + this.formatChannelDigit(g) + this.formatChannelDigit(b);
    }

    @NotNull
    public final String formatChannelDigit(int channel) {
        String string;
        int n = channel;
        int n2 = 16;
        int n3 = 0;
        String string2 = Integer.toString(n, CharsKt.checkRadix((int)n2));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
        String hexString = string2;
        if (hexString.length() > 1) {
            String string3 = hexString;
            n2 = 0;
            n3 = 2;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n2, n3);
            string = string5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string = '0' + hexString;
        }
        return string;
    }

    @NotNull
    public final String appendAlphaChannel(@NotNull String colorRGB, @NotNull String alphaHex) {
        Intrinsics.checkParameterIsNotNull((Object)colorRGB, (String)"colorRGB");
        Intrinsics.checkParameterIsNotNull((Object)alphaHex, (String)"alphaHex");
        if (colorRGB.length() != 7 && colorRGB.length() != 9) {
            throw (Throwable)new IllegalArgumentException("Unknown color");
        }
        return '#' + (colorRGB.length() == 7 ? alphaHex : "") + StringsKt.replace$default((String)colorRGB, (String)"#", (String)"", (boolean)false, (int)4, null);
    }

    public final int floatToInt(float channel) {
        double d = (double)channel * 256.0;
        double d2 = 255.0;
        int n = 0;
        boolean bl = false;
        double d3 = Math.floor(d);
        return RangesKt.coerceAtLeast((int)n, (int)((int)RangesKt.coerceAtMost((double)d2, (double)d3)));
    }

    @NotNull
    public final String floatToString(float channel) {
        return this.formatChannelDigit(this.floatToInt(channel));
    }

    @Nullable
    public final float[] RGBtoHSB(int r, int g, int b, @Nullable float[] hsbvals) {
        float saturation;
        float[] hsbvalsNew = hsbvals;
        float hue = 0.0f;
        if (hsbvalsNew == null) {
            hsbvalsNew = new float[3];
        }
        int cmax = RangesKt.coerceAtLeast((int)RangesKt.coerceAtLeast((int)r, (int)g), (int)b);
        int cmin = RangesKt.coerceAtMost((int)RangesKt.coerceAtMost((int)r, (int)g), (int)b);
        float brightness = (float)cmax / 255.0f;
        float f = saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (float)(cmax - r) / (float)(cmax - cmin);
            float greenc = (float)(cmax - g) / (float)(cmax - cmin);
            float bluec = (float)(cmax - b) / (float)(cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        hsbvalsNew[0] = hue;
        hsbvalsNew[1] = saturation;
        hsbvalsNew[2] = brightness;
        return hsbvalsNew;
    }

    public static /* synthetic */ float[] RGBtoHSB$default(ColorUtil colorUtil, int n, int n2, int n3, float[] fArray, int n4, Object object) {
        if ((n4 & 8) != 0) {
            fArray = null;
        }
        return colorUtil.RGBtoHSB(n, n2, n3, fArray);
    }

    public final int argb(float alpha, float red, float green, float blue) {
        return (int)(alpha * 255.0f + 0.5f) << 24 | (int)(red * 255.0f + 0.5f) << 16 | (int)(green * 255.0f + 0.5f) << 8 | (int)(blue * 255.0f + 0.5f);
    }

    public final int alpha(int color) {
        return color >>> 24;
    }

    public final int red(int color) {
        return color >> 16 & 0xFF;
    }

    public final int green(int color) {
        return color >> 8 & 0xFF;
    }

    public final int blue(int color) {
        return color & 0xFF;
    }

    private ColorUtil() {
    }

    static {
        ColorUtil colorUtil;
        INSTANCE = colorUtil = new ColorUtil();
    }
}

