/*
 * Decompiled with CFR 0.152.
 */
package com.miui.deviceid;

import android.content.Context;
import android.util.Log;
import java.lang.reflect.Method;

public class IdentifierManager {
    private static final String TAG = "IdentifierManager";
    private static Object sIdProivderImpl;
    private static Class<?> sClass;
    private static Method sGetUDID;
    private static Method sGetOAID;
    private static Method sGetVAID;
    private static Method sGetAAID;

    public static boolean isSupported() {
        return sClass != null && sIdProivderImpl != null;
    }

    public static String getUDID(Context context) {
        return IdentifierManager.invokeMethod(context, sGetUDID);
    }

    public static String getOAID(Context context) {
        return IdentifierManager.invokeMethod(context, sGetOAID);
    }

    public static String getVAID(Context context) {
        return IdentifierManager.invokeMethod(context, sGetVAID);
    }

    public static String getAAID(Context context) {
        return IdentifierManager.invokeMethod(context, sGetAAID);
    }

    private static String invokeMethod(Context context, Method method) {
        if (sIdProivderImpl != null && method != null) {
            try {
                Object result = method.invoke(sIdProivderImpl, context);
                if (result != null) {
                    return (String)result;
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"invoke exception!", (Throwable)e);
            }
        }
        return null;
    }

    static {
        sGetUDID = null;
        sGetOAID = null;
        sGetVAID = null;
        sGetAAID = null;
        try {
            sClass = Class.forName("com.android.id.impl.IdProviderImpl");
            sIdProivderImpl = sClass.newInstance();
            sGetUDID = sClass.getMethod("getUDID", Context.class);
            sGetOAID = sClass.getMethod("getOAID", Context.class);
            sGetVAID = sClass.getMethod("getVAID", Context.class);
            sGetAAID = sClass.getMethod("getAAID", Context.class);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"reflect exception!", (Throwable)e);
        }
    }
}

