/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.squidb.json;

import com.yahoo.squidb.data.AbstractModel;
import com.yahoo.squidb.json.JSONMapper;
import com.yahoo.squidb.json.JSONProperty;
import com.yahoo.squidb.utility.Logger;
import java.lang.reflect.Type;

public class JSONPropertySupport {
    private static final String TAG = "squidb-json";
    private static JSONMapper MAPPER = null;

    public static void setJSONMapper(JSONMapper jsonMapper) {
        MAPPER = jsonMapper;
    }

    public static <T> T getValueFromJSON(AbstractModel model, JSONProperty<T> property, Type javaType) {
        if (!model.hasTransitory(property.getName())) {
            T data = null;
            if (model.containsNonNullValue(property)) {
                String value = (String)model.get(property);
                try {
                    if (MAPPER == null) {
                        throw new NullPointerException("JSONPropertySupport needs to be initialized with a JSONMapper instance using setJSONMapper()");
                    }
                    data = MAPPER.fromJSON(value, javaType);
                }
                catch (Exception e) {
                    Logger.w((String)TAG, (String)("Error deserializing JSON string: " + value), (Throwable)e);
                    model.clearValue(property);
                }
            }
            model.putTransitory(property.getName(), data);
            return data;
        }
        return (T)model.getTransitory(property.getName());
    }

    public static <T> boolean setValueAsJSON(AbstractModel model, JSONProperty<T> property, T data, Type javaType) {
        try {
            String json = null;
            if (data != null) {
                if (MAPPER == null) {
                    throw new NullPointerException("JSONPropertySupport needs to be initialized with a JSONMapper instance using setJSONMapper()");
                }
                json = MAPPER.toJSON(data, javaType);
                if (model.containsNonNullValue(property) && json.equals(model.get(property))) {
                    return false;
                }
            }
            model.set(property, json);
            model.putTransitory(property.getName(), data);
            return true;
        }
        catch (Exception e) {
            Logger.w((String)TAG, (String)("Error serializing object to JSON string: " + data), (Throwable)e);
            return false;
        }
    }
}

